/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import com.google.common.base.Function;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.AbstractMessageChannelSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLEvaluatingMessageChannelSecurity
extends AbstractMessageChannelSecurity {
    private Logger log = LoggerFactory.getLogger(URLEvaluatingMessageChannelSecurity.class);
    private boolean defaultPortInsecure = true;
    @NonnullAfterInit
    private Function<MessageContext, String> urlLookup;
    @Nullable
    private String url;
    @Nullable
    private URLBuilder urlBuilder;

    public void setDefaultPortInsecure(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultPortInsecure = flag;
    }

    public void setURLLookup(@Nullable Function<MessageContext, String> function) {
        this.urlLookup = function;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.urlLookup == null) {
            throw new ComponentInitializationException("Destination URL lookup function is required");
        }
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.url = (String)this.urlLookup.apply((Object)messageContext);
        if (this.url != null) {
            try {
                this.urlBuilder = new URLBuilder(this.url);
                return super.doPreInvoke(messageContext);
            }
            catch (MalformedURLException e) {
                this.log.warn("Unable to parse resolved target URL: {}", (Object)this.url, (Object)e);
                return false;
            }
        }
        this.log.warn("No target URL resolved, skipping MessageChannelSecurityContext population");
        return false;
    }

    protected void doInvoke(MessageContext messageContext) {
        MessageChannelSecurityContext channelContext = (MessageChannelSecurityContext)this.getParentContext().getSubcontext(MessageChannelSecurityContext.class, true);
        String scheme = this.urlBuilder.getScheme();
        Integer port = this.urlBuilder.getPort() != null ? this.urlBuilder.getPort() : ("https".equalsIgnoreCase(scheme) ? Integer.valueOf(443) : null);
        this.log.debug("Evaluating message channel security for scheme '{}' and port '{}' for URL: {}", new Object[]{scheme, port, this.url});
        if ("https".equalsIgnoreCase(scheme) && (!this.defaultPortInsecure || port != 443)) {
            channelContext.setConfidentialityActive(true);
            channelContext.setIntegrityActive(true);
        } else {
            channelContext.setConfidentialityActive(false);
            channelContext.setIntegrityActive(false);
        }
        this.log.debug("Set MessageChannelSecurityContext isIntegrityActive: {}", (Object)channelContext.isIntegrityActive());
        this.log.debug("Set MessageChannelSecurityContext isConfidentialityActive: {}", (Object)channelContext.isConfidentialityActive());
    }
}

