/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modifydn;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestEntryName
extends GrammarAction<LdapMessageContainer<ModifyDnRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestEntryName.class);

    public StoreModifyDnRequestEntryName() {
        super("Store ModifyDN request entry Name");
    }

    public void action(LdapMessageContainer<ModifyDnRequest> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_05119_NULL_ENTRY, (Object[])new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            Dn entry = new Dn(new String[]{dnStr});
            modifyDnRequest.setName(entry);
        }
        catch (LdapInvalidDnException ine) {
            String msg = I18n.err((I18n)I18n.ERR_05113_INVALID_DN, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes)});
            LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05137_MODIFYING_DN, (Object[])new Object[]{modifyDnRequest.getName()}));
        }
    }
}

