/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.backend.hashicorp.vault.HashicorpVaultAliasService;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.security.AbstractAliasService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;
import org.apache.knox.gateway.services.security.impl.RemoteAliasService;
import org.apache.knox.gateway.services.security.impl.ZookeeperRemoteAliasService;
import org.apache.knox.gateway.services.security.impl.ZookeeperRemoteAliasServiceProvider;

public class AliasServiceFactory
extends AbstractServiceFactory {
    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        AbstractAliasService service = null;
        if (this.shouldCreateService(implementation)) {
            DefaultAliasService defaultAliasService = new DefaultAliasService();
            defaultAliasService.setMasterService(this.getMasterService(gatewayServices));
            defaultAliasService.setKeystoreService(this.getKeystoreService(gatewayServices));
            defaultAliasService.init(gatewayConfig, options);
            if (this.matchesImplementation(implementation, DefaultAliasService.class, true)) {
                service = defaultAliasService;
            } else if (this.matchesImplementation(implementation, HashicorpVaultAliasService.class)) {
                service = new HashicorpVaultAliasService((AliasService)defaultAliasService);
            } else if (this.matchesImplementation(implementation, RemoteAliasService.class)) {
                service = new RemoteAliasService((AliasService)defaultAliasService, this.getMasterService(gatewayServices));
            } else if (this.matchesImplementation(implementation, ZookeeperRemoteAliasService.class)) {
                service = new ZookeeperRemoteAliasServiceProvider().newInstance(gatewayServices, (AliasService)defaultAliasService, this.getMasterService(gatewayServices));
            }
            this.logServiceUsage(implementation, serviceType);
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.ALIAS_SERVICE;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.unmodifiableList(Arrays.asList(DefaultAliasService.class.getName(), HashicorpVaultAliasService.class.getName(), RemoteAliasService.class.getName(), ZookeeperRemoteAliasService.class.getName()));
    }
}

