/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.hook;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.computation.executor.conf.ComputationExecutorConf$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext$;
import org.apache.linkis.engineconn.core.engineconn.EngineConnManager$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.LabelExecutor;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.udf.UDFClient$;
import org.apache.linkis.udf.vo.UDFInfoVo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005me!\u0002\n\u0014\u0003\u0003\u0011\u0003\"B\u0019\u0001\t\u0003\u0011\u0004bB\u001b\u0001\u0005\u00045\tB\u000e\u0005\b\u0007\u0002\u0011\rQ\"\u0005E\u0011\u001di\u0005A1A\u0007\u00129Cq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001c\u0005\u0006o\u0002!\t\u0002\u001f\u0005\u0006w\u00021\t\u0002 \u0005\b\u0003\u001f\u0001A\u0011CA\t\u0011\u001d\tI\u0002\u0001C\t\u00037Aa!a\n\u0001\t#!\u0005bBA\u0015\u0001\u0011E\u00111\u0006\u0005\b\u0003S\u0001A\u0011CA\u0019\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002`\u0001!\t\"!\u0019\t\u000f\u0005E\u0004\u0001\"\u0005\u0002t\t9Q\u000b\u0012$M_\u0006$'B\u0001\u000b\u0016\u0003\u0011Awn\\6\u000b\u0005Y9\u0012\u0001C3yK\u000e,Ho\u001c:\u000b\u0005aI\u0012aC2p[B,H/\u0019;j_:T!AG\u000e\u0002\u0015\u0015tw-\u001b8fG>tgN\u0003\u0002\u001d;\u00051A.\u001b8lSNT!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bU$\u0018\u000e\\:\u000b\u00059Z\u0012AB2p[6|g.\u0003\u00021W\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u0014\u0003\u001d)HM\u001a+za\u0016,\u0012a\u000e\t\u0003q\u0001s!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005q\n\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\tyT%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%A\u0002\"jO&sGO\u0003\u0002@K\u0005A1-\u0019;fO>\u0014\u00180F\u0001F!\t1%J\u0004\u0002H\u0011B\u0011!(J\u0005\u0003\u0013\u0016\na\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011*J\u0001\beVtG+\u001f9f+\u0005y\u0005C\u0001)j\u001d\t\tfM\u0004\u0002SG:\u00111\u000b\u0019\b\u0003)vs!!V.\u000f\u0005YSfBA,Z\u001d\tQ\u0004,C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011AlG\u0001\b[\u0006t\u0017mZ3s\u0013\tqv,A\u0003mC\n,GN\u0003\u0002]7%\u0011\u0011MY\u0001\u0007K:$\u0018\u000e^=\u000b\u0005y{\u0016B\u00013f\u0003\u0019)gnZ5oK*\u0011\u0011MY\u0005\u0003O\"\fqAU;o)f\u0004XM\u0003\u0002eK&\u0011!n\u001b\u0002\b%VtG+\u001f9f\u0015\t9\u0007.A\u0005c[2\u001cE.[3oiV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u000611\r\\5f]RT!a]\u000e\u0002\u0007\tlG.\u0003\u0002va\nI!)\u001c7DY&,g\u000e^\u0001\u000bE6d7\t\\5f]R\u0004\u0013AD4fiJ+\u0017\r\u001c*v]RK\b/\u001a\u000b\u0003\u001ffDQA_\u0004A\u0002\u0015\u000b!\"\u001a8hS:,G+\u001f9f\u00035\u0019wN\\:ueV\u001cGoQ8eKR\u0011Q) \u0005\u0006}\"\u0001\ra`\u0001\bk\u00124\u0017J\u001c4p!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t!A^8\u000b\u0007\u0005%1$A\u0002vI\u001aLA!!\u0004\u0002\u0004\tIQ\u000b\u0012$J]\u001a|gk\\\u0001\rO\u0016tWM]1uK\u000e{G-\u001a\u000b\u0003\u0003'\u0001B\u0001JA\u000b\u000b&\u0019\u0011qC\u0013\u0003\u000b\u0005\u0013(/Y=\u0002\u001d\u0005\u001c7-\u001a9u\u0007>$W\rV=qKR!\u0011QDA\u0012!\r!\u0013qD\u0005\u0004\u0003C)#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003KQ\u0001\u0019A#\u0002\t1Lg.Z\u0001\u000fO\u0016$Hj\\1e+\u001247i\u001c3f\u0003!\u0011X-\u00193GS2,GcA#\u0002.!1\u0011q\u0006\u0007A\u0002\u0015\u000bA\u0001]1uQR9Q)a\r\u00028\u0005m\u0002BBA\u001b\u001b\u0001\u0007Q)\u0001\u0003vg\u0016\u0014\bBBA\u001d\u001b\u0001\u0007Q)\u0001\u0006sKN|WO]2f\u0013\u0012Da!!\u0010\u000e\u0001\u0004)\u0015a\u0004:fg>,(oY3WKJ\u001c\u0018n\u001c8\u0002\u001f\u001d,GOR;oGRLwN\\\"pI\u0016,\"!a\u0005\u0002'\u0015DXmY;uK\u001a+hn\u0019;j_:\u001cu\u000eZ3\u0015\r\u0005\u001d\u0013QJA)!\r!\u0013\u0011J\u0005\u0004\u0003\u0017*#\u0001B+oSRDq!a\u0014\u0010\u0001\u0004\t\u0019\"A\u0003d_\u0012,7\u000f\u0003\u0004\u0017\u001f\u0001\u0007\u00111\u000b\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011L\u000b\u0002\u000f\u0015DXmY;uK&!\u0011QLA,\u0005M\u0019u.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u00035aw.\u00193Gk:\u001cG/[8ogR!\u0011qIA2\u0011\u00191\u0002\u00031\u0001\u0002fA!\u0011qMA7\u001b\t\tIGC\u0002b\u0003WR!AF\r\n\t\u0005=\u0014\u0011\u000e\u0002\t\u000bb,7-\u001e;pe\u00069An\\1e+\u00123E\u0003BA$\u0003kBq!a\u001e\u0012\u0001\u0004\tI(\u0001\u0004mC\n,Gn\u001d\t\u0006I\u0005U\u00111\u0010\u0019\u0005\u0003{\nI\t\u0005\u0004\u0002\u0000\u0005\u0005\u0015QQ\u0007\u0002K&\u0019\u00111Q3\u0003\u000b1\u000b'-\u001a7\u0011\t\u0005\u001d\u0015\u0011\u0012\u0007\u0001\t1\tY)!\u001e\u0002\u0002\u0003\u0005)\u0011AAG\u0005\ryF%M\t\u0005\u0003\u001f\u000b)\nE\u0002%\u0003#K1!a%&\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001JAL\u0013\r\tI*\n\u0002\u0004\u0003:L\b")
public abstract class UDFLoad
implements Logging {
    private final BmlClient bmlClient;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UDFLoad uDFLoad = this;
        synchronized (uDFLoad) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public abstract BigInt udfType();

    public abstract String category();

    public abstract Enumeration.Value runType();

    private BmlClient bmlClient() {
        return this.bmlClient;
    }

    public Enumeration.Value getRealRunType(String engineType) {
        return this.runType();
    }

    public abstract String constructCode(UDFInfoVo var1);

    public String[] generateCode() {
        ArrayBuffer codeBuffer;
        block0: {
            codeBuffer = new ArrayBuffer();
            ArrayBuffer statementBuffer = new ArrayBuffer();
            BooleanRef accept = BooleanRef.create((boolean)true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getLoadUdfCode().split("\n"))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                UDFLoad.$anonfun$generateCode$1(this, accept, codeBuffer, statementBuffer, x0$1);
                return BoxedUnit.UNIT;
            });
            if (!statementBuffer.nonEmpty()) break block0;
            codeBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statementBuffer.mkString("\n")}));
        }
        return (String[])((TraversableOnce)codeBuffer.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UDFLoad.$anonfun$generateCode$2(x$1)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean acceptCodeType(String line) {
        return line.startsWith(new StringBuilder(1).append("%").append(this.runType().toString()).toString());
    }

    public String getLoadUdfCode() {
        EngineCreationContext engineCreationContext = EngineConnManager$.MODULE$.getEngineConnManager().getEngineConn().getEngineCreationContext();
        String user = engineCreationContext.getUser();
        boolean udfAllLoad = new StringOps(Predef$.MODULE$.augmentString(engineCreationContext.getOptions().getOrDefault("linkis.user.udf.all.load", "true"))).toBoolean();
        String udfIdStr = engineCreationContext.getOptions().getOrDefault("linkis.user.udf.custom.ids", "");
        long[] udfIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])udfIdStr.split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UDFLoad.$anonfun$getLoadUdfCode$1(x$1))))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)UDFLoad.$anonfun$getLoadUdfCode$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        this.logger().info(new StringBuilder(48).append("start loading UDFs, user: ").append(user).append(", load all: ").append(udfAllLoad).append(", udfIds: ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(udfIds)).mkString("Array(", ", ", ")")).toString());
        ArrayBuffer udfInfos = udfAllLoad ? UDFClient$.MODULE$.getUdfInfosByUdfType(user, this.category(), this.udfType()) : UDFClient$.MODULE$.getUdfInfosByUdfIds(user, udfIds, this.category(), this.udfType());
        this.logger().info("all udfs: ");
        udfInfos.foreach((Function1 & Serializable & scala.Serializable)l -> {
            UDFLoad.$anonfun$getLoadUdfCode$3(this, l);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)((TraversableLike)udfInfos.filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)UDFLoad.$anonfun$getLoadUdfCode$4(info)))).map((Function1 & Serializable & scala.Serializable)udfInfo -> this.constructCode((UDFInfoVo)udfInfo), ArrayBuffer$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String readFile(String path) {
        this.logger().info(new StringBuilder(11).append("read file: ").append(path).toString());
        File file = new File(path);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file);
        }
        this.logger().info(new StringBuilder(38).append("udf file: [").append(path).append("] doesn't exist, ignore it.").toString());
        return "";
    }

    public String readFile(String user, String resourceId, String resourceVersion) {
        this.logger().info("begin to download udf from bml.");
        BmlDownloadResponse downloadResponse = this.bmlClient().downloadResource(user == null ? Utils$.MODULE$.getJvmUser() : user, resourceId, resourceVersion);
        if (downloadResponse.isSuccess()) {
            return (String)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> IOUtils.toString((InputStream)downloadResponse.inputStream(), (String)((String)Configuration$.MODULE$.BDP_ENCODING().getValue())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)downloadResponse.inputStream()));
        }
        this.logger().info("failed to download udf from bml.");
        return "";
    }

    private String[] getFunctionCode() {
        return (String[])Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.generateCode(), (Function1 & Serializable & scala.Serializable)t -> {
            if (!BoxesRunTime.unboxToBoolean((Object)ComputationExecutorConf$.MODULE$.UDF_LOAD_FAILED_IGNORE().getValue())) {
                this.logger().error("Failed to load function, executor close ");
                throw t;
            }
            this.logger().error("Failed to load function", t);
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        });
    }

    private void executeFunctionCode(String[] codes, ComputationExecutor executor) {
        if (codes == null || executor == null) {
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codes)).foreach((Function1 & Serializable & scala.Serializable)code -> {
            this.logger().info(new StringBuilder(46).append("Submit function registration to engine, code: ").append((String)code).toString());
            return (ExecuteResponse)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> executor.executeLine(new EngineExecutionContext(executor, EngineExecutionContext$.MODULE$.$lessinit$greater$default$2()), (String)code), (Function1 & Serializable & scala.Serializable)t -> {
                if (!BoxesRunTime.unboxToBoolean((Object)ComputationExecutorConf$.MODULE$.UDF_LOAD_FAILED_IGNORE().getValue())) {
                    Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> executor.close());
                    this.logger().error("Failed to load function, executor close ");
                    throw t;
                }
                this.logger().error("Failed to load function", t);
                return null;
            });
        });
    }

    public void loadFunctions(Executor executor) {
        String[] codes = this.getFunctionCode();
        if (codes != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codes)).nonEmpty()) {
            Executor executor2 = executor;
            if (executor2 instanceof ComputationExecutor) {
                ComputationExecutor computationExecutor = (ComputationExecutor)executor2;
                this.executeFunctionCode(codes, computationExecutor);
            }
        }
        this.logger().info(new StringBuilder(45).append("Successful to execute function code ").append(this.runType()).append(", type : ").append(this.udfType()).toString());
    }

    public void loadUDF(Label<?>[] labels) {
        String[] codes = this.getFunctionCode();
        if (codes != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codes)).nonEmpty()) {
            LabelExecutor executor = ExecutorManager$.MODULE$.getInstance().getExecutorByLabels(labels);
            LabelExecutor labelExecutor = executor;
            if (labelExecutor instanceof ComputationExecutor) {
                ComputationExecutor computationExecutor = (ComputationExecutor)labelExecutor;
                this.executeFunctionCode(codes, computationExecutor);
            }
        }
        this.logger().info(new StringBuilder(36).append("Successful to execute code ").append(this.runType()).append(", type : ").append(this.udfType()).toString());
    }

    public static final /* synthetic */ void $anonfun$generateCode$1(UDFLoad $this, BooleanRef accept$1, ArrayBuffer codeBuffer$1, ArrayBuffer statementBuffer$1, String x0$1) {
        String string = x0$1;
        if ("".equals(string)) {
            return;
        }
        if (string.startsWith("%")) {
            if ($this.acceptCodeType(string)) {
                accept$1.elem = true;
                codeBuffer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statementBuffer$1.mkString("\n")}));
                statementBuffer$1.clear();
                return;
            }
            accept$1.elem = false;
            return;
        }
        if (accept$1.elem) {
            statementBuffer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$generateCode$2(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLoadUdfCode$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ long $anonfun$getLoadUdfCode$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
    }

    public static final /* synthetic */ void $anonfun$getLoadUdfCode$3(UDFLoad $this, UDFInfoVo l) {
        $this.logger().info(new StringBuilder(36).append("udfName:").append(l.getUdfName()).append(", bml_resource_id:").append(l.getBmlResourceId()).append(", bml_id:").append(l.getId()).append("\n").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getLoadUdfCode$4(UDFInfoVo info) {
        return StringUtils.isNotEmpty((CharSequence)info.getBmlResourceId());
    }

    public UDFLoad() {
        Logging.$init$((Logging)this);
        this.bmlClient = BmlClientFactory.createBmlClient();
    }
}

