/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.domain;

import java.io.IOException;
import java.io.InputStream;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorCode;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Dolphin$
implements Logging {
    public static Dolphin$ MODULE$;
    private final String CHAR_SET;
    private final String MAGIC;
    private final byte[] MAGIC_BYTES;
    private final int MAGIC_LEN;
    private final String DOLPHIN_FILE_SUFFIX;
    private final String COL_SPLIT;
    private final byte[] COL_SPLIT_BYTES;
    private final int COL_SPLIT_LEN;
    private final String NULL;
    private final byte[] NULL_BYTES;
    private final String LINKIS_NULL;
    private final byte[] LINKIS_NULL_BYTES;
    private final int INT_LEN;
    private final int FILE_EMPTY;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Dolphin$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        Dolphin$ dolphin$ = this;
        synchronized (dolphin$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String CHAR_SET() {
        return this.CHAR_SET;
    }

    public String MAGIC() {
        return this.MAGIC;
    }

    public byte[] MAGIC_BYTES() {
        return this.MAGIC_BYTES;
    }

    public int MAGIC_LEN() {
        return this.MAGIC_LEN;
    }

    public String DOLPHIN_FILE_SUFFIX() {
        return this.DOLPHIN_FILE_SUFFIX;
    }

    public String COL_SPLIT() {
        return this.COL_SPLIT;
    }

    public byte[] COL_SPLIT_BYTES() {
        return this.COL_SPLIT_BYTES;
    }

    public int COL_SPLIT_LEN() {
        return this.COL_SPLIT_LEN;
    }

    public String NULL() {
        return this.NULL;
    }

    public byte[] NULL_BYTES() {
        return this.NULL_BYTES;
    }

    public String LINKIS_NULL() {
        return this.LINKIS_NULL;
    }

    public byte[] LINKIS_NULL_BYTES() {
        return this.LINKIS_NULL_BYTES;
    }

    public int INT_LEN() {
        return this.INT_LEN;
    }

    public int FILE_EMPTY() {
        return this.FILE_EMPTY;
    }

    public byte[] getBytes(Object value) {
        return value.toString().getBytes(this.CHAR_SET());
    }

    public String getString(byte[] bytes, int start, int len) {
        String string;
        try {
            string = new String(bytes, start, len, this.CHAR_SET());
        }
        catch (OutOfMemoryError e) {
            this.logger().error("bytes to String oom  {} Byte", (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            throw new StorageErrorException(StorageErrorCode.FS_OOM.getCode(), StorageErrorCode.FS_OOM.getMessage(), e);
        }
        return string;
    }

    public String toStringValue(String value) {
        if (this.LINKIS_NULL().equals(value)) {
            return this.NULL();
        }
        return value;
    }

    public int readInt(InputStream inputStream) {
        byte[] bytes = new byte[this.INT_LEN() + 1];
        if (StorageUtils$.MODULE$.readBytes(inputStream, bytes, this.INT_LEN()) != this.INT_LEN()) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.FAILED_TO_READ_INTEGER.getErrorCode(), LinkisStorageErrorCodeSummary.FAILED_TO_READ_INTEGER.getErrorDesc());
        }
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(bytes, 0, this.INT_LEN()))).toInt();
    }

    public byte[] getIntBytes(int value) {
        String str = Integer.toString(value);
        String res = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(this.INT_LEN() - str.length())).append(str).toString();
        return this.getBytes(res);
    }

    public String getType(InputStream inputStream) {
        byte[] bytes = new byte[100];
        int len = StorageUtils$.MODULE$.readBytes(inputStream, bytes, this.MAGIC_LEN() + this.INT_LEN());
        if (len == -1) {
            return null;
        }
        return this.getType(this.getString(bytes, 0, len));
    }

    public String getType(String content) {
        block3: {
            block2: {
                if (content.length() < this.MAGIC().length()) break block2;
                String string = content.substring(0, this.MAGIC().length());
                String string2 = this.MAGIC();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
            }
            throw new IOException(new StringBuilder(48).append("File header type must be dolphin,content:").append(content).append(" is not").toString());
        }
        return Integer.toString(new StringOps(Predef$.MODULE$.augmentString(content.substring(this.MAGIC().length(), this.MAGIC().length() + this.INT_LEN()))).toInt());
    }

    private Dolphin$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CHAR_SET = (String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue();
        this.MAGIC = "dolphin";
        this.MAGIC_BYTES = this.MAGIC().getBytes((String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue());
        this.MAGIC_LEN = this.MAGIC_BYTES().length;
        this.DOLPHIN_FILE_SUFFIX = ".dolphin";
        this.COL_SPLIT = ",";
        this.COL_SPLIT_BYTES = this.COL_SPLIT().getBytes("utf-8");
        this.COL_SPLIT_LEN = this.COL_SPLIT_BYTES().length;
        this.NULL = "NULL";
        this.NULL_BYTES = this.NULL().getBytes("utf-8");
        this.LINKIS_NULL = "LINKIS_NULL";
        this.LINKIS_NULL_BYTES = this.LINKIS_NULL().getBytes("utf-8");
        this.INT_LEN = 10;
        this.FILE_EMPTY = 31;
    }
}

