/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.domain.Dolphin$;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultMetaData;
import org.apache.linkis.storage.resultset.ResultRecord;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\t\u0013\u0001uAQ\u0001\r\u0001\u0005\u0002EBqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004T\u0001\u0001\u0006I!\u000e\u0005\b)\u0002\u0011\r\u0011\"\u0001V\u0011\u0019I\u0006\u0001)A\u0005-\")!\f\u0001C!7\")1\u000f\u0001C!i\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!a\u000e\u0001\t\u0003\nI\u0004\u0003\u0004\u0002P\u0001!\t%\u0016\u0005\u0007g\u0002!\t%!\u0015\t\rM\u0004A\u0011IA8\u0011\u001d\t9\u0004\u0001C!\u0003\u000f\u0013q\u0003R3gCVdGOU3tk2$8+\u001a;GC\u000e$xN]=\u000b\u0005M!\u0012!\u0003:fgVdGo]3u\u0015\t)b#A\u0004ti>\u0014\u0018mZ3\u000b\u0005]A\u0012A\u00027j].L7O\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0005\u0001y!\u0003\u0006\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AE\u0005\u0003OI\u0011\u0001CU3tk2$8+\u001a;GC\u000e$xN]=\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B;uS2\u001c(BA\u0017\u0017\u0003\u0019\u0019w.\\7p]&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u0002&\u0001\u0005i!/Z:vYR\u001cE.Y:tKN,\u0012!\u000e\t\u0005mu\u00025I\u0004\u00028wA\u0011\u0001\bI\u0007\u0002s)\u0011!\bH\u0001\u0007yI|w\u000e\u001e \n\u0005q\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t\u0019Q*\u00199\u000b\u0005q\u0002\u0003C\u0001\u001cB\u0013\t\u0011uH\u0001\u0004TiJLgn\u001a\t\u0004m\u00113\u0015BA#@\u0005\u0015\u0019E.Y:t!\u001195*\u0014)\u000e\u0003!S!aE%\u000b\u0005)c\u0013AA5p\u0013\ta\u0005JA\u0005SKN,H\u000e^*fiB\u0011QET\u0005\u0003\u001fJ\u0011aBU3tk2$X*\u001a;b\t\u0006$\u0018\r\u0005\u0002&#&\u0011!K\u0005\u0002\r%\u0016\u001cX\u000f\u001c;SK\u000e|'\u000fZ\u0001\u000fe\u0016\u001cX\u000f\u001c;DY\u0006\u001c8/Z:!\u0003-\u0011Xm];miRK\b/Z:\u0016\u0003Y\u00032aH,A\u0013\tA\u0006EA\u0003BeJ\f\u00170\u0001\u0007sKN,H\u000e\u001e+za\u0016\u001c\b%\u0001\nhKR\u0014Vm];miN+GOQ=UsB,GC\u0001/ra\ri\u0006m\u001b\t\u0005\u000f.s&\u000e\u0005\u0002`A2\u0001A!C1\u0007\u0003\u0003\u0005\tQ!\u0001c\u0005\ryF%M\t\u0003G\u001a\u0004\"a\b3\n\u0005\u0015\u0004#a\u0002(pi\"Lgn\u001a\t\u0003O\"l\u0011!S\u0005\u0003S&\u0013\u0001\"T3uC\u0012\u000bG/\u0019\t\u0003?.$\u0011\u0002\u001c\u0004\u0002\u0002\u0003\u0005)\u0011A7\u0003\u0007}##'\u0005\u0002d]B\u0011qm\\\u0005\u0003a&\u0013aAU3d_J$\u0007\"\u0002:\u0007\u0001\u0004\u0001\u0015!\u0004:fgVdGoU3u)f\u0004X-\u0001\nhKR\u0014Vm];miN+GOQ=QCRDGCA;~a\r1\bp\u001f\t\u0005\u000f.;(\u0010\u0005\u0002`q\u0012I\u0011pBA\u0001\u0002\u0003\u0015\tA\u0019\u0002\u0004?\u0012\u001a\u0004CA0|\t%ax!!A\u0001\u0002\u000b\u0005QNA\u0002`IQBQA`\u0004A\u0002}\faAZ:QCRD\u0007cA4\u0002\u0002%\u0019\u00111A%\u0003\r\u0019\u001b\b+\u0019;i\u0003U9W\r\u001e*fgVdGoU3u\u0005f\u001cuN\u001c;f]R$B!!\u0003\u0002\u001aA2\u00111BA\b\u0003+\u0001baR&\u0002\u000e\u0005M\u0001cA0\u0002\u0010\u0011Q\u0011\u0011\u0003\u0005\u0002\u0002\u0003\u0005)\u0011\u00012\u0003\u0007}#S\u0007E\u0002`\u0003+!!\"a\u0006\t\u0003\u0003\u0005\tQ!\u0001n\u0005\ryFE\u000e\u0005\u0007\u00037A\u0001\u0019\u0001!\u0002\u000f\r|g\u000e^3oi\u00061Q\r_5tiN$B!!\t\u0002(A\u0019q$a\t\n\u0007\u0005\u0015\u0002EA\u0004C_>dW-\u00198\t\u000bIL\u0001\u0019\u0001!\u0002\u001f%\u001c(+Z:vYR\u001cV\r\u001e)bi\"$B!!\t\u0002.!1\u0011q\u0006\u0006A\u0002\u0001\u000bA\u0001]1uQ\u0006Y\u0011n\u001d*fgVdGoU3u)\u0011\t\t#!\u000e\t\r\u0005m1\u00021\u0001A\u000319W\r\u001e*fgVdGoU3u)\u0011\tY$a\u00131\r\u0005u\u0012\u0011IA$!\u001995*a\u0010\u0002FA\u0019q,!\u0011\u0005\u0015\u0005\rC\"!A\u0001\u0002\u000b\u0005!MA\u0002`I]\u00022aXA$\t)\tI\u0005DA\u0001\u0002\u0003\u0015\t!\u001c\u0002\u0004?\u0012B\u0004BBA'\u0019\u0001\u0007\u0001)\u0001\u0004pkR\u0004X\u000f^\u0001\u0011O\u0016$(+Z:vYR\u001cV\r\u001e+za\u0016$b!a\u0015\u0002d\u0005\u0015\u0004GBA+\u00033\ny\u0006\u0005\u0004H\u0017\u0006]\u0013Q\f\t\u0004?\u0006eCACA.\u001d\u0005\u0005\t\u0011!B\u0001E\n\u0019q\fJ\u001d\u0011\u0007}\u000by\u0006\u0002\u0006\u0002b9\t\t\u0011!A\u0003\u00025\u0014Aa\u0018\u00132a!)aP\u0004a\u0001\u007f\"9\u0011q\r\bA\u0002\u0005%\u0014A\u00014t!\r9\u00171N\u0005\u0004\u0003[J%A\u0001$t)\u0019\t\t(!!\u0002\u0004B2\u00111OA<\u0003{\u0002baR&\u0002v\u0005m\u0004cA0\u0002x\u0011Q\u0011\u0011P\b\u0002\u0002\u0003\u0005)\u0011\u00012\u0003\t}#\u0013'\r\t\u0004?\u0006uDACA@\u001f\u0005\u0005\t\u0011!B\u0001[\n!q\fJ\u00193\u0011\u0015qx\u00021\u0001\u0000\u0011\u0019\t)i\u0004a\u0001\u0001\u0006I\u0001O]8ysV\u001bXM\u001d\u000b\u0007\u0003\u0013\u000bI*a'1\r\u0005-\u0015qRAK!\u001995*!$\u0002\u0014B\u0019q,a$\u0005\u0015\u0005E\u0005#!A\u0001\u0002\u000b\u0005!M\u0001\u0003`IE\u001a\u0004cA0\u0002\u0016\u0012Q\u0011q\u0013\t\u0002\u0002\u0003\u0005)\u0011A7\u0003\t}#\u0013\u0007\u000e\u0005\u0007\u0003\u001b\u0002\u0002\u0019\u0001!\t\r\u0005\u0015\u0005\u00031\u0001A\u0001")
public class DefaultResultSetFactory
implements ResultSetFactory,
Logging {
    private final Map<String, Class<ResultSet<ResultMetaData, ResultRecord>>> resultClasses;
    private final String[] resultTypes;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultResultSetFactory defaultResultSetFactory = this;
        synchronized (defaultResultSetFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Map<String, Class<ResultSet<ResultMetaData, ResultRecord>>> resultClasses() {
        return this.resultClasses;
    }

    public String[] resultTypes() {
        return this.resultTypes;
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByType(String resultSetType) {
        if (!this.resultClasses().contains((Object)resultSetType)) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorDesc(), resultSetType));
        }
        return (ResultSet)((Class)this.resultClasses().apply((Object)resultSetType)).newInstance();
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath) {
        return this.getResultSetByPath(fsPath, StorageUtils$.MODULE$.getJvmUser());
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByContent(String content) {
        return this.getResultSetByType(Dolphin$.MODULE$.getType(content));
    }

    @Override
    public boolean exists(String resultSetType) {
        return this.resultClasses().contains((Object)resultSetType);
    }

    @Override
    public boolean isResultSetPath(String path) {
        return path.endsWith(Dolphin$.MODULE$.DOLPHIN_FILE_SUFFIX());
    }

    @Override
    public boolean isResultSet(String content) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resultClasses().contains((Object)Dolphin$.MODULE$.getType(content)), (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DefaultResultSetFactory.$anonfun$isResultSet$2(this, t))));
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSet(String output) {
        return this.getResultSet(output, StorageUtils$.MODULE$.getJvmUser());
    }

    @Override
    public String[] getResultSetType() {
        return this.resultTypes();
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath, Fs fs) {
        InputStream inputStream = fs.read(fsPath);
        String resultSetType = Dolphin$.MODULE$.getType(inputStream);
        if (StringUtils.isEmpty((CharSequence)resultSetType)) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorDesc(), fsPath.getPath()));
        }
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inputStream.close());
        return this.getResultSetByType(resultSetType);
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath, String proxyUser) {
        if (fsPath == null) {
            return null;
        }
        this.logger().info(new StringBuilder(23).append("Get Result Set By Path:").append(fsPath.getPath()).toString());
        Fs fs = FSFactory$.MODULE$.getFsByProxyUser(fsPath, proxyUser);
        fs.init(new HashMap());
        InputStream inputStream = fs.read(fsPath);
        String resultSetType = Dolphin$.MODULE$.getType(inputStream);
        if (StringUtils.isEmpty((CharSequence)resultSetType)) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorDesc(), fsPath.getPath()));
        }
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inputStream.close());
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.close());
        return this.getResultSetByType(resultSetType);
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSet(String output, String proxyUser) {
        if (this.isResultSetPath(output)) {
            return this.getResultSetByPath(new FsPath(output), proxyUser);
        }
        if (this.isResultSet(output)) {
            return this.getResultSetByContent(output);
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$isResultSet$2(DefaultResultSetFactory $this, Throwable t) {
        $this.logger().info(new StringBuilder(18).append("Wrong result Set: ").append(t.getMessage()).toString());
        return false;
    }

    public DefaultResultSetFactory() {
        Logging.$init$((Logging)this);
        this.resultClasses = StorageUtils$.MODULE$.loadClasses((String)StorageConfiguration$.MODULE$.STORAGE_RESULT_SET_CLASSES().getValue(), (String)StorageConfiguration$.MODULE$.STORAGE_RESULT_SET_PACKAGE().getValue(), (Function1 & Serializable & scala.Serializable)t -> ((ResultSet)t.newInstance()).resultSetType().toLowerCase(Locale.getDefault()));
        this.resultTypes = (String[])ResultSetFactory$.MODULE$.resultSetType().keys().toArray(ClassTag$.MODULE$.apply(String.class));
    }
}

