/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.InputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.StorageResultSetReader;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.resultset.table.TableResultSet;
import org.slf4j.Logger;
import scala.Function0;

public final class ResultSetReader$
implements Logging {
    public static ResultSetReader$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ResultSetReader$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ResultSetReader$ resultSetReader$ = this;
        synchronized (resultSetReader$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public <K extends MetaData, V extends Record> ResultSetReader<K, V> getResultSetReader(ResultSet<K, V> resultSet, InputStream inputStream) {
        return new StorageResultSetReader<K, V>(resultSet, inputStream);
    }

    public <K extends MetaData, V extends Record> ResultSetReader<K, V> getResultSetReader(ResultSet<K, V> resultSet, String value) {
        return new StorageResultSetReader<K, V>(resultSet, value);
    }

    public ResultSetReader<? extends MetaData, ? extends Record> getResultSetReader(String res) {
        ResultSetReader<? extends MetaData, ? extends Record> reader;
        block1: {
            ResultSetFactory rsFactory = ResultSetFactory$.MODULE$.getInstance();
            if (rsFactory.isResultSet(res)) {
                ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
                return this.getResultSetReader(resultSet, res);
            }
            FsPath resPath = new FsPath(res);
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
            Fs fs = FSFactory$.MODULE$.getFs(resPath);
            fs.init(null);
            ResultSetReader<? extends MetaData, ? extends Record> resultSetReader = reader = this.getResultSetReader(resultSet, fs.read(resPath));
            if (!(resultSetReader instanceof StorageResultSetReader)) break block1;
            StorageResultSetReader storageResultSetReader = (StorageResultSetReader)resultSetReader;
            storageResultSetReader.setFs(fs);
        }
        return reader;
    }

    public ResultSetReader<TableMetaData, TableRecord> getTableResultReader(String res) {
        ResultSetFactory rsFactory = ResultSetFactory$.MODULE$.getInstance();
        if (rsFactory.isResultSet(res)) {
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
            String string = ResultSetFactory$.MODULE$.TABLE_TYPE();
            String string2 = resultSet.resultSetType();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new StorageErrorException(LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorCode(), LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorDesc());
            }
            return this.getResultSetReader((TableResultSet)resultSet, res);
        }
        FsPath resPath = new FsPath(res);
        ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
        String string = ResultSetFactory$.MODULE$.TABLE_TYPE();
        String string3 = resultSet.resultSetType();
        if (string == null ? string3 != null : !string.equals(string3)) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorCode(), LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorDesc());
        }
        Fs fs = FSFactory$.MODULE$.getFs(resPath);
        this.logger().info(new StringBuilder(25).append("Try to init Fs with path:").append(resPath.getPath()).toString());
        fs.init(null);
        return this.getResultSetReader((TableResultSet)resultSet, fs.read(resPath));
    }

    private ResultSetReader$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

