/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedInputStream.class);
    private DataInputStream din;
    private int unreadBytes = 0;
    private byte[] singleByte = new byte[1];
    private boolean endOfData = false;
    private String id;

    public ChunkedInputStream(InputStream in, String id) {
        this.din = new DataInputStream(in);
        this.id = id;
        LOG.debug("Creating chunked input for {}", (Object)id);
    }

    @Override
    public void close() throws IOException {
        LOG.debug("{}: Closing chunked input.", (Object)this.id);
        this.din.close();
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.singleByte, 0, 1);
        return bytesRead == -1 ? -1 : this.singleByte[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = 0;
        if (len < 0) {
            throw new IllegalArgumentException(this.id + ": Negative read length");
        }
        if (len == 0) {
            return 0;
        }
        if (this.unreadBytes == 0) {
            try {
                this.unreadBytes = this.din.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Chunk size {}", (Object)this.id, (Object)this.unreadBytes);
                }
                if (this.unreadBytes == 0) {
                    LOG.debug("{}: Hit end of data", (Object)this.id);
                    this.endOfData = true;
                    return -1;
                }
            }
            catch (IOException err) {
                throw new IOException(this.id + ": Error while attempting to read chunk length", err);
            }
        }
        int bytesToRead = Math.min(len, this.unreadBytes);
        try {
            this.din.readFully(b, off, bytesToRead);
        }
        catch (IOException err) {
            throw new IOException(this.id + ": Error while attempting to read " + bytesToRead + " bytes from current chunk", err);
        }
        this.unreadBytes -= bytesToRead;
        return bytesRead += bytesToRead;
    }

    public boolean isEndOfData() {
        return this.endOfData;
    }
}

