/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.KubernetesResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.ResourceWarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DriverAndKubernetesResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(DriverAndKubernetesResource.class);
    private final LoadInstanceResource loadInstanceResource;
    private final KubernetesResource kubernetesResource;

    public DriverAndKubernetesResource(LoadInstanceResource loadInstanceResource, KubernetesResource kubernetesResource) {
        this.loadInstanceResource = loadInstanceResource;
        this.kubernetesResource = kubernetesResource;
    }

    public DriverAndKubernetesResource() {
        this(new LoadInstanceResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new KubernetesResource(Long.MAX_VALUE, Long.MAX_VALUE));
    }

    public LoadInstanceResource getLoadInstanceResource() {
        return this.loadInstanceResource;
    }

    private DriverAndKubernetesResource(Resource r) {
        if (r instanceof DriverAndKubernetesResource) {
            DriverAndKubernetesResource t = (DriverAndKubernetesResource)r;
            this.loadInstanceResource = t.loadInstanceResource;
            this.kubernetesResource = t.kubernetesResource;
        } else if (r instanceof KubernetesResource) {
            this.loadInstanceResource = new LoadInstanceResource(0L, 0, 0);
            this.kubernetesResource = (KubernetesResource)r;
        } else if (r instanceof LoadInstanceResource) {
            this.loadInstanceResource = (LoadInstanceResource)r;
            this.kubernetesResource = new KubernetesResource(0L, 0L);
        } else if (r instanceof LoadResource) {
            LoadResource l = (LoadResource)r;
            this.loadInstanceResource = new LoadInstanceResource(l.getMemory(), l.getCores(), 0);
            this.kubernetesResource = new KubernetesResource(0L, 0L);
        } else if (r instanceof MemoryResource) {
            MemoryResource m = (MemoryResource)r;
            this.loadInstanceResource = new LoadInstanceResource(m.getMemory(), 0, 0);
            this.kubernetesResource = new KubernetesResource(0L, 0L);
        } else if (r instanceof CPUResource) {
            CPUResource c = (CPUResource)r;
            this.loadInstanceResource = new LoadInstanceResource(0L, c.getCores(), 0);
            this.kubernetesResource = new KubernetesResource(0L, 0L);
        } else {
            this.loadInstanceResource = new LoadInstanceResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.kubernetesResource = new KubernetesResource(Long.MAX_VALUE, Long.MAX_VALUE);
        }
    }

    public KubernetesResource getKubernetesResource() {
        return this.kubernetesResource;
    }

    public boolean isModuleOperate(Resource r) {
        return false;
    }

    public boolean isModuleOperate() {
        return this.kubernetesResource != null;
    }

    @Override
    public DriverAndKubernetesResource add(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return new DriverAndKubernetesResource(this.loadInstanceResource.add(r.getLoadInstanceResource()), this.kubernetesResource);
        }
        return new DriverAndKubernetesResource(this.loadInstanceResource.add(r.getLoadInstanceResource()), this.kubernetesResource.add(r.getKubernetesResource()));
    }

    @Override
    public DriverAndKubernetesResource minus(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return new DriverAndKubernetesResource(this.loadInstanceResource.minus(r.getLoadInstanceResource()), this.kubernetesResource);
        }
        return new DriverAndKubernetesResource(this.loadInstanceResource.minus(r.getLoadInstanceResource()), this.kubernetesResource.minus(r.getKubernetesResource()));
    }

    @Override
    public Resource multiplied(Resource r) {
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorCode(), ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorDesc());
    }

    @Override
    public Resource multiplied(float rate) {
        if (this.isModuleOperate()) {
            return new DriverAndKubernetesResource(this.loadInstanceResource.multiplied(rate), this.kubernetesResource);
        }
        return new DriverAndKubernetesResource(this.loadInstanceResource.multiplied(rate), this.kubernetesResource.multiplied(rate));
    }

    @Override
    public Resource divide(Resource r) {
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorCode(), ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorDesc());
    }

    @Override
    public Resource divide(int rate) {
        if (this.isModuleOperate()) {
            return new DriverAndKubernetesResource(this.loadInstanceResource.divide(rate), this.kubernetesResource);
        }
        return new DriverAndKubernetesResource(this.loadInstanceResource.divide(rate), this.kubernetesResource.divide(rate));
    }

    @Override
    public boolean moreThan(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return this.loadInstanceResource.moreThan(r.loadInstanceResource);
        }
        return this.loadInstanceResource.moreThan(r.loadInstanceResource) && this.kubernetesResource.moreThan(r.kubernetesResource);
    }

    @Override
    public boolean caseMore(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return this.loadInstanceResource.caseMore(r.loadInstanceResource);
        }
        return this.loadInstanceResource.caseMore(r.loadInstanceResource) || this.kubernetesResource.caseMore(r.kubernetesResource);
    }

    @Override
    public boolean equalsTo(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return this.loadInstanceResource.equalsTo(r.loadInstanceResource);
        }
        return this.loadInstanceResource.equalsTo(r.loadInstanceResource) && this.kubernetesResource.equalsTo(r.kubernetesResource);
    }

    @Override
    public boolean notLess(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return this.loadInstanceResource.notLess(r.loadInstanceResource);
        }
        return this.loadInstanceResource.notLess(r.loadInstanceResource) && this.kubernetesResource.notLess(r.kubernetesResource);
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource resource) {
        DriverAndKubernetesResource r = new DriverAndKubernetesResource(resource);
        if (this.isModuleOperate(r)) {
            return this.loadInstanceResource.compare(r.loadInstanceResource);
        }
        if (this.loadInstanceResource.getMemory() > r.loadInstanceResource.getMemory()) {
            return 1;
        }
        if (this.loadInstanceResource.getMemory() < r.loadInstanceResource.getMemory()) {
            return -1;
        }
        if (this.loadInstanceResource.getCores() > r.loadInstanceResource.getCores()) {
            return 1;
        }
        if (this.loadInstanceResource.getCores() < r.loadInstanceResource.getCores()) {
            return -1;
        }
        if (this.loadInstanceResource.getInstances() > r.loadInstanceResource.getInstances()) {
            return 1;
        }
        if (this.loadInstanceResource.getInstances() < r.loadInstanceResource.getInstances()) {
            return -1;
        }
        if (this.kubernetesResource.getMemory() > r.kubernetesResource.getMemory()) {
            return 1;
        }
        if (this.kubernetesResource.getMemory() < r.kubernetesResource.getMemory()) {
            return -1;
        }
        return Long.compare(this.kubernetesResource.getCores(), r.kubernetesResource.getCores());
    }

    @Override
    public String toJson() {
        String load = "null";
        String kubernetes = "null";
        if (this.loadInstanceResource != null) {
            load = this.loadInstanceResource.toJson();
        }
        if (this.kubernetesResource != null) {
            kubernetes = this.kubernetesResource.toJson();
        }
        return String.format("{\"driver\":%s, \"kubernetes\":%s}", load, kubernetes);
    }

    public String toString() {
        return String.format("Driver resources(Driver\u8d44\u6e90)\uff1a%s, Kubernetes resource(K8S\u8d44\u6e90):%s", this.loadInstanceResource, this.kubernetesResource);
    }
}

