/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface FallbackFactory<T> {
    public T create(Throwable var1);

    public static final class Default<T>
    implements FallbackFactory<T> {
        final Log logger;
        final T constant;

        public Default(T constant) {
            this(constant, LogFactory.getLog(Default.class));
        }

        Default(T constant, Log logger) {
            this.constant = Util.checkNotNull(constant, (String)"fallback", (Object[])new Object[0]);
            this.logger = (Log)Util.checkNotNull((Object)logger, (String)"logger", (Object[])new Object[0]);
        }

        @Override
        public T create(Throwable cause) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("fallback due to: " + cause.getMessage()), cause);
            }
            return this.constant;
        }

        public String toString() {
            return this.constant.toString();
        }
    }
}

