/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.security;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Target;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OAuth2AccessTokenInterceptor
implements RequestInterceptor {
    public static final String BEARER = "Bearer";
    public static final String AUTHORIZATION = "Authorization";
    private final String tokenType;
    private final String header;
    private final String clientRegistrationId;
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public OAuth2AccessTokenInterceptor(OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager) {
        this(null, oAuth2AuthorizedClientManager);
    }

    public OAuth2AccessTokenInterceptor(String clientRegistrationId, OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager) {
        this(BEARER, AUTHORIZATION, clientRegistrationId, oAuth2AuthorizedClientManager);
    }

    public OAuth2AccessTokenInterceptor(String tokenType, String header, String clientRegistrationId, OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager) {
        this.tokenType = tokenType;
        this.header = header;
        this.clientRegistrationId = clientRegistrationId;
        this.authorizedClientManager = oAuth2AuthorizedClientManager;
    }

    public void apply(RequestTemplate template) {
        OAuth2AccessToken token = this.getToken(template);
        String extractedToken = String.format("%s %s", this.tokenType, token.getTokenValue());
        template.header(this.header, new String[0]);
        template.header(this.header, new String[]{extractedToken});
    }

    public OAuth2AccessToken getToken(RequestTemplate template) {
        OAuth2AccessToken token;
        if (StringUtils.hasText((String)this.clientRegistrationId) && (token = this.getToken(this.clientRegistrationId)) != null) {
            return token;
        }
        token = this.getToken(OAuth2AccessTokenInterceptor.getServiceId(template));
        if (token != null) {
            return token;
        }
        throw new IllegalStateException("OAuth2 token has not been successfully acquired.");
    }

    protected OAuth2AccessToken getToken(String clientRegistrationId) {
        if (!StringUtils.hasText((String)clientRegistrationId)) {
            return null;
        }
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if (principal == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal(principal).build();
        OAuth2AuthorizedClient authorizedClient = this.authorizedClientManager.authorize(authorizeRequest);
        return Optional.ofNullable(authorizedClient).map(OAuth2AuthorizedClient::getAccessToken).orElse(null);
    }

    private static String getServiceId(RequestTemplate template) {
        Target feignTarget = template.feignTarget();
        Assert.notNull((Object)feignTarget, (String)"FeignTarget may not be null.");
        String url = feignTarget.url();
        Assert.hasLength((String)url, (String)"Url may not be empty.");
        URI originalUri = URI.create(url);
        return originalUri.getHost();
    }
}

