/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.socket;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.exception.BDPServerErrorException;
import org.apache.linkis.server.socket.ServerSocket;
import org.apache.linkis.server.socket.ServerSocket$;
import org.apache.linkis.server.socket.SocketListener;
import org.apache.linkis.server.socket.controller.ServerListenerEventBus;
import org.apache.linkis.server.socket.controller.SocketServerEvent;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!\u0002\b\u0010\u0001EI\u0002\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\u0001\u0003A\u0011A!\t\u000f\u0011\u0003!\u0019!C\u0005\u000b\"1q\u000b\u0001Q\u0001\n\u0019Cq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\n\u0001\t\u0003\nIC\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe*\u0011\u0001#E\u0001\u0007g>\u001c7.\u001a;\u000b\u0005I\u0019\u0012AB:feZ,'O\u0003\u0002\u0015+\u00051A.\u001b8lSNT!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sON)\u0001A\u0007\u0014+eA\u00111\u0004J\u0007\u00029)\u0011QDH\u0001\bg\u0016\u0014h\u000f\\3u\u0015\ty\u0002%A\u0005xK\n\u001cxnY6fi*\u0011\u0011EI\u0001\u0006U\u0016$H/\u001f\u0006\u0003G]\tq!Z2mSB\u001cX-\u0003\u0002&9\t\u0001r+\u001a2T_\u000e\\W\r^*feZdW\r\u001e\t\u0003O!j\u0011aD\u0005\u0003S=\u0011abU8dW\u0016$H*[:uK:,'\u000f\u0005\u0002,a5\tAF\u0003\u0002.]\u0005AA.[:uK:,'O\u0003\u00020'\u000511m\\7n_:L!!\r\u0017\u0003\u000b\u00153XM\u001c;\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0013!B;uS2\u001c\u0018BA\u001c5\u0005\u001daunZ4j]\u001e\fac]3sm\u0016\u0014H*[:uK:,'/\u0012<f]R\u0014Uo]\u0002\u0001!\tYd(D\u0001=\u0015\tit\"\u0001\u0006d_:$(o\u001c7mKJL!a\u0010\u001f\u0003-M+'O^3s\u0019&\u001cH/\u001a8fe\u00163XM\u001c;CkN\fa\u0001P5oSRtDC\u0001\"D!\t9\u0003\u0001C\u00039\u0005\u0001\u0007!(\u0001\u0006t_\u000e\\W\r\u001e'jgR,\u0012A\u0012\t\u0005\u000f2sE+D\u0001I\u0015\tI%*\u0001\u0003vi&d'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0002J]R\u0004\"aJ+\n\u0005Y{!\u0001D*feZ,'oU8dW\u0016$\u0018aC:pG.,G\u000fT5ti\u0002\n1\"\u001b3HK:,'/\u0019;peV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u00061\u0011\r^8nS\u000eT!a\u0018%\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002b9\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\"\u001b3HK:,'/\u0019;pe\u0002\n\u0011bY8oM&<WO]3\u0015\u0005\u0015D\u0007CA(g\u0013\t9\u0007K\u0001\u0003V]&$\b\"B5\b\u0001\u0004Q\u0017aF<fEN{7m[3u'\u0016\u0014h\u000f\\3u\r\u0006\u001cGo\u001c:z!\tY2.\u0003\u0002m9\t9r+\u001a2T_\u000e\\W\r^*feZdW\r\u001e$bGR|'/_\u0001\fg\u0016tG-T3tg\u0006<W\rF\u0002f_FDQ\u0001\u001d\u0005A\u00029\u000b!!\u001b3\t\u000bID\u0001\u0019A:\u0002\u000f5,7o]1hKB\u0011A/^\u0007\u0002#%\u0011a/\u0005\u0002\b\u001b\u0016\u001c8/Y4f\u0003A\u0019XM\u001c3NKN\u001c\u0018mZ3U_\u0006cG\u000e\u0006\u0002fs\")!/\u0003a\u0001g\u0006\t2/\u001a8e\u001b\u0016\u001c8/Y4f)>,6/\u001a:\u0015\t\u0015d\u00181\u0003\u0005\u0006{*\u0001\rA`\u0001\u0005kN,'\u000fE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001)\u000e\u0005\u0005\u0015!bAA\u0004s\u00051AH]8pizJ1!a\u0003Q\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002)\t\u000bIT\u0001\u0019A:\u0002\u000f=t7\t\\8tKR9Q-!\u0007\u0002\u001c\u0005}\u0001\"\u0002\t\f\u0001\u0004!\u0006BBA\u000f\u0017\u0001\u0007a*\u0001\u0003d_\u0012,\u0007\"\u0002:\f\u0001\u0004q\u0018AB8o\u001fB,g\u000eF\u0002f\u0003KAQ\u0001\u0005\u0007A\u0002Q\u000b\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u000b\u0015\fY#!\f\t\u000bAi\u0001\u0019\u0001+\t\u000bIl\u0001\u0019\u0001@")
public class ControllerServer
extends WebSocketServlet
implements SocketListener,
Event,
Logging {
    private final ServerListenerEventBus serverListenerEventBus;
    private final HashMap<Object, ServerSocket> socketList;
    private final AtomicInteger idGenerator;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ControllerServer controllerServer = this;
        synchronized (controllerServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private HashMap<Object, ServerSocket> socketList() {
        return this.socketList;
    }

    private AtomicInteger idGenerator() {
        return this.idGenerator;
    }

    public void configure(WebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.setCreator(new WebSocketCreator(this){
            private final /* synthetic */ ControllerServer $outer;

            public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
                return new ServerSocket(servletUpgradeRequest.getHttpServletRequest(), this.$outer, ServerSocket$.MODULE$.apply$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void sendMessage(int id, Message message) {
        ServerSocket socket = this.socketList().get(BoxesRunTime.boxToInteger((int)id));
        if (socket == null) {
            throw new BDPServerErrorException(LinkisModuleErrorCodeSummary.SERVERSOCKET_NOT_EXIST.getErrorCode(), MessageFormat.format(LinkisModuleErrorCodeSummary.SERVERSOCKET_NOT_EXIST.getErrorDesc(), Integer.toString(id)));
        }
        socket.sendMessage(Message$.MODULE$.response(message));
    }

    public void sendMessageToAll(Message message) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.socketList().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.sendMessage(Message$.MODULE$.response(message));
            return BoxedUnit.UNIT;
        });
    }

    public void sendMessageToUser(String user, Message message) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.socketList().values()).asScala()).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerServer.$anonfun$sendMessageToUser$1(user, s)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.sendMessage(Message$.MODULE$.response(message));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onClose(ServerSocket socket, int code, String message) {
        String date = DateFormatUtils.format((long)socket.createTime(), (String)((String)Configuration$.MODULE$.DEFAULT_DATE_PATTERN().getValue()));
        if (!this.socketList().containsKey(BoxesRunTime.boxToInteger((int)socket.id()))) {
            this.logger().warn(new StringBuilder(52).append((Object)socket).append(" created at ").append(date).append(" has expired, ignore the close function!").toString());
            return;
        }
        this.logger().info(new StringBuilder(36).append((Object)socket).append(" closed at ").append(date).append(" with code ").append(code).append(" and message: ").append(message).toString());
        HashMap<Object, ServerSocket> hashMap = this.socketList();
        synchronized (hashMap) {
            Object object = this.socketList().containsKey(BoxesRunTime.boxToInteger((int)socket.id())) ? this.socketList().remove(BoxesRunTime.boxToInteger((int)socket.id())) : BoxedUnit.UNIT;
        }
    }

    @Override
    public void onOpen(ServerSocket socket) {
        HashMap<Object, ServerSocket> hashMap = this.socketList();
        synchronized (hashMap) {
            int index = this.idGenerator().getAndIncrement();
            socket.id_$eq(index);
            this.socketList().put(BoxesRunTime.boxToInteger((int)index), socket);
            this.logger().info(new StringBuilder(31).append("open a new ").append((Object)socket).append(" with id ").append(index).append(" for user ").append(socket.user().orNull(Predef$.MODULE$.$conforms())).append("!").toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onMessage(ServerSocket socket, String message) {
        Object object = new Object();
        try {
            if (StringUtils.isBlank((CharSequence)message)) {
                socket.sendMessage(Message$.MODULE$.response(Message$.MODULE$.error("Empty message!")));
                return;
            }
            SocketServerEvent socketServerEvent = (SocketServerEvent)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> new SocketServerEvent(socket, message), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().warn("parse message failed!", t);
                socket.sendMessage(Message$.MODULE$.response(Message$.MODULE$.error(ExceptionUtils.getRootCauseMessage((Throwable)t), (Throwable)t)));
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            if (socket.user().isEmpty()) {
                String string = socketServerEvent.serverEvent().getMethod();
                Object object2 = ServerConfiguration$.MODULE$.BDP_SERVER_SOCKET_LOGIN_URI().getValue();
                if (string == null ? object2 != null : !string.equals(object2)) {
                    socket.sendMessage(Message$.MODULE$.response(Message$.MODULE$.noLogin("You are not logged in, please login first!(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55!)").data("websocketTag", socketServerEvent.serverEvent().getWebsocketTag()).$less$less(socketServerEvent.serverEvent().getMethod())));
                    return;
                }
            }
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.serverListenerEventBus.post(socketServerEvent), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                ControllerServer.$anonfun$onMessage$4(socketServerEvent, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            ex.value$mcV$sp();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendMessageToUser$1(String user$1, ServerSocket s) {
        return s != null && s.user().contains((Object)user$1);
    }

    public static final /* synthetic */ void $anonfun$onMessage$4(SocketServerEvent socketServerEvent$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof BDPServerErrorException) {
            BDPServerErrorException bDPServerErrorException = (BDPServerErrorException)((Object)throwable);
            Message$.MODULE$.error(bDPServerErrorException.getMessage(), (Throwable)((Object)bDPServerErrorException)).data("websocketTag", socketServerEvent$1.serverEvent().getWebsocketTag()).$less$less(socketServerEvent$1.serverEvent().getMethod());
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public ControllerServer(ServerListenerEventBus serverListenerEventBus) {
        this.serverListenerEventBus = serverListenerEventBus;
        Logging.$init$((Logging)this);
        this.socketList = new HashMap(BoxesRunTime.unboxToInt((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SOCKET_QUEUE_SIZE().getValue()));
        this.idGenerator = new AtomicInteger(0);
    }
}

