/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.optimize;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.MetaObject;

public class JsqlParserCountOptimize
implements ISqlParser {
    private static final List<SelectItem> COUNT_SELECT_ITEM = Collections.singletonList(JsqlParserCountOptimize.defaultCountSelectItem());
    private final Log logger = LogFactory.getLog(JsqlParserCountOptimize.class);
    private boolean optimizeJoin = false;

    private static SelectItem defaultCountSelectItem() {
        Function function = new Function();
        ExpressionList expressionList = new ExpressionList(Collections.singletonList(new LongValue(1L)));
        function.setName("COUNT");
        function.setParameters(expressionList);
        return new SelectExpressionItem((Expression)function);
    }

    public SqlInfo parser(MetaObject metaObject, String sql) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JsqlParserCountOptimize sql=" + sql);
        }
        SqlInfo sqlInfo = SqlInfo.newInstance();
        try {
            Select selectStatement = (Select)CCJSqlParserUtil.parse((String)sql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            GroupByElement groupBy = plainSelect.getGroupBy();
            List orderBy = plainSelect.getOrderByElements();
            if (null == groupBy && CollectionUtils.isNotEmpty((Collection)orderBy)) {
                plainSelect.setOrderByElements(null);
                sqlInfo.setOrderBy(false);
            }
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!item.toString().contains("?")) continue;
                return sqlInfo.setSql(SqlParserUtils.getOriginalCountSql(selectStatement.toString()));
            }
            if (distinct != null || null != groupBy) {
                return sqlInfo.setSql(SqlParserUtils.getOriginalCountSql(selectStatement.toString()));
            }
            List joins = plainSelect.getJoins();
            if (this.optimizeJoin && CollectionUtils.isNotEmpty((Collection)joins)) {
                boolean canRemoveJoin = true;
                String whereS = Optional.ofNullable(plainSelect.getWhere()).map(Object::toString).orElse("");
                whereS = whereS.toLowerCase();
                for (Join join : joins) {
                    if (!join.isLeft()) {
                        canRemoveJoin = false;
                        break;
                    }
                    Table table = (Table)join.getRightItem();
                    String str = Optional.ofNullable(table.getAlias()).map(Alias::getName).orElse(table.getName()) + ".";
                    str = str.toLowerCase();
                    String onExpressionS = join.getOnExpression().toString();
                    if (!onExpressionS.contains("?") && !whereS.contains(str)) continue;
                    canRemoveJoin = false;
                    break;
                }
                if (canRemoveJoin) {
                    plainSelect.setJoins(null);
                }
            }
            plainSelect.setSelectItems(COUNT_SELECT_ITEM);
            return sqlInfo.setSql(selectStatement.toString());
        }
        catch (Throwable e) {
            return sqlInfo.setSql(SqlParserUtils.getOriginalCountSql(sql));
        }
    }

    public Log getLogger() {
        return this.logger;
    }

    public boolean isOptimizeJoin() {
        return this.optimizeJoin;
    }

    public void setOptimizeJoin(boolean optimizeJoin) {
        this.optimizeJoin = optimizeJoin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsqlParserCountOptimize)) {
            return false;
        }
        JsqlParserCountOptimize other = (JsqlParserCountOptimize)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptimizeJoin() != other.isOptimizeJoin()) {
            return false;
        }
        Log this$logger = this.getLogger();
        Log other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsqlParserCountOptimize;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptimizeJoin() ? 79 : 97);
        Log $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "JsqlParserCountOptimize(logger=" + this.getLogger() + ", optimizeJoin=" + this.isOptimizeJoin() + ")";
    }

    public JsqlParserCountOptimize() {
    }

    public JsqlParserCountOptimize(boolean optimizeJoin) {
        this.optimizeJoin = optimizeJoin;
    }
}

