/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.basedatamanager.server.domain.GatewayAuthTokenEntity;
import org.apache.linkis.basedatamanager.server.service.GatewayAuthTokenService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"GatewayAuthTokenRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/gateway-auth-token"})
public class GatewayAuthTokenRestfulApi {
    @Autowired
    GatewayAuthTokenService gatewayAuthTokenService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="list Gateway Auth Tokens", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of Gateway Auth Token,search name:" + searchName));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        PageInfo pageList = this.gatewayAuthTokenService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get a Gateway Auth Token Record by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Gateway Auth Token Record,id:" + id.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        GatewayAuthTokenEntity gatewayAuthToken = (GatewayAuthTokenEntity)this.gatewayAuthTokenService.getById(id);
        return Message.ok((String)"").data("item", (Object)gatewayAuthToken);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="GatewayAuthTokenEntity", name="gatewayAuthToken")})
    @ApiOperation(value="add", notes="Add a Gateway Auth Token Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody GatewayAuthTokenEntity gatewayAuthToken) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Gateway Auth Token Record," + gatewayAuthToken.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        gatewayAuthToken.setCreateTime(new Date());
        gatewayAuthToken.setUpdateTime(new Date());
        gatewayAuthToken.setBusinessOwner("BDP");
        gatewayAuthToken.setUpdateBy(username);
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Gateway Auth Token Record," + gatewayAuthToken.toString()));
        boolean result = this.gatewayAuthTokenService.save(gatewayAuthToken);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="GatewayAuthTokenEntity", name="token")})
    @ApiOperation(value="update", notes="Update a Gateway Auth Token Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody GatewayAuthTokenEntity token) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Gateway Auth Token Record,id:" + token.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        token.setUpdateTime(new Date());
        token.setUpdateBy(username);
        boolean result = this.gatewayAuthTokenService.updateById(token);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="tokenName")})
    @ApiOperation(value="remove", notes="Remove a Gateway Auth Token Record by token name", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Try to remove gateway auto token record with id:" + id));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.gatewayAuthTokenService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="checkName"), @ApiImplicitParam(paramType="query", dataType="string", name="token")})
    @ApiOperation(value="Check", notes="Check the incoming token", httpMethod="GET")
    @RequestMapping(path={"/check"}, method={RequestMethod.GET})
    public Message checkAuth(HttpServletRequest request, String token, String checkName) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Try to check auth token with checkName:" + checkName));
        Boolean checkResult = false;
        if (StringUtils.isBlank((CharSequence)checkName)) {
            return Message.error((String)" checkName can not be empty [\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a]");
        }
        if (StringUtils.isBlank((CharSequence)checkName)) {
            return Message.error((String)" token can not be empty [token\u4e0d\u80fd\u4e3a\u7a7a]");
        }
        GatewayAuthTokenEntity authToken = this.gatewayAuthTokenService.getEntityByToken(token);
        if (null == authToken) return Message.error((String)"Invalid Token(\u6570\u636e\u5e93\u4e2d\u672a\u914d\u7f6e\u7684\u65e0\u6548\u4ee4\u724c)");
        Long elapseDay = authToken.getElapseDay();
        Date createTime = authToken.getCreateTime();
        if (elapseDay != -1L && System.currentTimeMillis() > createTime.getTime() + elapseDay * 24L * 3600L * 1000L) {
            return Message.error((String)("Token is not valid or stale(" + token + " \u4ee4\u724c\u5df2\u8fc7\u671f)!")).data("result", (Object)checkResult);
        }
        String legalUsers = authToken.getLegalUsers();
        if (!StringUtils.isNotBlank((CharSequence)legalUsers)) return Message.ok().data("result", (Object)checkResult);
        if (!legalUsers.equals("*") && !legalUsers.contains(checkName)) return Message.error((String)("Illegal TokenUser for Token(Token\u975e\u6cd5\u7528\u6237: " + checkName + ")!")).data("result", (Object)checkResult);
        checkResult = true;
        return Message.ok().data("result", (Object)checkResult);
    }
}

