/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.linkis.configuration.dao.AcrossClusterRuleMapper;
import org.apache.linkis.configuration.entity.AcrossClusterRule;
import org.apache.linkis.configuration.service.AcrossClusterRuleService;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.governance.common.protocol.conf.AcrossClusterRequest;
import org.apache.linkis.governance.common.protocol.conf.AcrossClusterResponse;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcrossClusterRuleServiceImpl
implements AcrossClusterRuleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AcrossClusterRuleMapper ruleMapper;

    @Override
    public void deleteAcrossClusterRule(Long id) throws Exception {
        AcrossClusterRule beforeRule = this.ruleMapper.getAcrossClusterRule(id, null);
        if (beforeRule == null) {
            throw new Exception("acrossClusterRule not exit");
        }
        this.ruleMapper.deleteAcrossClusterRule(id);
    }

    @Override
    public void deleteAcrossClusterRuleByBatch(List<Long> ids) throws Exception {
        this.ruleMapper.deleteAcrossClusterRuleByBatch(ids);
    }

    @Override
    public void deleteAcrossClusterRuleByUsername(String username) throws Exception {
        this.ruleMapper.deleteAcrossClusterRuleByUsername(username);
    }

    @Override
    public void deleteAcrossClusterRuleByCrossQueue(String crossQueue) throws Exception {
        this.ruleMapper.deleteAcrossClusterRuleByCrossQueue(crossQueue);
    }

    @Override
    public void updateAcrossClusterRule(AcrossClusterRule newRule) throws Exception {
        AcrossClusterRule beforeRule = this.ruleMapper.getAcrossClusterRule(newRule.getId(), null);
        if (beforeRule == null) {
            throw new Exception("acrossClusterRule not exit");
        }
        Date time = new Date();
        newRule.setCreateBy(beforeRule.getCreateBy());
        newRule.setCreateTime(beforeRule.getCreateTime());
        newRule.setUpdateTime(time);
        this.ruleMapper.updateAcrossClusterRule(newRule);
    }

    @Override
    public void updateAcrossClusterRuleByBatch(List<Long> ids, AcrossClusterRule newRule) throws Exception {
        Date time = new Date();
        newRule.setUpdateTime(time);
        this.ruleMapper.updateAcrossClusterRuleByBatch(ids, newRule);
    }

    @Override
    public void insertAcrossClusterRule(AcrossClusterRule acrossClusterRule) throws Exception {
        Date time = new Date();
        acrossClusterRule.setCreateTime(time);
        acrossClusterRule.setUpdateTime(time);
        this.ruleMapper.insertAcrossClusterRule(acrossClusterRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryAcrossClusterRuleList(String creator, String username, String clusterName, Integer pageNow, Integer pageSize, String isValid) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<AcrossClusterRule> acrossClusterRules = null;
        if (Objects.isNull(pageNow)) {
            pageNow = 1;
        }
        if (Objects.isNull(pageSize)) {
            pageSize = 20;
        }
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            acrossClusterRules = this.ruleMapper.queryAcrossClusterRuleList(username, creator, clusterName, isValid);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(acrossClusterRules);
        result.put("acrossClusterRuleList", acrossClusterRules);
        result.put(JobRequestConstants.TOTAL_PAGE(), pageInfo.getTotal());
        return result;
    }

    @Override
    public void validAcrossClusterRule(Long id, String isValid, String username) throws Exception {
        AcrossClusterRule beforeRule = this.ruleMapper.getAcrossClusterRule(id, username);
        if (beforeRule == null) {
            throw new Exception("acrossClusterRule not exit");
        }
        this.ruleMapper.validAcrossClusterRule(isValid, id, username);
    }

    @Override
    public void validAcrossClusterRuleByBatch(List<Long> ids, String isValid) throws Exception {
        this.ruleMapper.validAcrossClusterRuleByBatch(ids, isValid);
    }

    @Override
    @Receiver
    public AcrossClusterResponse getAcrossClusterRuleByUsername(AcrossClusterRequest acrossClusterRequest, Sender sender) throws Exception {
        String username = acrossClusterRequest.username();
        AcrossClusterRule acrossClusterRule = this.ruleMapper.queryAcrossClusterRuleByUserName(username);
        if (acrossClusterRule == null) {
            return null;
        }
        String clusterName = acrossClusterRule.getClusterName();
        Map rulesMap = new HashMap();
        try {
            Gson gson = BDPJettyServerHelper.gson();
            rulesMap = (Map)gson.fromJson(acrossClusterRule.getRules(), rulesMap.getClass());
            Map queueRule = (Map)rulesMap.get("queueRule");
            String crossQueueName = (String)queueRule.get("crossQueue");
            this.logger.info("{} configure across cluster name is {}, queue name is {}", new Object[]{username, acrossClusterRule.getClusterName(), crossQueueName});
            return new AcrossClusterResponse(clusterName, crossQueueName);
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse rulesMap from rules");
            return null;
        }
    }
}

