/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.starrocks.ast.expr.StarRocksCharExpr;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class StarRocksExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public StarRocksExprParser(String sql) {
        this(new StarRocksLexer(sql));
        this.lexer.nextToken();
    }

    public StarRocksExprParser(String sql, DbType dbType, SQLParserFeature ... features) {
        super(sql, dbType, features);
    }

    public StarRocksExprParser(Lexer lexer) {
        super(lexer, DbType.starrocks);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public StarRocksExprParser(String sql, boolean keepComments) {
        this(new StarRocksLexer(sql, true, keepComments));
        this.lexer.nextToken();
    }

    public StarRocksExprParser(String sql, boolean skipComment, boolean keepComments) {
        this(new StarRocksLexer(sql, skipComment, keepComments));
        this.lexer.nextToken();
    }

    public StarRocksExprParser(Lexer lexer, DbType dbType) {
        super(lexer, dbType);
    }

    public StarRocksExprParser(String sql, SQLParserFeature ... features) {
        super(new StarRocksLexer(sql, features), DbType.starrocks);
        this.lexer.nextToken();
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        String text = this.lexer.stringVal();
        for (int i = 0; i < AGGREGATE_FUNCTIONS.length; ++i) {
            if (!text.equalsIgnoreCase(AGGREGATE_FUNCTIONS[i])) continue;
            StarRocksCharExpr aggType = new StarRocksCharExpr(text);
            column.setAggType(aggType);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            StarRocksCharExpr bitmap = new StarRocksCharExpr(this.lexer.stringVal());
            column.setBitmap(bitmap);
            this.lexer.nextToken();
            this.accept(Token.COMMENT);
            StarRocksCharExpr indexComment = new StarRocksCharExpr(this.lexer.stringVal());
            column.setIndexComment(indexComment);
            this.lexer.nextToken();
        }
        return super.parseColumnRest(column);
    }

    @Override
    public SQLPartition parsePartition() {
        SQLName name;
        if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITION) || this.lexer.identifierEquals(FnvHash.Constants.TBPARTITION) || this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.PARTITION);
        }
        SQLPartition partitionDef = new SQLPartition();
        if (this.lexer.token() == Token.LITERAL_INT) {
            Number number = this.lexer.integerValue();
            name = new SQLIdentifierExpr(number.toString());
            this.lexer.nextToken();
        } else {
            name = this.name();
        }
        partitionDef.setName(name);
        SQLPartitionValue values = this.parsePartitionValues();
        if (values != null) {
            partitionDef.setValues(values);
        }
        while (true) {
            boolean storage = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setDataDirectory(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName tableSpace = this.name();
                partitionDef.setTablespace(tableSpace);
                continue;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setIndexDirectory(this.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAX_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr maxRows = this.primary();
                partitionDef.setMaxRows(maxRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MIN_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr minRows = this.primary();
                partitionDef.setMaxRows(minRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE) || (storage = this.lexer.token() == Token.STORAGE || this.lexer.identifierEquals(FnvHash.Constants.STORAGE))) {
                if (storage) {
                    this.lexer.nextToken();
                }
                this.acceptIdentifier("ENGINE");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName engine = this.name();
                partitionDef.setEngine(engine);
                continue;
            }
            if (this.lexer.token() != Token.COMMENT) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr comment = this.primary();
            partitionDef.setComment(comment);
        }
        if (this.lexer.identifierEquals("LOCALITY")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr locality = this.expr();
            partitionDef.setLocality(locality);
        }
        return partitionDef;
    }

    static {
        String[] strings = new String[]{"SUM", "MAX", "MIN", "REPLACE", "HLL_UNION", "BITMAP_UNION", "REPLACE_IF_NOT_NULL"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            StarRocksExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

