/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.LowCostIdentityHashMap;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;

public abstract class AllocationManager {
    private static final AtomicLong MANAGER_ID_GENERATOR = new AtomicLong(0L);
    private final RootAllocator root;
    private final long allocatorManagerId = MANAGER_ID_GENERATOR.incrementAndGet();
    private final LowCostIdentityHashMap<BaseAllocator, BufferLedger> map = new LowCostIdentityHashMap();
    private final long amCreationTime = System.nanoTime();
    private volatile BufferLedger owningLedger;
    private volatile long amDestructionTime = 0L;

    protected AllocationManager(BaseAllocator accountingAllocator) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.root;
        this.owningLedger = this.associate(accountingAllocator, false);
    }

    BufferLedger getOwningLedger() {
        return this.owningLedger;
    }

    void setOwningLedger(BufferLedger ledger) {
        this.owningLedger = ledger;
    }

    BufferLedger associate(BaseAllocator allocator) {
        return this.associate(allocator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferLedger associate(BaseAllocator allocator, boolean retain) {
        allocator.assertOpen();
        Preconditions.checkState(this.root == allocator.root, "A buffer can only be associated between two allocators that share the same root");
        AllocationManager allocationManager = this;
        synchronized (allocationManager) {
            BufferLedger oldLedger;
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.increment();
                }
                return ledger;
            }
            ledger = new BufferLedger(allocator, this);
            if (retain) {
                ledger.increment();
            }
            Preconditions.checkState((oldLedger = this.map.put(ledger)) == null, "Detected inconsistent state: A reference manager already exists for this allocator");
            allocator.associateLedger(ledger);
            return ledger;
        }
    }

    void release(BufferLedger ledger) {
        BaseAllocator allocator = (BaseAllocator)ledger.getAllocator();
        allocator.assertOpen();
        Preconditions.checkState(this.map.containsKey(allocator), "Expecting a mapping for allocator and reference manager");
        BufferLedger oldLedger = this.map.remove(allocator);
        ((BaseAllocator)oldLedger.getAllocator()).dissociateLedger(oldLedger);
        if (oldLedger == this.owningLedger) {
            if (this.map.isEmpty()) {
                ((BaseAllocator)oldLedger.getAllocator()).releaseBytes(this.getSize());
                this.release0();
                ((BaseAllocator)oldLedger.getAllocator()).getListener().onRelease(this.getSize());
                this.amDestructionTime = System.nanoTime();
                this.owningLedger = null;
            } else {
                BufferLedger newOwningLedger = this.map.getNextValue();
                oldLedger.transferBalance(newOwningLedger);
            }
        } else {
            Preconditions.checkState(this.map.size() > 0, "The final removal of reference manager should be connected to owning reference manager");
        }
    }

    public abstract long getSize();

    protected abstract long memoryAddress();

    protected abstract void release0();

    public static interface Factory {
        public AllocationManager create(BaseAllocator var1, long var2);

        public ArrowBuf empty();
    }
}

