/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.hooks;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.common.hook.EngineConnHook;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkContainerizationEngineConnHook
implements EngineConnHook {
    private static final Logger logger = LoggerFactory.getLogger(SparkContainerizationEngineConnHook.class);

    public void beforeCreateEngineConn(EngineCreationContext engineCreationContext) {
        Map options = engineCreationContext.getOptions();
        String mappingHost = (String)SparkConfiguration.ENGINE_CONN_CONTAINERIZATION_MAPPING_HOST().getValue(options);
        String mappingPorts = (String)SparkConfiguration.ENGINE_CONN_CONTAINERIZATION_MAPPING_PORTS().getValue(options);
        List mappingPortList = Arrays.stream(mappingPorts.trim().split(",")).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList());
        if (mappingPortList.size() == 2) {
            logger.info("\u52a0\u8f7dspark\u5bb9\u5668\u5316\u914d\u7f6e, spark.driver.host={}, spark.driver.port={}, spark.driver.blockManager.port={}", new Object[]{mappingHost, mappingPortList.get(0), mappingPortList.get(1)});
            options.put(SparkConfiguration.SPARK_DRIVER_HOST().key(), mappingHost);
            options.put(SparkConfiguration.SPARK_DRIVER_BIND_ADDRESS().key(), SparkConfiguration.SPARK_DRIVER_BIND_ADDRESS().defaultValue());
            options.put(SparkConfiguration.SPARK_DRIVER_PORT().key(), mappingPortList.get(0));
            options.put(SparkConfiguration.SPARK_DRIVER_BLOCK_MANAGER_PORT().key(), mappingPortList.get(1));
        }
    }

    public void beforeExecutionExecute(EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }

    public void afterExecutionExecute(EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }

    public void afterEngineServerStartFailed(EngineCreationContext engineCreationContext, Throwable throwable) {
    }

    public void afterEngineServerStartSuccess(EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }
}

