/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.common.service;

import com.google.common.cache.Cache;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.cache.CacheConfiguration;
import org.apache.linkis.metadata.query.common.cache.CacheManager;
import org.apache.linkis.metadata.query.common.cache.ConnCacheManager;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.BaseMetadataService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheMetaService<C extends Closeable>
implements BaseMetadataService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCacheMetaService.class);
    private static final String CONN_CACHE_REQ = "_STORED";
    private CacheManager connCacheManager;
    protected Cache<String, MetadataConnection<C>> reqCache;

    @PostConstruct
    public void init() {
        this.connCacheManager = ConnCacheManager.custom();
        this.initCache(this.connCacheManager);
    }

    protected void initCache(CacheManager cacheManager) {
        if (this.useCache()) {
            String prefix = this.getClass().getSimpleName();
            this.reqCache = cacheManager.buildCache(prefix + CONN_CACHE_REQ, notification -> {
                assert (notification.getValue() != null);
                this.close((Closeable)((MetadataConnection)notification.getValue()).getConnection());
            });
            this.reqCache.cleanUp();
        }
    }

    protected boolean useCache() {
        return true;
    }

    public abstract MetadataConnection<C> getConnection(String var1, Map<String, Object> var2) throws Exception;

    @Override
    public Map<String, String> getConnectionInfo(String operator, Map<String, Object> params, Map<String, String> queryParams) {
        return this.getConnAndRun(operator, params, connection -> this.queryConnectionInfo(connection, queryParams));
    }

    public void close(C connection) {
        try {
            connection.close();
        }
        catch (IOException e) {
            throw new MetaRuntimeException("Fail to close connection[\u5173\u95ed\u8fde\u63a5\u5931\u8d25], [" + e.getMessage() + "]", e);
        }
    }

    public Map<String, String> queryConnectionInfo(C connection, Map<String, String> queryParams) {
        return Collections.emptyMap();
    }

    protected <R> R getConnAndRun(String operator, Map<String, Object> params, Function<C, R> action) {
        String cacheKey = "";
        MetadataConnection<C> connection = null;
        try {
            ConnectionCache<Object> connectionCache;
            cacheKey = this.md5String(Json.toJson(params, null), "", 2);
            cacheKey = operator + "_" + this.md5String(Json.toJson(params, null), "", 2);
            if (null != this.reqCache) {
                connectionCache = this.getConnectionInCache(this.reqCache, cacheKey, () -> this.getConnection(operator, params));
                connection = connectionCache.connection;
                cacheKey = connectionCache.cacheKey;
            } else {
                connection = this.getConnection(operator, params);
            }
            connectionCache = this.run(connection, action);
            return (R)connectionCache;
        }
        catch (Exception e) {
            LOG.error("Error to invoke meta service", (Throwable)e);
            if (StringUtils.isNotBlank((CharSequence)cacheKey) && Objects.nonNull(this.reqCache)) {
                this.reqCache.invalidate((Object)cacheKey);
            }
            throw new MetaRuntimeException(e.getMessage(), e);
        }
        finally {
            if (Objects.nonNull(connection) && connection.isLock() && connection.getLock().isHeldByCurrentThread()) {
                connection.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R run(MetadataConnection<C> connection, Function<C, R> action) {
        if (connection.isLock()) {
            if (!connection.getLock().isHeldByCurrentThread()) {
                connection.getLock().lock();
                try {
                    R r = action.apply(connection.getConnection());
                    return r;
                }
                finally {
                    connection.getLock().unlock();
                }
            }
            return action.apply(connection.getConnection());
        }
        return action.apply(connection.getConnection());
    }

    private ConnectionCache<C> getConnectionInCache(Cache<String, MetadataConnection<C>> cache, String cacheKey, Callable<? extends MetadataConnection<C>> callable) throws ExecutionException {
        int poolSize = (Integer)CacheConfiguration.CACHE_IN_POOL_SIZE.getValue();
        if (poolSize <= 0) {
            poolSize = 1;
        }
        MetadataConnection connection = null;
        String cacheKeyInPool = cacheKey + "_0";
        for (int i = 0; i < poolSize && (connection = (MetadataConnection)cache.get((Object)cacheKeyInPool, callable)).isLock() && !connection.getLock().tryLock(); ++i) {
            cacheKeyInPool = cacheKey + "_" + i;
            LOG.info("The connection cache: [" + cacheKeyInPool + "] has been occupied, now to find the other in pool");
        }
        return new ConnectionCache(cacheKeyInPool, connection);
    }

    private String md5String(String source, String salt, int iterator) {
        StringBuilder token = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("md5");
            if (StringUtils.isNotEmpty((CharSequence)salt)) {
                digest.update(salt.getBytes(StandardCharsets.UTF_8));
            }
            byte[] result = digest.digest(source.getBytes());
            for (int i = 0; i < iterator - 1; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            for (byte aResult : result) {
                int temp = aResult & 0xFF;
                if (temp <= 15) {
                    token.append("0");
                }
                token.append(Integer.toHexString(temp));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return token.toString();
    }

    private static class ConnectionCache<C> {
        MetadataConnection<C> connection;
        String cacheKey;

        public ConnectionCache(String cacheKey, MetadataConnection<C> connection) {
            this.cacheKey = cacheKey;
            this.connection = connection;
        }
    }
}

