/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.RepresentationBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.service.Header;
import springfox.documentation.service.Representation;
import springfox.documentation.service.Response;
import springfox.documentation.service.VendorExtension;

public class ResponseBuilder {
    private String code;
    private String description;
    private Boolean isDefault = false;
    private final List<Header> headers = new ArrayList<Header>();
    private final Map<MediaType, RepresentationBuilder> representations = new HashMap<MediaType, RepresentationBuilder>();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private final List<Example> examples = new ArrayList<Example>();

    public ResponseBuilder code(String code) {
        this.code = BuilderDefaults.defaultIfAbsent(code, this.code);
        return this;
    }

    public ResponseBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ResponseBuilder isDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public ResponseBuilder headers(Collection<Header> headers) {
        this.headers.addAll(headers);
        return this;
    }

    private RepresentationBuilder representationBuilderFor(MediaType mediaType) {
        return this.representations.computeIfAbsent(mediaType, m -> new RepresentationBuilder().mediaType((MediaType)m));
    }

    public Function<Consumer<RepresentationBuilder>, ResponseBuilder> representation(MediaType mediaType) {
        return content -> {
            content.accept(this.representationBuilderFor(mediaType));
            return this;
        };
    }

    public ResponseBuilder vendorExtensions(Collection<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public ResponseBuilder examples(Collection<Example> examples) {
        this.examples.addAll(examples);
        return this;
    }

    public ResponseBuilder copyOf(Response source) {
        if (source == null) {
            return this;
        }
        source.getRepresentations().forEach(each -> this.representation(each.getMediaType()).apply(r -> r.copyOf((Representation)each)));
        this.code(source.getCode()).description(source.getDescription()).examples(source.getExamples()).headers(source.getHeaders()).isDefault(source.isDefault()).vendorExtensions(source.getVendorExtensions());
        return this;
    }

    public Response build() {
        return new Response(this.code, this.description, this.isDefault, this.headers, this.representations.values().stream().map(RepresentationBuilder::build).collect(Collectors.toSet()), this.examples, this.vendorExtensions);
    }
}

