/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc;

import feign.Feign;
import feign.Logger;
import feign.Retryer;
import feign.slf4j.Slf4jLogger;
import java.io.Serializable;
import java.util.Map;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.protocol.Protocol;
import org.apache.linkis.rpc.AsynRPCMessageBus;
import org.apache.linkis.rpc.BaseRPCSender$;
import org.apache.linkis.rpc.RPCMessageEvent;
import org.apache.linkis.rpc.RPCReceiveRemote;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.interceptor.BaseRPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.BaseRPCInterceptorExchange;
import org.apache.linkis.rpc.interceptor.RPCInterceptor;
import org.apache.linkis.rpc.interceptor.RPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.RPCInterceptorExchange;
import org.apache.linkis.rpc.transform.RPCConsumer$;
import org.apache.linkis.rpc.transform.RPCProduct$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h!B\u0011#\u0001\tR\u0003\"B\u001c\u0001\t\u0003I\u0004\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003=\u0011%Q\u0005\u00011AA\u0002\u0013%1\nC\u0005S\u0001\u0001\u0007\t\u0011)Q\u0005{!I1\u0005\u0001a\u0001\u0002\u0004%Ia\u0015\u0005\n/\u0002\u0001\r\u00111A\u0005\naC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\t\u000bm\u0003A\u0011\u0003/\t\u000b\u0019\u0004A\u0011C4\t\u000b-\u0004A\u0011\u00037\t\u000b]\u0002A\u0011A@\t\r\u0005\u0015\u0001\u0001\"\u0003T\u0011\u001d\t9\u0001\u0001C\u0001EqBq!!\u0003\u0001\t#\tY\u0001\u0003\u0004\u0002&\u0001!\tb\u0015\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\r\u0001\t\u0003\nI\u0004C\u0004\u0002R\u0001!I!a\u0015\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA<\u0001\u0011E\u0011\u0011\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\ty\t\u0001C!\u0003#Cq!!'\u0001\t\u0003\nYj\u0002\u0005\u0002\u001e\nB\tAIAP\r\u001d\t#\u0005#\u0001#\u0003CCaaN\u000e\u0005\u0002\u0005%\u0006\"CAV7\t\u0007I\u0011BA=\u0011!\tik\u0007Q\u0001\n\u0005m\u0004bBAX7\u0011\u0005\u0011\u0011\u0017\u0005\b\u00033\\B\u0011AAn\u00055\u0011\u0015m]3S!\u000e\u001bVM\u001c3fe*\u00111\u0005J\u0001\u0004eB\u001c'BA\u0013'\u0003\u0019a\u0017N\\6jg*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h'\r\u00011f\f\t\u0003Y5j\u0011AI\u0005\u0003]\t\u0012aaU3oI\u0016\u0014\bC\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0015)H/\u001b7t\u0015\t!D%\u0001\u0004d_6lwN\\\u0005\u0003mE\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0004C\u0001\u0017\u0001\u0003\u0011q\u0017-\\3\u0016\u0003u\u0002\"AP$\u000f\u0005}*\u0005C\u0001!D\u001b\u0005\t%B\u0001\"9\u0003\u0019a$o\\8u})\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\u00061\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t15)\u0001\u0005oC6,w\fJ3r)\ta\u0005\u000b\u0005\u0002N\u001d6\t1)\u0003\u0002P\u0007\n!QK\\5u\u0011\u001d\t6!!AA\u0002u\n1\u0001\u001f\u00132\u0003\u0015q\u0017-\\3!+\u0005!\u0006C\u0001\u0017V\u0013\t1&E\u0001\tS!\u000e\u0013VmY3jm\u0016\u0014V-\\8uK\u00069!\u000f]2`I\u0015\fHC\u0001'Z\u0011\u001d\tf!!AA\u0002Q\u000bAA\u001d9dA\u0005\u0011r-\u001a;S!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:t+\u0005i\u0006cA'_A&\u0011ql\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\n\n1\"\u001b8uKJ\u001cW\r\u001d;pe&\u0011QM\u0019\u0002\u000f%B\u001b\u0015J\u001c;fe\u000e,\u0007\u000f^8s\u0003e\u0019'/Z1uKJ\u00036)\u00138uKJ\u001cW\r\u001d;pe\u000eC\u0017-\u001b8\u0015\u0003!\u0004\"!Y5\n\u0005)\u0014'a\u0005*Q\u0007&sG/\u001a:dKB$xN]\"iC&t\u0017\u0001H2sK\u0006$XM\u0015)D\u0013:$XM]2faR|'/\u0012=dQ\u0006tw-\u001a\u000b\u0004[B<\bCA1o\u0013\ty'M\u0001\fS!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:Fq\u000eD\u0017M\\4f\u0011\u0015\t(\u00021\u0001s\u0003!\u0001(o\u001c;pG>d\u0007CA:v\u001b\u0005!(BA9%\u0013\t1HO\u0001\u0005Qe>$xnY8m\u0011\u0019A(\u0002\"a\u0001s\u0006\u0011q\u000e\u001d\t\u0004\u001bjd\u0018BA>D\u0005!a$-\u001f8b[\u0016t\u0004CA'~\u0013\tq8IA\u0002B]f$2AOA\u0001\u0011\u0019\t\u0019a\u0003a\u0001{\u0005y\u0011\r\u001d9mS\u000e\fG/[8o\u001d\u0006lW-\u0001\u0004hKR\u0014\u0006kQ\u0001\u0013O\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u001d\u0006lW-A\u0005e_\n+\u0018\u000e\u001c3feR\u0019A*!\u0004\t\u000f\u0005=a\u00021\u0001\u0002\u0012\u00059!-^5mI\u0016\u0014\b\u0003BA\n\u0003?qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0003\u00033\tQAZ3jO:LA!!\b\u0002\u0018\u0005)a)Z5h]&!\u0011\u0011EA\u0012\u0005\u001d\u0011U/\u001b7eKJTA!!\b\u0002\u0018\u00051a.Z<S!\u000e\u000bq!\u001a=fGV$X\r\u0006\u0003\u0002,\u0005=Bc\u0001?\u0002.!1\u0001\u0010\u0005CA\u0002eDa!!\r\u0011\u0001\u0004a\u0018aB7fgN\fw-Z\u0001\u0004CN\\Gc\u0001?\u00028!1\u0011\u0011G\tA\u0002q$R\u0001`A\u001e\u0003{Aa!!\r\u0013\u0001\u0004a\bbBA %\u0001\u0007\u0011\u0011I\u0001\bi&lWm\\;u!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003\u0017\u001a\u0015AC2p]\u000e,(O]3oi&!\u0011qJA#\u0005!!UO]1uS>t\u0017AB:f]\u0012LE\u000fF\u0003M\u0003+\n9\u0006\u0003\u0004\u00022M\u0001\r\u0001 \u0005\u0007qN\u0001\r!!\u0017\u0011\u000f5\u000bY&a\u0018\u0002`%\u0019\u0011QL\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015D%\u0001\u0004tKJ4XM]\u0005\u0005\u0003S\n\u0019GA\u0004NKN\u001c\u0018mZ3\u0002\tM,g\u000e\u001a\u000b\u0004\u0019\u0006=\u0004BBA\u0019)\u0001\u0007A0A\u0004eK2Lg/\u001a:\u0015\u00071\u000b)\b\u0003\u0004\u00022U\u0001\r\u0001`\u0001\u0018O\u0016$(\u000bU\"TK:$WM\u001d'jgR,g.\u001a:CkN,\"!a\u001f\u0011\u00071\ni(C\u0002\u0002\u0000\t\u0012\u0011#Q:z]J\u00036)T3tg\u0006<WMQ;t\u0003\u0019)\u0017/^1mgR!\u0011QQAF!\ri\u0015qQ\u0005\u0004\u0003\u0013\u001b%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001b;\u0002\u0019\u0001?\u0002\u0007=\u0014'.\u0001\u0005iCND7i\u001c3f)\t\t\u0019\nE\u0002N\u0003+K1!a&D\u0005\rIe\u000e^\u0001\ti>\u001cFO]5oOR\tQ(A\u0007CCN,'\u000bU\"TK:$WM\u001d\t\u0003Ym\u0019BaGAR_A\u0019Q*!*\n\u0007\u0005\u001d6I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003?\u000bAC\u001d9d'\u0016tG-\u001a:MSN$XM\\3s\u0005V\u001c\u0018!\u0006:qGN+g\u000eZ3s\u0019&\u001cH/\u001a8fe\n+8\u000fI\u0001\u0010C\u0012$\u0017J\\:uC:\u001cW-\u00138g_V!\u00111WAg)\ra\u0015Q\u0017\u0005\b\u0003o{\u0002\u0019AA]\u0003\ri\u0017\r\u001d\t\b\u0003w\u000b)-PAe\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017\u0001B;uS2T!!a1\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\fiLA\u0002NCB\u0004B!a3\u0002N2\u0001AaBAh?\t\u0007\u0011\u0011\u001b\u0002\u0002)F\u0019\u00111\u001b?\u0011\u00075\u000b).C\u0002\u0002X\u000e\u0013qAT8uQ&tw-A\bhKRLen\u001d;b]\u000e,\u0017J\u001c4p+\u0011\ti.!<\u0015\t\u0005}\u0017q\u001d\t\u0005\u0003C\f\u0019/D\u00014\u0013\r\t)o\r\u0002\u0010'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dK\"9\u0011q\u0017\u0011A\u0002\u0005%\bcBA^\u0003\u000bl\u00141\u001e\t\u0005\u0003\u0017\fi\u000fB\u0004\u0002P\u0002\u0012\r!!5")
public class BaseRPCSender
extends Sender
implements Logging {
    private String name;
    private RPCReceiveRemote rpc;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static <T> ServiceInstance getInstanceInfo(Map<String, T> map) {
        return BaseRPCSender$.MODULE$.getInstanceInfo(map);
    }

    public static <T> void addInstanceInfo(Map<String, T> map) {
        BaseRPCSender$.MODULE$.addInstanceInfo(map);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        BaseRPCSender baseRPCSender = this;
        synchronized (baseRPCSender) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String name() {
        return this.name;
    }

    private void name_$eq(String x$1) {
        this.name = x$1;
    }

    private RPCReceiveRemote rpc() {
        return this.rpc;
    }

    private void rpc_$eq(RPCReceiveRemote x$1) {
        this.rpc = x$1;
    }

    public RPCInterceptor[] getRPCInterceptors() {
        return (RPCInterceptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RPCInterceptor.class));
    }

    public RPCInterceptorChain createRPCInterceptorChain() {
        return new BaseRPCInterceptorChain(0, this.getRPCInterceptors(), this.getApplicationName());
    }

    public RPCInterceptorExchange createRPCInterceptorExchange(Protocol protocol, Function0<Object> op) {
        return new BaseRPCInterceptorExchange(protocol, op);
    }

    private RPCReceiveRemote getRPC() {
        if (this.rpc() == null) {
            BaseRPCSender baseRPCSender = this;
            synchronized (baseRPCSender) {
                if (this.rpc() == null) {
                    this.rpc_$eq(this.newRPC());
                }
            }
        }
        return this.rpc();
    }

    public String getApplicationName() {
        return this.name();
    }

    public void doBuilder(Feign.Builder builder) {
        builder.retryer(Retryer.NEVER_RETRY);
    }

    public RPCReceiveRemote newRPC() {
        String url;
        Feign.Builder builder = Feign.builder().logger((feign.Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL);
        this.doBuilder(builder);
        String string = url = this.name().startsWith("http://") ? this.name() : new StringBuilder(7).append("http://").append(this.name()).toString();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        url = new StringBuilder(0).append(url).append(ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_URI().getValue()).toString();
        return (RPCReceiveRemote)builder.target(RPCReceiveRemote.class, url);
    }

    private Object execute(Object message, Function0<Object> op) {
        Object object = message;
        if (object instanceof Protocol) {
            Protocol protocol = (Protocol)object;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getRPCInterceptors())).nonEmpty()) {
                RPCInterceptorChain rpcInterceptorChain = this.createRPCInterceptorChain();
                return rpcInterceptorChain.handle(this.createRPCInterceptorExchange(protocol, op));
            }
        }
        return op.apply();
    }

    @Override
    public Object ask(Object message) {
        return this.execute(message, (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Message msg = RPCProduct$.MODULE$.getRPCProduct().toMessage(message);
            BaseRPCSender$.MODULE$.addInstanceInfo(msg.getData());
            Message response = this.getRPC().receiveAndReply(msg);
            return RPCConsumer$.MODULE$.getRPCConsumer().toObject(response);
        });
    }

    @Override
    public Object ask(Object message, Duration timeout) {
        return this.execute(message, (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Message msg = RPCProduct$.MODULE$.getRPCProduct().toMessage(message);
            msg.data("duration", (Object)BoxesRunTime.boxToLong((long)timeout.toMillis()));
            BaseRPCSender$.MODULE$.addInstanceInfo(msg.getData());
            Message response = this.getRPC().receiveAndReplyInMills(msg);
            return RPCConsumer$.MODULE$.getRPCConsumer().toObject(response);
        });
    }

    private void sendIt(Object message, Function1<Message, Message> op) {
        this.execute(message, (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Message msg = RPCProduct$.MODULE$.getRPCProduct().toMessage(message);
            BaseRPCSender$.MODULE$.addInstanceInfo(msg.getData());
            Object object = RPCConsumer$.MODULE$.getRPCConsumer().toObject((Message)op.apply((Object)msg));
            if (object instanceof WarnException) {
                WarnException warnException = (WarnException)object;
                this.logger().warn("RPC requests an alarm!(RPC\u8bf7\u6c42\u51fa\u73b0\u544a\u8b66\uff01)", (Throwable)warnException);
                return BoxedUnit.UNIT;
            }
            if (object instanceof BoxedUnit) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError(object);
        });
    }

    @Override
    public void send(Object message2) {
        RPCReceiveRemote rPCReceiveRemote = this.getRPC();
        this.sendIt(message2, (Function1<Message, Message>)(Function1 & Serializable & scala.Serializable)message -> rPCReceiveRemote.receive((Message)message));
    }

    @Override
    public void deliver(Object message) {
        BaseRPCSender$.MODULE$.org$apache$linkis$rpc$BaseRPCSender$$rpcSenderListenerBus().post(new RPCMessageEvent(message, ServiceInstance$.MODULE$.apply(this.name(), null)));
    }

    public AsynRPCMessageBus getRPCSenderListenerBus() {
        return BaseRPCSender$.MODULE$.org$apache$linkis$rpc$BaseRPCSender$$rpcSenderListenerBus();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Object object = obj;
        if (object instanceof BaseRPCSender) {
            BaseRPCSender baseRPCSender = (BaseRPCSender)object;
            String string = this.name();
            String string2 = baseRPCSender.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    public int hashCode() {
        if (this.name() == null) {
            return 0;
        }
        return this.name().hashCode();
    }

    public String toString() {
        return new StringBuilder(11).append("RPCSender(").append(this.name()).append(")").toString();
    }

    public BaseRPCSender() {
        Logging.$init$((Logging)this);
    }

    public BaseRPCSender(String applicationName) {
        this();
        this.name_$eq(applicationName);
    }
}

