/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncDegreesDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncDegreesLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="UDFDegrees", value="_FUNC_(x) - Converts radians to degrees", extended="Example:\n  > SELECT _FUNC_(30) FROM src LIMIT 1;\n  -1\n")
@VectorizedExpressions(value={FuncDegreesLongToDouble.class, FuncDegreesDoubleToDouble.class})
public class UDFDegrees
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(Math.toDegrees(a.get()));
        return this.result;
    }
}

