/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.LinkisException;
import org.apache.linkis.common.exception.LinkisRuntimeException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.EntranceContext;
import org.apache.linkis.entrance.EntranceServer$;
import org.apache.linkis.entrance.EntranceWebSocketService;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.cs.CSEntranceHelper$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.event.EntranceEvent;
import org.apache.linkis.entrance.event.EntranceEventListener;
import org.apache.linkis.entrance.event.EntranceEventListenerBus;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.exception.SubmitFailedException;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.execute.EntranceJob$;
import org.apache.linkis.entrance.job.EntranceExecutionJob;
import org.apache.linkis.entrance.log.LogReader;
import org.apache.linkis.entrance.log.LogWriter;
import org.apache.linkis.entrance.parser.ParserUtils;
import org.apache.linkis.entrance.timeout.JobTimeoutManager;
import org.apache.linkis.entrance.timeout.JobTimeoutManager$;
import org.apache.linkis.entrance.utils.JobHistoryHelper$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.task.RequestTaskKill;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.entrance.ExecuteOnceLabel;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.scheduler.listener.JobListener;
import org.apache.linkis.scheduler.listener.LogListener;
import org.apache.linkis.scheduler.listener.ProgressListener;
import org.apache.linkis.scheduler.queue.Consumer;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mg!\u0002\u0012$\u0003\u0003a\u0003\"B\u001e\u0001\t\u0003a\u0004bB \u0001\u0001\u0004%I\u0001\u0011\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0011\u0019q\u0005\u0001)Q\u0005\u0003\"9q\n\u0001b\u0001\n\u0013\u0001\u0006BB,\u0001A\u0003%\u0011\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u0015q\u0006A\"\u0001`\u0011\u0015\u0001\u0007A\"\u0001b\u0011\u0015i\u0007A\"\u0001o\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001d\ti\u0001\u0001D\u0001\u0003\u001fAq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002*\u0001!\ta\t!\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003BBA$\u0001\u0011\u0005q\fC\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t9\n\u0001C\u0001\u00033Cq!a(\u0001\t\u0013\t\t\u000bC\u0004\u0002,\u0001!\t!a*\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0006BBAd\u0001\u0011\u0005qlB\u0004\u0002J\u000eB\t!a3\u0007\r\t\u001a\u0003\u0012AAg\u0011\u0019Yd\u0004\"\u0001\u0002P\"I\u0011\u0011\u001b\u0010C\u0002\u0013\u0005\u00111\u001b\u0005\t\u00033t\u0002\u0015!\u0003\u0002V\nqQI\u001c;sC:\u001cWmU3sm\u0016\u0014(B\u0001\u0013&\u0003!)g\u000e\u001e:b]\u000e,'B\u0001\u0014(\u0003\u0019a\u0017N\\6jg*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006kRLGn\u001d\u0006\u0003q\u0015\naaY8n[>t\u0017B\u0001\u001e6\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0012\u00021\u0015tGO]1oG\u0016<VMY*pG.,GoU3sm&\u001cW-F\u0001B!\rq#\tR\u0005\u0003\u0007>\u0012aa\u00149uS>t\u0007C\u0001 F\u0013\t15E\u0001\rF]R\u0014\u0018M\\2f/\u0016\u00147k\\2lKR\u001cVM\u001d<jG\u0016\fA$\u001a8ue\u0006t7-Z,fEN{7m[3u'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002J\u0019B\u0011aFS\u0005\u0003\u0017>\u0012A!\u00168ji\"9QjAA\u0001\u0002\u0004\t\u0015a\u0001=%c\u0005IRM\u001c;sC:\u001cWmV3c'>\u001c7.\u001a;TKJ4\u0018nY3!\u0003EQwN\u0019+j[\u0016|W\u000f^'b]\u0006<WM]\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011AkI\u0001\bi&lWm\\;u\u0013\t16KA\tK_\n$\u0016.\\3pkRl\u0015M\\1hKJ\f!C[8c)&lWm\\;u\u001b\u0006t\u0017mZ3sA\u0005aA/[7f_V$8\t[3dWV\t!\f\u0005\u0002/7&\u0011Al\f\u0002\b\u0005>|G.Z1o\u00035!\u0018.\\3pkR\u001c\u0005.Z2lA\u0005!\u0011N\\5u)\u0005I\u0015aB4fi:\u000bW.Z\u000b\u0002EB\u00111M\u001b\b\u0003I\"\u0004\"!Z\u0018\u000e\u0003\u0019T!aZ\u0016\u0002\rq\u0012xn\u001c;?\u0013\tIw&\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA50\u0003I9W\r^#oiJ\fgnY3D_:$X\r\u001f;\u0016\u0003=\u0004\"A\u00109\n\u0005E\u001c#aD#oiJ\fgnY3D_:$X\r\u001f;\u0002\u000f\u0015DXmY;uKR\u0011A\u000f \t\u0003kjl\u0011A\u001e\u0006\u0003ob\fQ!];fk\u0016T!!_\u0013\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA>w\u0005\rQuN\u0019\u0005\u0006{2\u0001\rA`\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u000b}\fIAY\u0017\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!aA'ba\u0006IAn\\4SK\u0006$WM\u001d\u000b\u0005\u0003#\ti\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9bI\u0001\u0004Y><\u0017\u0002BA\u000e\u0003+\u0011\u0011\u0002T8h%\u0016\fG-\u001a:\t\r\u0005}Q\u00021\u0001c\u0003\u0019)\u00070Z2JI\u00061q-\u001a;K_\n$B!!\n\u0002(A\u0019aF\u0011;\t\r\u0005}a\u00021\u0001c\u0003m9W\r^#oiJ\fgnY3XK\n\u001cvnY6fiN+'O^5dK\u0006\u0001r-\u001a;BY2,f\u000eZ8oKR\u000b7o\u001b\u000b\u0005\u0003_\ty\u0004E\u0003/\u0003c\t)$C\u0002\u00024=\u0012Q!\u0011:sCf\u0004B!a\u000e\u0002<5\u0011\u0011\u0011\b\u0006\u0003e\u000eJA!!\u0010\u0002:\tYQI\u001c;sC:\u001cWMS8c\u0011\u0019\t\t\u0005\u0005a\u0001E\u0006Ya-\u001b7uKJ<vN\u001d3t\u0003Y9W\r^!mY\u000e{gn];nKF+X-^3UCN\\GCAA\u0018\u0003Q\u0019G.Z1s\u00032d7i\u001c8tk6,\u0017+^3vK\u0006\u0011S\u000f\u001d3bi\u0016\fE\u000e\u001c(pi\u0016CXmY;uS>tG+Y:l\u0013:\u001cH/\u00198dKN$2!SA'\u0011\u0019\tye\u0005a\u00015\u0006\u0019\"/\u001a;ss^CWM\\+qI\u0006$XMR1jY\u0006ya-Y5m_Z,'/\u0012=fGV$X\rF\u0002J\u0003+Bq!a\u0016\u0015\u0001\u0004\tI&\u0001\u0006k_\n\u0014V-];fgR\u0004B!a\u0017\u0002l5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0002k_\nTA!a\u0019\u0002f\u00051QM\u001c;jifT1\u0001OA4\u0015\r\tI'J\u0001\u000bO>4XM\u001d8b]\u000e,\u0017\u0002BA7\u0003;\u0012!BS8c%\u0016\fX/Z:u\u0003%Y\u0017\u000e\u001c7PY\u0012,5\tF\u0003J\u0003g\n)\bC\u0004\u0002XU\u0001\r!!\u0017\t\u000f\u0005]T\u00031\u0001\u0002z\u0005YAn\\4BaB,g\u000eZ3s!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u0003\u000b\tA\u0001\\1oO&!\u00111QA?\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006!B-Z1m\u0013:LG/\u001a3K_\n\u0014V-];fgR$b!!\u0017\u0002\n\u00065\u0005bBAF-\u0001\u0007\u0011\u0011L\u0001\u0007U>\u0014'+Z9\t\u000f\u0005]d\u00031\u0001\u0002z\u0005)B-Z1m%Vtg.\u001b8h\u0015>\u0014'+Z9vKN$H#B%\u0002\u0014\u0006U\u0005bBA,/\u0001\u0007\u0011\u0011\f\u0005\b\u0003o:\u0002\u0019AA=\u0003]Ig.\u001b;B]\u0012\u001cVOY7ji*{'MU3rk\u0016\u001cH\u000fF\u0003J\u00037\u000bi\nC\u0004\u0002Xa\u0001\r!!\u0017\t\u000f\u0005]\u0004\u00041\u0001\u0002z\u0005A\u0012N\\5u\u0015>\u0014'+Z9vKN$\bK]8qKJ$\u0018.Z:\u0015\u000b%\u000b\u0019+!*\t\u000f\u0005]\u0013\u00041\u0001\u0002Z!9\u0011qO\rA\u0002\u0005eDCBA\u0018\u0003S\u000bY\u000b\u0003\u0004\u0002Bi\u0001\rA\u0019\u0005\t\u0003[S\u0002\u0013!a\u0001E\u00061Qm\u0019+za\u0016\f!dZ3u\u00032dWK\u001c3p]\u0016$\u0016m]6%I\u00164\u0017-\u001e7uII*\"!a-+\u0007\t\f)l\u000b\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016!C;oG\",7m[3e\u0015\r\t\tmL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003w\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003E\u0019H/\u0019:u)&lWmT;u\u0007\",7m[\u0001\u000f\u000b:$(/\u00198dKN+'O^3s!\tqdd\u0005\u0002\u001f[Q\u0011\u00111Z\u0001\u0018\t>{fj\u0014+`!JKe\nV0Q\u0003J\u000bUjU0M\u001f\u001e+\"!!6\u0011\t\u0005m\u0014q[\u0005\u0004W\u0006u\u0014\u0001\u0007#P?:{Ek\u0018)S\u0013:#v\fU!S\u00036\u001bv\fT(HA\u0001")
public abstract class EntranceServer
implements Logging {
    private Option<EntranceWebSocketService> entranceWebSocketService;
    private final JobTimeoutManager jobTimeoutManager;
    private final boolean timeoutCheck;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String DO_NOT_PRINT_PARAMS_LOG() {
        return EntranceServer$.MODULE$.DO_NOT_PRINT_PARAMS_LOG();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EntranceServer entranceServer = this;
        synchronized (entranceServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Option<EntranceWebSocketService> entranceWebSocketService() {
        return this.entranceWebSocketService;
    }

    private void entranceWebSocketService_$eq(Option<EntranceWebSocketService> x$1) {
        this.entranceWebSocketService = x$1;
    }

    private JobTimeoutManager jobTimeoutManager() {
        return this.jobTimeoutManager;
    }

    private boolean timeoutCheck() {
        return this.timeoutCheck;
    }

    public abstract void init();

    public abstract String getName();

    public abstract EntranceContext getEntranceContext();

    public Job execute(Map<String, Object> params) {
        Object object;
        if (!params.containsKey(EntranceServer$.MODULE$.DO_NOT_PRINT_PARAMS_LOG())) {
            this.logger().debug(new StringBuilder(20).append("received a request: ").append(params).toString());
            object = BoxedUnit.UNIT;
        } else {
            object = params.remove(EntranceServer$.MODULE$.DO_NOT_PRINT_PARAMS_LOG());
        }
        ObjectRef jobRequest = ObjectRef.create((Object)this.getEntranceContext().getOrCreateEntranceParser().parseToTask(params));
        ((JobRequest)jobRequest.elem).setInstances(Sender$.MODULE$.getThisInstance());
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CSEntranceHelper$.MODULE$.resetCreator((JobRequest)jobRequest$1.elem), this.logger());
        this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().persist((JobRequest)jobRequest.elem);
        if (((JobRequest)jobRequest.elem).getId() == null || Predef$.MODULE$.Long2long(((JobRequest)jobRequest.elem).getId()) <= 0L) {
            throw new EntranceErrorException(EntranceErrorCodeSummary.PERSIST_JOBREQUEST_ERROR.getErrorCode(), EntranceErrorCodeSummary.PERSIST_JOBREQUEST_ERROR.getErrorDesc());
        }
        this.logger().info(new StringBuilder(27).append("received a request,convert ").append((JobRequest)jobRequest.elem).toString());
        LoggerUtils.setJobIdMDC((String)((JobRequest)jobRequest.elem).getId().toString());
        StringBuilder logAppender = new StringBuilder();
        jobRequest.elem = this.dealInitedJobRequest((JobRequest)jobRequest.elem, logAppender);
        Job job = this.getEntranceContext().getOrCreateEntranceParser().parseToJob((JobRequest)jobRequest.elem);
        return (Job)Utils$.MODULE$.tryThrow((Function0 & Serializable & scala.Serializable)() -> {
            job.init();
            job.setLogListener((LogListener)this.getEntranceContext().getOrCreateLogManager());
            job.setProgressListener((ProgressListener)this.getEntranceContext().getOrCreatePersistenceManager());
            job.setJobListener((JobListener)this.getEntranceContext().getOrCreatePersistenceManager());
            Job job = job;
            if (job instanceof EntranceJob) {
                EntranceJob entranceJob = (EntranceJob)job;
                entranceJob.setEntranceListenerBus(this.getEntranceContext().getOrCreateEventListenerBus());
            }
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (logAppender.length() > 0) {
                    job.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        x$1.onLogUpdate(job, logAppender.toString().trim());
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }, (Function1 & Serializable & scala.Serializable)t -> {
                EntranceServer.$anonfun$execute$5(this, t);
                return BoxedUnit.UNIT;
            });
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> job.getJobListener().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.onJobInited(job);
                return BoxedUnit.UNIT;
            }), this.logger());
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(53).append("After code preprocessing, the real execution code is:").append(((JobRequest)jobRequest$1.elem).getExecutionCode()).toString());
            }
            if (StringUtils.isBlank((CharSequence)((JobRequest)jobRequest$1.elem).getExecutionCode())) {
                throw new SubmitFailedException(EntranceErrorCodeSummary.SUBMIT_CODE_ISEMPTY.getErrorCode(), EntranceErrorCodeSummary.SUBMIT_CODE_ISEMPTY.getErrorDesc());
            }
            this.getEntranceContext().getOrCreateScheduler().submit((SchedulerEvent)job);
            String msg = LogUtils$.MODULE$.generateInfo(new StringBuilder(42).append("Job with jobId : ").append(((JobRequest)jobRequest$1.elem).getId()).append(" and execID : ").append(job.getId()).append(" submitted ").toString());
            this.logger().info(msg);
            Job job2 = job;
            if (job2 instanceof EntranceJob) {
                EntranceJob entranceJob = (EntranceJob)job2;
                entranceJob.getJobRequest().setReqId(job.getId());
                if (this.timeoutCheck() && JobTimeoutManager$.MODULE$.hasTimeoutLabel(entranceJob)) {
                    this.jobTimeoutManager().add(job.getId(), entranceJob);
                }
                entranceJob.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.onLogUpdate((Job)entranceJob, msg);
                    return BoxedUnit.UNIT;
                });
            }
            LoggerUtils.removeJobIdMDC();
            return job;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            LoggerUtils.removeJobIdMDC();
            job.onFailure("Submitting the query failed!(\u63d0\u4ea4\u67e5\u8be2\u5931\u8d25\uff01)", t);
            JobRequest _jobRequest = this.getEntranceContext().getOrCreateEntranceParser().parseToJobRequest(job);
            this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(_jobRequest);
            Throwable throwable = t;
            if (throwable instanceof LinkisException) {
                LinkisException linkisException = (LinkisException)throwable;
                return linkisException;
            }
            if (throwable instanceof LinkisRuntimeException) {
                LinkisRuntimeException linkisRuntimeException = (LinkisRuntimeException)throwable;
                return linkisRuntimeException;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return new SubmitFailedException(EntranceErrorCodeSummary.SUBMITTING_QUERY_FAILED.getErrorCode(), new StringBuilder(0).append(EntranceErrorCodeSummary.SUBMITTING_QUERY_FAILED.getErrorDesc()).append(ExceptionUtils.getRootCauseMessage((Throwable)throwable2)).toString(), throwable2);
            }
            throw new MatchError((Object)throwable);
        });
    }

    public abstract LogReader logReader(String var1);

    public Option<Job> getJob(String execId) {
        return this.getEntranceContext().getOrCreateScheduler().get(execId).map((Function1 & Serializable & scala.Serializable)x$4 -> (Job)x$4);
    }

    public Option<EntranceWebSocketService> getEntranceWebSocketService() {
        if (Predef$.MODULE$.Boolean2boolean((Boolean)ServerConfiguration$.MODULE$.BDP_SERVER_SOCKET_MODE().getValue())) {
            if (this.entranceWebSocketService().isEmpty()) {
                EntranceServer entranceServer = this;
                synchronized (entranceServer) {
                    if (this.entranceWebSocketService().isEmpty()) {
                        this.entranceWebSocketService_$eq((Option<EntranceWebSocketService>)new Some((Object)new EntranceWebSocketService()));
                        this.entranceWebSocketService().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                            x$5.setEntranceServer(this);
                            return BoxedUnit.UNIT;
                        });
                        EntranceEventListenerBus<EntranceEventListener, EntranceEvent> entranceEventListenerBus = this.getEntranceContext().getOrCreateEventListenerBus();
                        this.entranceWebSocketService().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                            entranceEventListenerBus.addListener(listener);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
            }
            return this.entranceWebSocketService();
        }
        return None$.MODULE$;
    }

    public EntranceJob[] getAllUndoneTask(String filterWords) {
        Set consumers = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager().listConsumers())).toSet();
        Set filterConsumer = StringUtils.isNotBlank((CharSequence)filterWords) ? (Set)consumers.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllUndoneTask$1(filterWords, x$6))) : consumers;
        return (EntranceJob[])((TraversableOnce)((SetLike)((TraversableLike)filterConsumer.flatMap((Function1 & Serializable & scala.Serializable)consumer -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getRunningEvents())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getConsumeQueue().getWaitingEvents())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchedulerEvent.class))))), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllUndoneTask$3(job)))).map((Function1 & Serializable & scala.Serializable)x$7 -> (EntranceJob)((Object)x$7), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(EntranceJob.class));
    }

    public EntranceJob[] getAllConsumeQueueTask() {
        Set consumers = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager().listConsumers())).toSet();
        return (EntranceJob[])((TraversableOnce)((SetLike)((TraversableLike)consumers.flatMap((Function1 & Serializable & scala.Serializable)consumer -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getConsumeQueue().getWaitingEvents())), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllConsumeQueueTask$2(job)))).map((Function1 & Serializable & scala.Serializable)x$8 -> (EntranceJob)((Object)x$8), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(EntranceJob.class));
    }

    public void clearAllConsumeQueue() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager().listConsumers())).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            EntranceServer.$anonfun$clearAllConsumeQueue$1(x$9);
            return BoxedUnit.UNIT;
        });
    }

    public void updateAllNotExecutionTaskInstances(boolean retryWhenUpdateFail) {
        EntranceJob[] consumeQueueTasks = this.getAllConsumeQueueTask();
        this.clearAllConsumeQueue();
        this.logger().info("Finished to clean all ConsumeQueue");
        if (consumeQueueTasks != null && consumeQueueTasks.length > 0) {
            ArrayList<Object> taskIds = new ArrayList<Object>();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumeQueueTasks)).foreach((Function1 & Serializable & scala.Serializable)job -> {
                EntranceServer.$anonfun$updateAllNotExecutionTaskInstances$1(taskIds, job);
                return BoxedUnit.UNIT;
            });
            JobHistoryHelper$.MODULE$.updateAllConsumeQueueTask(taskIds, retryWhenUpdateFail);
            this.logger().info("Finished to update all not execution task instances");
            return;
        }
    }

    public void failoverExecute(JobRequest jobRequest) {
        if (jobRequest == null || jobRequest.getId() == null || Predef$.MODULE$.Long2long(jobRequest.getId()) <= 0L) {
            throw new EntranceErrorException(EntranceErrorCodeSummary.PERSIST_JOBREQUEST_ERROR.getErrorCode(), EntranceErrorCodeSummary.PERSIST_JOBREQUEST_ERROR.getErrorDesc());
        }
        StringBuilder logAppender = new StringBuilder();
        logAppender.append("*************************************FAILOVER************************************** \n");
        this.killOldEC(jobRequest, logAppender);
        Object object = SchedulerEventState$.MODULE$.isInitedByStr(jobRequest.getStatus()) ? this.dealInitedJobRequest(jobRequest, logAppender) : BoxedUnit.UNIT;
        if (BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENTRANCE_FAILOVER_RUNNING_KILL_ENABLED().getValue()) && SchedulerEventState$.MODULE$.isRunningByStr(jobRequest.getStatus())) {
            this.dealRunningJobRequest(jobRequest, logAppender);
            return;
        }
        this.initAndSubmitJobRequest(jobRequest, logAppender);
    }

    public void killOldEC(JobRequest jobRequest, StringBuilder logAppender) {
        Object object = new Object();
        try {
            Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(27).append("job ").append(jobRequest.getId()).append(" start to kill old ec \n").toString()));
                if (!SchedulerEventState$.MODULE$.isRunning(SchedulerEventState$.MODULE$.withName(jobRequest.getStatus())) || !SchedulerEventState$.MODULE$.isScheduled(SchedulerEventState$.MODULE$.withName(jobRequest.getStatus()))) {
                    String msg = new StringBuilder(50).append("job ").append(jobRequest.getId()).append(" status is not running or scheduled, ignore it").toString();
                    this.logger().info(msg);
                    logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                if (jobRequest.getMetrics() == null || !jobRequest.getMetrics().containsKey("engineconnMap")) {
                    String msg = new StringBuilder(32).append("job ").append(jobRequest.getId()).append(" not have EC info, ignore it").toString();
                    this.logger().info(msg);
                    logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                Map engineMap = (Map)jobRequest.getMetrics().get("engineconnMap");
                Map engineInstance = (Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineMap).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> (Map)x$12._2(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.containsKey("engineInstance")))).maxBy((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getOrDefault("engineConnSubmitTime", "0").toString(), (Ordering)Ordering.String$.MODULE$);
                if (engineInstance == null || engineInstance.containsKey("failoverFlag")) {
                    String msg = new StringBuilder(62).append("job ").append(jobRequest.getId()).append(" do not submit to EC or already failover, not need kill ec").toString();
                    this.logger().info(msg);
                    logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                engineInstance.put("failoverFlag", "");
                ServiceInstance ecInstance = ServiceInstance$.MODULE$.apply((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue(), engineInstance.get("engineInstance").toString());
                if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobRequest.getLabels()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$killOldEC$5(x$15)))) {
                    EngineStopRequest engineStopRequest = new EngineStopRequest();
                    engineStopRequest.setServiceInstance(ecInstance);
                    Sender$.MODULE$.getSender((String)RPCConfiguration$.MODULE$.LINKIS_MANAGER_SERVICE_NAME().getValue()).send((Object)engineStopRequest);
                    String msg = new StringBuilder(63).append("job ").append(jobRequest.getId()).append(" send EngineStopRequest to linkismanager, kill EC instance ").append(ecInstance).toString();
                    this.logger().info(msg);
                    return logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
                }
                if (engineInstance.containsKey("engineConnTaskId")) {
                    String engineTaskId = engineInstance.get("engineConnTaskId").toString();
                    Sender$.MODULE$.getSender(ecInstance).send((Object)new RequestTaskKill(engineTaskId));
                    String msg = new StringBuilder(54).append("job ").append(jobRequest.getId()).append(" send RequestTaskKill to kill engineConn ").append(ecInstance).append(", execID ").append(engineTaskId).toString();
                    this.logger().info(msg);
                    return logAppender.append(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
                }
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)t -> {
                EntranceServer.$anonfun$killOldEC$6(this, jobRequest, t);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public JobRequest dealInitedJobRequest(JobRequest jobReq, StringBuilder logAppender) {
        ObjectRef jobRequest = ObjectRef.create((Object)jobReq);
        Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEntranceContext().getOrCreateEntranceInterceptors())).foreach((Function1 & Serializable & scala.Serializable)entranceInterceptor -> {
            jobRequest.elem = entranceInterceptor.apply((JobRequest)jobRequest.elem, logAppender);
            return BoxedUnit.UNIT;
        }), (Function1 & Serializable & scala.Serializable)t -> {
            ErrorException errorException;
            LoggerUtils.removeJobIdMDC();
            Throwable throwable = t;
            if (throwable instanceof ErrorException) {
                ErrorException errorException2;
                errorException = errorException2 = (ErrorException)throwable;
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                EntranceErrorException exception = new EntranceErrorException(EntranceErrorCodeSummary.FAILED_ANALYSIS_TASK.getErrorCode(), MessageFormat.format(EntranceErrorCodeSummary.FAILED_ANALYSIS_TASK.getErrorDesc(), ExceptionUtils.getRootCauseMessage((Throwable)t)));
                exception.initCause(throwable2);
                errorException = exception;
            } else {
                errorException = new EntranceErrorException(EntranceErrorCodeSummary.FAILED_ANALYSIS_TASK.getErrorCode(), MessageFormat.format(EntranceErrorCodeSummary.FAILED_ANALYSIS_TASK.getErrorDesc(), ExceptionUtils.getRootCauseMessage((Throwable)t)));
            }
            ErrorException error = errorException;
            JobRequest jobRequest = (JobRequest)jobRequest$3.elem;
            if (jobRequest != null) {
                JobRequest jobRequest2 = jobRequest;
                jobRequest2.setErrorCode(Predef$.MODULE$.int2Integer(error.getErrCode()));
                jobRequest2.setErrorDesc(error.getDesc());
                jobRequest2.setStatus(SchedulerEventState$.MODULE$.Failed().toString());
                jobRequest2.setProgress(Float.toString(EntranceJob$.MODULE$.JOB_COMPLETED_PROGRESS()));
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("engineInstance", "NULL");
                infoMap.put("ticketId", "");
                infoMap.put("message", "Task interception failed and cannot be retried");
                JobHistoryHelper$.MODULE$.updateJobRequestMetrics((JobRequest)jobRequest$3.elem, null, infoMap);
            }
            this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded((JobRequest)jobRequest$3.elem);
            return error;
        });
        return (JobRequest)jobRequest.elem;
    }

    public void dealRunningJobRequest(JobRequest jobRequest, StringBuilder logAppender) {
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object;
            String msg = MessageFormat.format(EntranceErrorCodeSummary.FAILOVER_RUNNING_TO_CANCELLED.getErrorDesc(), jobRequest.getId().toString());
            jobRequest.setStatus(SchedulerEventState$.MODULE$.Cancelled().toString());
            jobRequest.setProgress("1.0");
            jobRequest.setInstances(Sender$.MODULE$.getThisInstance());
            jobRequest.setErrorCode(Predef$.MODULE$.int2Integer(EntranceErrorCodeSummary.FAILOVER_RUNNING_TO_CANCELLED.getErrorCode()));
            jobRequest.setErrorDesc(msg);
            this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(jobRequest);
            String logPath = jobRequest.getLogPath();
            if (StringUtils.isBlank((CharSequence)logPath)) {
                ParserUtils.generateLogPath(jobRequest, null);
                logPath = jobRequest.getLogPath();
                object = logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(28).append("job ").append(jobRequest.getId()).append(" generate new logPath ").append(logPath).append(" \n").toString()));
            } else {
                object = BoxedUnit.UNIT;
            }
            Job job = this.getEntranceContext().getOrCreateEntranceParser().parseToJob(jobRequest);
            LogWriter logWriter = this.getEntranceContext().getOrCreateLogManager().createLogWriter(job);
            if (logAppender.length() > 0) {
                logWriter.write(logAppender.toString().trim());
            }
            logWriter.write(new StringBuilder(1).append(LogUtils$.MODULE$.generateInfo(msg)).append("\n").toString());
            logWriter.flush();
            logWriter.close();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            EntranceServer.$anonfun$dealRunningJobRequest$2(this, jobRequest, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void initAndSubmitJobRequest(JobRequest jobRequest, StringBuilder logAppender) {
        this.initJobRequestProperties(jobRequest, logAppender);
        this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(jobRequest);
        jobRequest.setUpdateOrderFlag(Predef$.MODULE$.boolean2Boolean(true));
        this.logger().info(new StringBuilder(30).append("job ").append(jobRequest.getId()).append(" update JobRequest success").toString());
        Job job = this.getEntranceContext().getOrCreateEntranceParser().parseToJob(jobRequest);
        Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            job.init();
            job.setLogListener((LogListener)this.getEntranceContext().getOrCreateLogManager());
            job.setProgressListener((ProgressListener)this.getEntranceContext().getOrCreatePersistenceManager());
            job.setJobListener((JobListener)this.getEntranceContext().getOrCreatePersistenceManager());
            Job job = job;
            if (job instanceof EntranceJob) {
                EntranceJob entranceJob = (EntranceJob)job;
                entranceJob.setEntranceListenerBus(this.getEntranceContext().getOrCreateEventListenerBus());
            }
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (logAppender.length() > 0) {
                    job.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                        x$16.onLogUpdate(job, logAppender.toString().trim());
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }, (Function1 & Serializable & scala.Serializable)t -> {
                EntranceServer.$anonfun$initAndSubmitJobRequest$4(this, t);
                return BoxedUnit.UNIT;
            });
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> job.getJobListener().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                x$17.onJobInited(job);
                return BoxedUnit.UNIT;
            }), this.logger());
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(53).append("After code preprocessing, the real execution code is:").append(jobRequest.getExecutionCode()).toString());
            }
            if (StringUtils.isBlank((CharSequence)jobRequest.getExecutionCode())) {
                throw new SubmitFailedException(EntranceErrorCodeSummary.SUBMIT_CODE_ISEMPTY.getErrorCode(), EntranceErrorCodeSummary.SUBMIT_CODE_ISEMPTY.getErrorDesc());
            }
            this.getEntranceContext().getOrCreateScheduler().submit((SchedulerEvent)job);
            String msg = LogUtils$.MODULE$.generateInfo(new StringBuilder(62).append("Job with jobId : ").append(jobRequest.getId()).append(" and execID : ").append(job.getId()).append(" submitted, success to failover").toString());
            this.logger().info(msg);
            Job job2 = job;
            if (job2 instanceof EntranceJob) {
                EntranceJob entranceJob = (EntranceJob)job2;
                entranceJob.getJobRequest().setReqId(job.getId());
                if (this.timeoutCheck() && JobTimeoutManager$.MODULE$.hasTimeoutLabel(entranceJob)) {
                    this.jobTimeoutManager().add(job.getId(), entranceJob);
                }
                entranceJob.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                    x$18.onLogUpdate((Job)entranceJob, msg);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }, (Function1 & Serializable & scala.Serializable)t -> {
            job.onFailure("Submitting the query failed!(\u63d0\u4ea4\u67e5\u8be2\u5931\u8d25\uff01)", t);
            JobRequest _jobRequest = this.getEntranceContext().getOrCreateEntranceParser().parseToJobRequest(job);
            this.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(_jobRequest);
            Throwable throwable = t;
            if (throwable instanceof LinkisException) {
                LinkisException linkisException = (LinkisException)throwable;
                return linkisException;
            }
            if (throwable instanceof LinkisRuntimeException) {
                LinkisRuntimeException linkisRuntimeException = (LinkisRuntimeException)throwable;
                return linkisRuntimeException;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return new SubmitFailedException(EntranceErrorCodeSummary.SUBMITTING_QUERY_FAILED.getErrorCode(), new StringBuilder(0).append(EntranceErrorCodeSummary.SUBMITTING_QUERY_FAILED.getErrorDesc()).append(ExceptionUtils.getRootCauseMessage((Throwable)throwable2)).toString(), throwable2);
            }
            throw new MatchError((Object)throwable);
        });
    }

    private void initJobRequestProperties(JobRequest jobRequest, StringBuilder logAppender) {
        Object object;
        Object object2;
        this.logger().info(new StringBuilder(39).append("job ").append(jobRequest.getId()).append(" start to initialize the properties").toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String initInstance = Sender$.MODULE$.getThisInstance();
        Date initDate = new Date(System.currentTimeMillis());
        String initStatus = SchedulerEventState$.MODULE$.Inited().toString();
        String initProgress = "0.0";
        String initReqId = "";
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(41).append("job ").append(jobRequest.getId()).append(" start to Initialize the properties \n").toString()));
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(20).append("the instances ").append(jobRequest.getInstances()).append(" -> ").append(initInstance).append(" \n").toString()));
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(23).append("the created_time ").append(sdf.format(jobRequest.getCreatedTime())).append(" -> ").append(sdf.format(initDate)).append(" \n").toString()));
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(17).append("the status ").append(jobRequest.getStatus()).append(" -> ").append(initStatus).append(" \n").toString()));
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(19).append("the progress ").append(jobRequest.getProgress()).append(" -> ").append(initProgress).append(" \n").toString()));
        HashMap<String, Map> metricMap = new HashMap<String, Map>();
        if (BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENTRANCE_FAILOVER_RETAIN_METRIC_ENGINE_CONN_ENABLED().getValue())) {
            if (jobRequest.getMetrics() != null && jobRequest.getMetrics().containsKey("engineconnMap")) {
                Map oldEngineconnMap = (Map)jobRequest.getMetrics().get("engineconnMap");
                object2 = metricMap.put("engineconnMap", oldEngineconnMap);
            } else {
                object2 = BoxedUnit.UNIT;
            }
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENTRANCE_FAILOVER_RETAIN_METRIC_YARN_RESOURCE_ENABLED().getValue())) {
            if (jobRequest.getMetrics() != null && jobRequest.getMetrics().containsKey("yarnResource")) {
                Map oldResourceMap = (Map)jobRequest.getMetrics().get("yarnResource");
                object = metricMap.put("yarnResource", oldResourceMap);
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        jobRequest.setInstances(initInstance);
        jobRequest.setCreatedTime(initDate);
        jobRequest.setStatus(initStatus);
        jobRequest.setProgress(initProgress);
        jobRequest.setReqId(initReqId);
        jobRequest.setErrorCode(Predef$.MODULE$.int2Integer(0));
        jobRequest.setErrorDesc("");
        jobRequest.setMetrics(metricMap);
        jobRequest.getMetrics().put("submitTime", initDate);
        jobRequest.setUpdateOrderFlag(Predef$.MODULE$.boolean2Boolean(false));
        logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(43).append("job ").append(jobRequest.getId()).append(" success to initialize the properties \n").toString()));
        this.logger().info(new StringBuilder(41).append("job ").append(jobRequest.getId()).append(" success to initialize the properties").toString());
    }

    public EntranceJob[] getAllUndoneTask(String filterWords, String ecType) {
        Set consumers = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager().listConsumers())).toSet();
        Set filterConsumer = StringUtils.isNotBlank((CharSequence)filterWords) ? (StringUtils.isNotBlank((CharSequence)ecType) ? (Set)consumers.filter((Function1 & Serializable & scala.Serializable)consumer -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllUndoneTask$5(filterWords, ecType, consumer))) : (Set)consumers.filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllUndoneTask$6(filterWords, x$19)))) : consumers;
        return (EntranceJob[])((TraversableOnce)((SetLike)((TraversableLike)filterConsumer.flatMap((Function1 & Serializable & scala.Serializable)consumer -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getRunningEvents())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getConsumeQueue().getWaitingEvents())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchedulerEvent.class))))), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)EntranceServer.$anonfun$getAllUndoneTask$8(job)))).map((Function1 & Serializable & scala.Serializable)x$20 -> (EntranceJob)((Object)x$20), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(EntranceJob.class));
    }

    public String getAllUndoneTask$default$2() {
        return null;
    }

    public void startTimeOutCheck() {
        Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ EntranceServer $outer;

            public void run() {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    TimeType timeoutType = (TimeType)EntranceConfiguration$.MODULE$.ENTRANCE_TASK_TIMEOUT().getHotValue();
                    $this.$outer.logger().info(new StringBuilder(38).append("Start to check timeout Job, timout is ").append(timeoutType).toString());
                    long timeoutTime = System.currentTimeMillis() - timeoutType.toLong();
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.$outer.getAllUndoneTask(null, null))).filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$run$2(timeoutTime, job))))).foreach((Function1 & Serializable & scala.Serializable)job -> {
                        $anon$1.$anonfun$run$3(timeoutType, job);
                        return BoxedUnit.UNIT;
                    });
                    $this.$outer.logger().info(new StringBuilder(41).append("Finished to check timeout Job, timout is ").append(timeoutType).toString());
                }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    $anon$1.$anonfun$run$4(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ boolean $anonfun$run$2(long timeoutTime$1, EntranceJob job) {
                return job.createTime() < timeoutTime$1;
            }

            public static final /* synthetic */ void $anonfun$run$3(TimeType timeoutType$1, EntranceJob job) {
                job.onFailure(new StringBuilder(45).append("Job has run for longer than the maximum time ").append(timeoutType$1).toString(), null);
            }

            public static final /* synthetic */ void $anonfun$run$4($anon$1 $this, Throwable x0$1) {
                Throwable throwable = x0$1;
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    $this.$outer.logger().warn(new StringBuilder(29).append("TimeoutDetective Job failed. ").append(throwable2.getMessage()).toString(), throwable2);
                    return;
                }
                throw new MatchError((Object)throwable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.entrance.EntranceServer$$anon$1 ), $anonfun$run$4$adapted(org.apache.linkis.entrance.EntranceServer$$anon$1 java.lang.Throwable ), $anonfun$run$2$adapted(long org.apache.linkis.entrance.execute.EntranceJob ), $anonfun$run$3$adapted(org.apache.linkis.common.conf.TimeType org.apache.linkis.entrance.execute.EntranceJob )}, serializedLambda);
            }
        }, ((TimeType)EntranceConfiguration$.MODULE$.ENTRANCE_TASK_TIMEOUT_SCAN().getValue()).toLong(), ((TimeType)EntranceConfiguration$.MODULE$.ENTRANCE_TASK_TIMEOUT_SCAN().getValue()).toLong(), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ void $anonfun$execute$5(EntranceServer $this, Throwable t) {
        $this.logger().error("Failed to write init log, reason: ", t);
    }

    public static final /* synthetic */ boolean $anonfun$getAllUndoneTask$1(String filterWords$1, Consumer x$6) {
        return x$6.getGroup().getGroupName().contains(filterWords$1);
    }

    public static final /* synthetic */ boolean $anonfun$getAllUndoneTask$3(SchedulerEvent job) {
        return job != null && job instanceof EntranceJob;
    }

    public static final /* synthetic */ boolean $anonfun$getAllConsumeQueueTask$2(SchedulerEvent job) {
        return job != null && job instanceof EntranceJob;
    }

    public static final /* synthetic */ void $anonfun$clearAllConsumeQueue$1(Consumer x$9) {
        x$9.getConsumeQueue().clearAll();
    }

    public static final /* synthetic */ void $anonfun$updateAllNotExecutionTaskInstances$1(ArrayList taskIds$1, EntranceJob job) {
        taskIds$1.add(job.getJobRequest().getId());
        EntranceJob entranceJob = job;
        if (entranceJob instanceof EntranceExecutionJob) {
            EntranceExecutionJob entranceExecutionJob = (EntranceExecutionJob)entranceJob;
            String msg = LogUtils$.MODULE$.generateWarn(new StringBuilder(47).append("job ").append(job.getJobRequest().getId()).append(" clean from ConsumeQueue, wait for failover").toString());
            entranceExecutionJob.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                x$10.onLogUpdate((Job)entranceExecutionJob, msg);
                return BoxedUnit.UNIT;
            });
            entranceExecutionJob.getLogWriter().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$killOldEC$5(Label x$15) {
        return x$15 instanceof ExecuteOnceLabel;
    }

    public static final /* synthetic */ void $anonfun$killOldEC$6(EntranceServer $this, JobRequest jobRequest$2, Throwable t) {
        $this.logger().error(new StringBuilder(18).append("job ").append(jobRequest$2.getId()).append(" kill ec error").toString(), t);
    }

    public static final /* synthetic */ void $anonfun$dealRunningJobRequest$2(EntranceServer $this, JobRequest jobRequest$4, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(34).append("Job ").append(jobRequest$4.getId()).append(" failover, change status error").toString(), (Throwable)exception);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$initAndSubmitJobRequest$4(EntranceServer $this, Throwable t) {
        $this.logger().error("Failed to write init JobRequest log, reason: ", t);
    }

    public static final /* synthetic */ boolean $anonfun$getAllUndoneTask$5(String filterWords$2, String ecType$1, Consumer consumer) {
        return consumer.getGroup().getGroupName().contains(filterWords$2) && consumer.getGroup().getGroupName().contains(ecType$1);
    }

    public static final /* synthetic */ boolean $anonfun$getAllUndoneTask$6(String filterWords$2, Consumer x$19) {
        return x$19.getGroup().getGroupName().contains(filterWords$2);
    }

    public static final /* synthetic */ boolean $anonfun$getAllUndoneTask$8(SchedulerEvent job) {
        return job != null && job instanceof EntranceJob;
    }

    public EntranceServer() {
        block0: {
            Logging.$init$((Logging)this);
            this.entranceWebSocketService = None$.MODULE$;
            this.jobTimeoutManager = new JobTimeoutManager();
            this.timeoutCheck = BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENABLE_JOB_TIMEOUT_CHECK().getValue());
            if (!this.timeoutCheck()) break block0;
            this.logger().info("Job time check is enabled");
            this.startTimeOutCheck();
        }
    }
}

