/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.parser;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.entrance.EntranceContext;
import org.apache.linkis.entrance.EntranceParser;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceIllegalParamException;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.job.EntranceExecutionJob;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.EmptyCodeParser;
import org.apache.linkis.governance.common.utils.GovernanceConstant;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.utils.TaskUtils;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntranceParser
extends EntranceParser {
    private EntranceContext entranceContext;
    private static final Logger logger = LoggerFactory.getLogger(AbstractEntranceParser.class);

    @Override
    public EntranceContext getEntranceContext() {
        return this.entranceContext;
    }

    @Override
    public void setEntranceContext(EntranceContext entranceContext) {
        this.entranceContext = entranceContext;
    }

    protected EntranceJob createEntranceJob() {
        return new EntranceExecutionJob(this.getPersistenceManager());
    }

    protected PersistenceManager getPersistenceManager() {
        return null;
    }

    @Override
    public JobRequest parseToJobRequest(Job job) throws EntranceIllegalParamException {
        if (job == null) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.JOB_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.JOB_NOT_NULL.getErrorDesc());
        }
        JobRequest jobRequest = ((EntranceJob)job).getJobRequest();
        if (StringUtils.isEmpty((CharSequence)jobRequest.getReqId())) {
            jobRequest.setReqId(job.getId());
        }
        jobRequest.setProgress("" + job.getProgress());
        jobRequest.setStatus(job.getState().toString());
        jobRequest.setUpdatedTime(new Date());
        if (job.isCompleted() && !job.isSucceed() && job.getErrorResponse() != null && StringUtils.isBlank((CharSequence)jobRequest.getErrorDesc()) && StringUtils.isNotEmpty((CharSequence)job.getErrorResponse().message())) {
            jobRequest.setErrorDesc(job.getErrorResponse().message());
        }
        return jobRequest;
    }

    @Override
    public Job parseToJob(JobRequest jobReq) throws EntranceIllegalParamException {
        if (jobReq == null) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.JOBREQ_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.JOBREQ_NOT_NULL.getErrorDesc());
        }
        EntranceJob job = this.createEntranceJob();
        job.setId(String.valueOf(jobReq.getId()));
        job.setJobRequest(jobReq);
        job.setUser(jobReq.getExecuteUser());
        Label userCreateLabel = jobReq.getLabels().stream().filter(l -> l.getLabelKey().equalsIgnoreCase("userCreator")).findFirst().orElse(null);
        if (null == userCreateLabel) {
            String msg = "JobRequest doesn't hava valid userCreator label. labels : " + BDPJettyServerHelper.gson().toJson((Object)jobReq.getLabels());
            logger.error(msg);
            throw new EntranceIllegalParamException(EntranceErrorCode.LABEL_PARAMS_INVALID.getErrCode(), msg);
        }
        job.setCreator(userCreateLabel.getStringValue().split("-")[1]);
        job.setParams(jobReq.getParams());
        Map properties = TaskUtils.getRuntimeMap(job.getParams());
        properties.put(GovernanceConstant.TASK_SOURCE_MAP_KEY(), jobReq.getSource());
        job.setEntranceListenerBus(this.entranceContext.getOrCreateEventListenerBus());
        job.setEntranceContext(this.entranceContext);
        job.setListenerEventBus(null);
        job.setProgress(0.0f);
        job.setCodeParser((CodeParser)new EmptyCodeParser());
        return job;
    }
}

