/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.command.CmdType;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;

public class CmdTemplateFactory {
    private static Map<String, CmdTemplate> templateMap = new ConcurrentHashMap<String, CmdTemplate>();

    public static void register(CmdTemplate template) {
        if (templateMap.containsKey(template.getCmdType().getName())) {
            throw new CommandException("CMD0022", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TemplateGenErr, "template: \"{0}\" already exists", template.getCmdType());
        }
        templateMap.put(template.getCmdType().getName(), template);
    }

    public static boolean isRegistered(CmdType cmdType) {
        return templateMap.containsKey(cmdType.getName());
    }

    public static boolean isRegistered(String cmdType) {
        return templateMap.containsKey(cmdType);
    }

    public static CmdTemplate getTemplateOri(CmdType cmdType) {
        return templateMap.get(cmdType.getName());
    }

    public static CmdTemplate getTemplateCopy(CmdType cmdType) {
        return templateMap.get(cmdType.getName()).getCopy();
    }

    public static CmdTemplate getTemplateOri(String cmdType) {
        return templateMap.get(cmdType);
    }

    public static CmdTemplate getTemplateCopy(String cmdType) {
        return templateMap.get(cmdType).getCopy();
    }
}

