/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.ResyncRunnable;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.cache.Reflector;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private final long fullResyncPeriod;
    private final Store<T> store;
    private final ListerWatcher<T, L> listerWatcher;
    private Reflector<T, L> reflector;
    private final Supplier<Boolean> resyncFunc;
    private final ScheduledExecutorService resyncExecutor;
    private ScheduledFuture resyncFuture;
    private final OperationContext operationContext;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners;
    private final Class<T> apiTypeClass;

    Controller(Class<T> apiTypeClass, Store<T> store, ListerWatcher<T, L> listerWatcher, Supplier<Boolean> resyncFunc, long fullResyncPeriod, OperationContext context, ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners, ScheduledExecutorService resyncExecutor) {
        this.store = store;
        this.listerWatcher = listerWatcher;
        this.apiTypeClass = apiTypeClass;
        this.resyncFunc = resyncFunc;
        if (fullResyncPeriod < 0L) {
            throw new IllegalArgumentException("Invalid resync period provided, It should be a non-negative value");
        }
        this.fullResyncPeriod = fullResyncPeriod;
        this.operationContext = context;
        this.eventListeners = eventListeners;
        this.reflector = new Reflector<T, L>(apiTypeClass, listerWatcher, store, this.operationContext);
        this.resyncExecutor = resyncExecutor;
    }

    public Controller(Class<T> apiTypeClass, Store<T> store, ListerWatcher<T, L> listerWatcher, Supplier<Boolean> resyncFunc, long fullResyncPeriod, OperationContext context, ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners) {
        this(apiTypeClass, store, listerWatcher, resyncFunc, fullResyncPeriod, context, eventListeners, Executors.newSingleThreadScheduledExecutor());
    }

    public void run() {
        log.info("informer#Controller: ready to run resync and reflector runnable");
        this.scheduleResync();
        try {
            log.info("Started Reflector watch for {}", this.apiTypeClass);
            this.reflector.listSyncAndWatch();
        }
        catch (Exception exception) {
            log.warn("Reflector list-watching job exiting because the thread-pool is shutting down", (Throwable)exception);
            this.eventListeners.forEach(listener -> listener.onException(exception));
        }
    }

    void scheduleResync() {
        if (this.fullResyncPeriod > 0L) {
            ResyncRunnable<T> resyncRunnable = new ResyncRunnable<T>(this.store, this.resyncFunc);
            this.resyncFuture = this.resyncExecutor.scheduleWithFixedDelay(resyncRunnable, this.fullResyncPeriod, this.fullResyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            log.info("informer#Controller: resync skipped due to 0 full resync period");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Controller controller = this;
        synchronized (controller) {
            this.reflector.stop();
            if (this.resyncFuture != null) {
                this.resyncFuture.cancel(true);
            }
            this.resyncExecutor.shutdown();
        }
    }

    public boolean hasSynced() {
        return this.store.hasSynced();
    }

    public String lastSyncResourceVersion() {
        return this.reflector.getLastSyncResourceVersion();
    }

    Reflector<T, L> getReflector() {
        return this.reflector;
    }

    ScheduledExecutorService getResyncExecutor() {
        return this.resyncExecutor;
    }

    public boolean isRunning() {
        return this.reflector.isRunning();
    }

    public long getFullResyncPeriod() {
        return this.fullResyncPeriod;
    }
}

