/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.loaders.resource;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.Version;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.engineplugin.loader.EngineConnPluginLoaderConf;
import org.apache.linkis.engineplugin.loader.loaders.EngineConnPluginsResourceLoader;
import org.apache.linkis.engineplugin.loader.loaders.resource.PluginResource;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginLoadResourceException;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmlEngineConnPluginResourceLoader
implements EngineConnPluginsResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(BmlEngineConnPluginResourceLoader.class);
    private static final String LOAD_LOCK_FILE = ".lock-dir";
    private String clientUser;
    private BmlClient bmlClient;
    private String downloadTmpDir;

    public BmlEngineConnPluginResourceLoader() {
        this((String)EngineConnPluginLoaderConf.ENGINE_PLUGIN_LOADER_DEFAULT_USER().getValue(), null);
    }

    public BmlEngineConnPluginResourceLoader(String clientUser, Map<String, Object> clientProps) {
        this.clientUser = clientUser;
        this.bmlClient = BmlClientFactory.createBmlClient((String)clientUser, clientProps);
        this.downloadTmpDir = (String)EngineConnPluginLoaderConf.DOWNLOAD_TEMP_DIR_PREFIX().getValue();
    }

    @Override
    public PluginResource loadEngineConnPluginResource(EngineConnPluginInfo pluginInfo, String savePath) throws EngineConnPluginLoadResourceException {
        String resourceId = this.getResourceIdFromStorage(pluginInfo.typeLabel());
        resourceId = StringUtils.isBlank((CharSequence)resourceId) ? pluginInfo.resourceId() : resourceId;
        EngineTypeLabel typeLabel = pluginInfo.typeLabel();
        if (StringUtils.isNotBlank((CharSequence)resourceId)) {
            String resourceVersion = pluginInfo.resourceVersion();
            String maxVersion = "";
            if (StringUtils.isNotBlank((CharSequence)resourceVersion)) {
                List versions = this.bmlClient.getVersions(this.clientUser, resourceId).resourceVersions().versions();
                maxVersion = versions.stream().map(Version::version).max(Comparator.naturalOrder()).orElse(null);
                if (null == maxVersion) {
                    LOG.trace("Unable to find the versions of resourceId:[{}] for engine conn plugin:[name: {}, version: {}] in BML", new Object[]{resourceId, typeLabel.getEngineType(), typeLabel.getVersion()});
                    return null;
                }
                if (maxVersion.equals(resourceVersion)) {
                    LOG.trace("The version:[{}] of resourceId:[{}] for engine conn plugin:[name: {}, version: {}] must be latest", new Object[]{versions, resourceId, typeLabel.getEngineType(), typeLabel.getVersion()});
                    return null;
                }
                LOG.trace("Start to download resource of engine conn plugin:[name: {}, version: {}]", (Object)typeLabel.getEngineType(), (Object)typeLabel.getVersion());
                this.downloadResource(typeLabel, resourceId, maxVersion, savePath);
                return new PluginResource(resourceId, maxVersion, -1L, null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource(EngineTypeLabel typeLabel, String resourceId, String version, String savePath) throws EngineConnPluginLoadResourceException {
        File savePos = FileUtils.getFile((String[])new String[]{savePath});
        if (!savePos.exists() || savePos.isDirectory()) {
            File parentFile = savePos.getParentFile();
            if (null == parentFile) {
                throw new EngineConnPluginLoadResourceException("Unable to build temp directory for downloading, reason:[The parent directory of savePath doesn't exist], savePath:[" + savePath + "]", null);
            }
            if (!parentFile.exists() || !parentFile.canWrite()) {
                throw new EngineConnPluginLoadResourceException("Have no write permission to directory:[" + parentFile.getAbsolutePath() + "]", null);
            }
            String tmpPath = parentFile.getAbsolutePath();
            if (!tmpPath.endsWith(String.valueOf(IOUtils.DIR_SEPARATOR))) {
                tmpPath = tmpPath + IOUtils.DIR_SEPARATOR;
            }
            tmpPath = tmpPath + this.downloadTmpDir + System.currentTimeMillis() + "-" + Thread.currentThread().getId();
            File tmpFile = FileUtils.getFile((String[])new String[]{tmpPath});
            try {
                BmlDownloadResponse downloadResponse = this.bmlClient.downloadResource(this.clientUser, resourceId, version, "file://" + (FsPath.WINDOWS ? '/' + FilenameUtils.normalize((String)tmpPath, (boolean)true) : FilenameUtils.normalize((String)tmpPath, (boolean)true)), true);
                if (null == downloadResponse || !downloadResponse.isSuccess()) {
                    throw new EngineConnPluginLoadResourceException("Fail to download resources of engine conn plugin:[name: " + typeLabel.getEngineType() + ", version: " + typeLabel.getVersion() + "]", null);
                }
                LOG.info("Success to download resource of plugin:[name: {}, version: {}], start to load temp resource directory", (Object)typeLabel.getEngineType(), (Object)typeLabel.getVersion());
                this.loadTempResourceFile(tmpFile, savePos);
            }
            finally {
                if (tmpFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)tmpFile);
                    }
                    catch (IOException e) {
                        LOG.warn("Delete temp file fail:[" + tmpFile.getAbsolutePath() + "], message:[" + e.getMessage() + "]", (Throwable)e);
                    }
                }
            }
        }
        LOG.error("Unable to download from BML to savePath:[" + savePath + "], is not a directory");
    }

    private void loadTempResourceFile(File tempFile, File saveDir) throws EngineConnPluginLoadResourceException {
        if (saveDir.exists()) {
            LOG.info("Clean out-of-date files in saving directory:[{}]", (Object)saveDir.getAbsolutePath());
            try {
                FileUtils.cleanDirectory((File)saveDir);
            }
            catch (IOException e) {
                throw new EngineConnPluginLoadResourceException("Fail to clean out-of-date save directory:[" + saveDir.getAbsolutePath() + "], please check if the directory has been broken, message:[" + e.getMessage() + "]", (Throwable)e);
            }
        } else {
            saveDir.mkdir();
        }
        LOG.info("Move tempFile:[{}] to saveDir:[{}]", (Object)tempFile.getPath(), (Object)saveDir.getPath());
        try {
            FileUtils.moveDirectory((File)tempFile, (File)saveDir);
        }
        catch (IOException e) {
            throw new EngineConnPluginLoadResourceException("Fail to move tempFile:[" + tempFile.getPath() + "] to saveDir:[" + saveDir.getPath() + "], message:[" + e.getMessage() + "]", (Throwable)e);
        }
    }

    private String getResourceIdFromStorage(EngineTypeLabel typeLabel) {
        return null;
    }
}

