/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.conf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.manager.common.entity.enumeration.MaintainType;

public class AMConfiguration {
    public static final String YARN_QUEUE_NAME_CONFIG_KEY = "wds.linkis.rm.yarnqueue";
    public static final String CROSS_QUEUE = "crossQueue";
    public static final String ACROSS_CLUSTER_TASK = "acrossClusterTask";
    public static final String PRIORITY_CLUSTER = "priorityCluster";
    public static final String PRIORITY_CLUSTER_TARGET = "bdp";
    public static final String PRIORITY_CLUSTER_ORIGIN = "bdap";
    public static final String TARGET_CPU_THRESHOLD = "targetCPUThreshold";
    public static final String TARGET_MEMORY_THRESHOLD = "targetMemoryThreshold";
    public static final String TARGET_CPU_PERCENTAGE_THRESHOLD = "targetCPUPercentageThreshold";
    public static final String TARGET_MEMORY_PERCENTAGE_THRESHOLD = "targetMemoryPercentageThreshold";
    public static final String ORIGIN_CPU_PERCENTAGE_THRESHOLD = "originCPUPercentageThreshold";
    public static final String ORIGIN_MEMORY_PERCENTAGE_THRESHOLD = "originMemoryPercentageThreshold";
    public static final double ACROSS_CLUSTER_TOTAL_MEMORY_PERCENTAGE_THRESHOLD;
    public static final double ACROSS_CLUSTER_TOTAL_CPU_PERCENTAGE_THRESHOLD;
    public static final CommonVars<String> ECM_ADMIN_OPERATIONS;
    public static final CommonVars<TimeType> ENGINE_START_MAX_TIME;
    public static final CommonVars<TimeType> ENGINE_CONN_START_REST_MAX_WAIT_TIME;
    public static final CommonVars<TimeType> ENGINE_REUSE_MAX_TIME;
    public static final Integer ENGINE_REUSE_COUNT_LIMIT;
    public static final CommonVars<String> DEFAULT_NODE_OWNER;
    public static final CommonVars<Long> EM_NEW_WAIT_MILLS;
    public static final CommonVars<String> MULTI_USER_ENGINE_TYPES;
    public static final CommonVars<String> ALLOW_BATCH_KILL_ENGINE_TYPES;
    public static final CommonVars<String> UNALLOW_BATCH_KILL_ENGINE_TYPES;
    public static final CommonVars<String> MULTI_USER_ENGINE_USER;
    public static final CommonVars<Integer> ENGINE_LOCKER_MAX_TIME;
    public static final String AM_CAN_RETRY_LOGS;
    public static final int ASK_ENGINE_ASYNC_MAX_THREAD_SIZE;
    public static final int ASYNC_STOP_ENGINE_MAX_THREAD_SIZE;
    public static final CommonVars<String> EC_MAINTAIN_TIME_STR;
    public static final int EC_MAINTAIN_WORK_START_TIME;
    public static final int EC_MAINTAIN_WORK_END_TIME;
    public static final Boolean NODE_SELECT_HOTSPOT_EXCLUSION_RULE;
    public static final boolean EC_REUSE_WITH_RESOURCE_RULE_ENABLE;
    public static final String EC_REUSE_WITH_RESOURCE_WITH_ECS;
    public static final String SUPPORT_CLUSTER_RULE_EC_TYPES;
    public static final boolean HIVE_CLUSTER_EC_EXECUTE_ONCE_RULE_ENABLE;
    public static final String LONG_LIVED_LABEL;
    public static final String TMP_LIVED_LABEL;
    public static final boolean COMBINED_WITHOUT_YARN_DEFAULT;
    public static final Map<String, Integer> AM_ENGINE_ASK_MAX_NUMBER;
    public static final boolean AM_ECM_RESET_RESOURCE;
    public static final boolean AM_USER_RESET_RESOURCE;

    public static String getDefaultMultiEngineUser() {
        String jvmUser = Utils.getJvmUser();
        return String.format("{jdbc:\"%s\", es: \"%s\", presto:\"%s\", appconn:\"%s\", openlookeng:\"%s\", trino:\"%s\", nebula:\"%s\",doris:\"%s\", hbase:\"%s\", jobserver:\"%s\",io_file:\"root\"}", jvmUser, jvmUser, jvmUser, jvmUser, jvmUser, jvmUser, jvmUser, jvmUser, jvmUser, jvmUser);
    }

    public static boolean isMultiUserEngine(String engineType) {
        String[] multiUserEngine = ((String)MULTI_USER_ENGINE_TYPES.getValue()).split(",");
        Optional<String> findResult = Arrays.stream(multiUserEngine).filter(e -> e.equalsIgnoreCase(engineType)).findFirst();
        return findResult.isPresent();
    }

    public static boolean isAllowKilledEngineType(String engineType) {
        String[] allowBatchKillEngine = ((String)ALLOW_BATCH_KILL_ENGINE_TYPES.getValue()).split(",");
        Optional<String> findResult = Arrays.stream(allowBatchKillEngine).filter(e -> e.equalsIgnoreCase(engineType)).findFirst();
        return findResult.isPresent();
    }

    public static boolean isUnAllowKilledEngineType(String engineType) {
        String[] unAllowBatchKillEngine = ((String)UNALLOW_BATCH_KILL_ENGINE_TYPES.getValue()).split(",");
        Optional<String> findResult = Arrays.stream(unAllowBatchKillEngine).filter(e -> e.equalsIgnoreCase(engineType)).findFirst();
        return findResult.isPresent();
    }

    static {
        String[] keyValuePairs;
        ACROSS_CLUSTER_TOTAL_MEMORY_PERCENTAGE_THRESHOLD = (Double)CommonVars.apply((String)"linkis.yarn.across.cluster.memory.threshold", (Object)0.8).getValue();
        ACROSS_CLUSTER_TOTAL_CPU_PERCENTAGE_THRESHOLD = (Double)CommonVars.apply((String)"linkis.yarn.across.cluster.cpu.threshold", (Object)0.8).getValue();
        ECM_ADMIN_OPERATIONS = CommonVars.apply((String)"wds.linkis.governance.admin.operations", (Object)"");
        ENGINE_START_MAX_TIME = CommonVars.apply((String)"wds.linkis.manager.am.engine.start.max.time", (Object)new TimeType("11m"));
        ENGINE_CONN_START_REST_MAX_WAIT_TIME = CommonVars.apply((String)"wds.linkis.manager.am.engine.rest.start.max.time", (Object)new TimeType("40s"));
        ENGINE_REUSE_MAX_TIME = CommonVars.apply((String)"wds.linkis.manager.am.engine.reuse.max.time", (Object)new TimeType("5m"));
        ENGINE_REUSE_COUNT_LIMIT = (Integer)CommonVars.apply((String)"wds.linkis.manager.am.engine.reuse.count.limit", (Object)2).getValue();
        DEFAULT_NODE_OWNER = CommonVars.apply((String)"wds.linkis.manager.am.default.node.owner", (Object)"hadoop");
        EM_NEW_WAIT_MILLS = CommonVars.apply((String)"wds.linkis.manager.am.em.new.wait.mills", (Object)60000L);
        MULTI_USER_ENGINE_TYPES = CommonVars.apply((String)"wds.linkis.multi.user.engine.types", (Object)"jdbc,es,presto,io_file,appconn,openlookeng,trino,jobserver,nebula,hbase,doris");
        ALLOW_BATCH_KILL_ENGINE_TYPES = CommonVars.apply((String)"wds.linkis.allow.batch.kill.engine.types", (Object)"spark,hive,python");
        UNALLOW_BATCH_KILL_ENGINE_TYPES = CommonVars.apply((String)"wds.linkis.allow.batch.kill.engine.types", (Object)"trino,appconn,io_file");
        MULTI_USER_ENGINE_USER = CommonVars.apply((String)"wds.linkis.multi.user.engine.user", (Object)AMConfiguration.getDefaultMultiEngineUser());
        ENGINE_LOCKER_MAX_TIME = CommonVars.apply((String)"wds.linkis.manager.am.engine.locker.max.time", (Object)300000);
        AM_CAN_RETRY_LOGS = (String)CommonVars.apply((String)"wds.linkis.manager.am.can.retry.logs", (Object)"already in use;Cannot allocate memory").getValue();
        ASK_ENGINE_ASYNC_MAX_THREAD_SIZE = (Integer)CommonVars.apply((String)"wds.linkis.ecm.launch.max.thread.size", (Object)200).getValue();
        ASYNC_STOP_ENGINE_MAX_THREAD_SIZE = (Integer)CommonVars.apply((String)"wds.linkis.async.stop.engine.size", (Object)20).getValue();
        EC_MAINTAIN_TIME_STR = CommonVars.apply((String)"wds.linkis.ec.maintain.time.key", (Object)MaintainType.Default.toString());
        EC_MAINTAIN_WORK_START_TIME = (Integer)CommonVars.apply((String)"wds.linkis.ec.maintain.time.work.start.time", (Object)8).getValue();
        EC_MAINTAIN_WORK_END_TIME = (Integer)CommonVars.apply((String)"wds.linkis.ec.maintain.time.work.end.time", (Object)19).getValue();
        NODE_SELECT_HOTSPOT_EXCLUSION_RULE = (Boolean)CommonVars.apply((String)"linkis.node.select.hotspot.exclusion.rule.enable", (Object)true).getValue();
        EC_REUSE_WITH_RESOURCE_RULE_ENABLE = (Boolean)CommonVars.apply((String)"linkis.ec.reuse.with.resource.rule.enable", (Object)false).getValue();
        EC_REUSE_WITH_RESOURCE_WITH_ECS = (String)CommonVars.apply((String)"linkis.ec.reuse.with.resource.with.ecs", (Object)"spark,hive,shell,python").getValue();
        SUPPORT_CLUSTER_RULE_EC_TYPES = (String)CommonVars.apply((String)"linkis.support.cluster.rule.ec.types", (Object)"").getValue();
        HIVE_CLUSTER_EC_EXECUTE_ONCE_RULE_ENABLE = (Boolean)CommonVars.apply((String)"linkis.hive.cluster.ec.execute.once.rule.enable", (Object)true).getValue();
        LONG_LIVED_LABEL = (String)CommonVars.apply((String)"linkis.label.node.long.lived.label.keys", (Object)"tenant|yarnCluster").getValue();
        TMP_LIVED_LABEL = (String)CommonVars.apply((String)"linkis.label.node.tmp.lived.label.keys", (Object)"taskId").getValue();
        COMBINED_WITHOUT_YARN_DEFAULT = (Boolean)CommonVars.apply((String)"linkis.combined.without.yarn.default", (Object)true).getValue();
        AM_ENGINE_ASK_MAX_NUMBER = new HashMap<String, Integer>();
        String keyValue = (String)CommonVars.apply((String)"linkis.am.engine.ask.max.number", (Object)"appconn=5,trino=10").getValue();
        for (String pair : keyValuePairs = keyValue.split(",")) {
            String[] array = pair.split("=");
            if (array.length != 2) {
                throw new IllegalArgumentException("linkis.am.engine.ask.max.number value is illegal, value is " + pair);
            }
            AM_ENGINE_ASK_MAX_NUMBER.put(array[0], Integer.parseInt(array[1]));
        }
        AM_ECM_RESET_RESOURCE = (Boolean)CommonVars.apply((String)"linkis.am.ecm.reset.resource.enable", (Object)true).getValue();
        AM_USER_RESET_RESOURCE = (Boolean)CommonVars.apply((String)"linkis.am.user.reset.resource.enable", (Object)true).getValue();
    }
}

