/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayHttpRequest;
import org.apache.linkis.gateway.security.ProxyUserUtils$;
import org.apache.linkis.server.exception.LoginExpireException;
import org.apache.linkis.server.security.SSOUtils$;
import org.apache.linkis.server.security.SecurityFilter$;
import org.apache.linkis.server.security.ServerSSOUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class GatewaySSOUtils$
implements Logging {
    public static GatewaySSOUtils$ MODULE$;
    private final Regex DOMAIN_REGEX;
    private final Regex IP_REGEX;
    private final boolean cookieDomainSetupSwitch;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GatewaySSOUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        GatewaySSOUtils$ gatewaySSOUtils$ = this;
        synchronized (gatewaySSOUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Cookie[] getCookies(GatewayContext gatewayContext) {
        return (Cookie[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(gatewayContext.getRequest().getCookies()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1._2())), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Cookie.class));
    }

    private Regex DOMAIN_REGEX() {
        return this.DOMAIN_REGEX;
    }

    private Regex IP_REGEX() {
        return this.IP_REGEX;
    }

    private boolean cookieDomainSetupSwitch() {
        return this.cookieDomainSetupSwitch;
    }

    public String getCookieDomain(String host, int level) {
        String string = host;
        Option option = this.DOMAIN_REGEX().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            int index;
            String[] domains = host.split("\\.");
            int n = domains.length > level ? level : (index = domains.length == level ? level - 1 : domains.length);
            if (index < 0) {
                return host;
            }
            String[] parsedDomains = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])domains)).takeRight(index);
            if (parsedDomains == null || parsedDomains.length < level) {
                return host;
            }
            String domain = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parsedDomains)).mkString(".");
            if (domains.length >= level) {
                return new StringBuilder(1).append(".").append(domain).toString();
            }
            return domain;
        }
        Option option2 = this.IP_REGEX().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
            String ip = (String)((LinearSeqOptimized)option2.get()).apply(0);
            return ip;
        }
        return host;
    }

    public Option<String> getLoginUser(GatewayContext gatewayContext) {
        Cookie[] cookies = this.getCookies(gatewayContext);
        return (Option)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> SSOUtils$.MODULE$.getLoginUser((Function0 & Serializable & scala.Serializable)() -> cookies), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof LoginExpireException && Option$.MODULE$.apply((Object)cookies).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GatewaySSOUtils$.$anonfun$getLoginUser$4(x$2)))) {
                return ServerSSOUtils$.MODULE$.getLoginUserIgnoreTimeout((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.apply((Object)cookies).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3)).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GatewaySSOUtils$.$anonfun$getLoginUser$8(key, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getValue()))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GatewaySSOUtils$.$anonfun$getLoginUser$10(x$6)));
            }
            throw throwable;
        });
    }

    public String getLoginUsername(GatewayContext gatewayContext) {
        return SSOUtils$.MODULE$.getLoginUsername((Function0 & Serializable & scala.Serializable)() -> MODULE$.getCookies(gatewayContext));
    }

    public void setLoginUser(GatewayContext gatewayContext, String username) {
        String proxyUser = ProxyUserUtils$.MODULE$.getProxyUser(username);
        SSOUtils$.MODULE$.setLoginUser((Function1 & Serializable & scala.Serializable)c -> {
            GatewaySSOUtils$.$anonfun$setLoginUser$1(gatewayContext, c);
            return BoxedUnit.UNIT;
        }, proxyUser, SSOUtils$.MODULE$.setLoginUser$default$3());
    }

    public void setLoginUser(GatewayHttpRequest request, String username, boolean updateSession) {
        String proxyUser = ProxyUserUtils$.MODULE$.getProxyUser(username);
        SSOUtils$.MODULE$.setLoginUser((Function1 & Serializable & scala.Serializable)c -> {
            request.addCookie(c.getName(), (Cookie[])((Object[])new Cookie[]{c}));
            return BoxedUnit.UNIT;
        }, proxyUser, updateSession);
    }

    public boolean setLoginUser$default$3() {
        return true;
    }

    public void removeLoginUser(GatewayContext gatewayContext) {
        SSOUtils$.MODULE$.removeLoginUser((Function0 & Serializable & scala.Serializable)() -> (Cookie[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(gatewayContext.getRequest().getCookies()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7._2())), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Cookie.class)));
        SSOUtils$.MODULE$.removeLoginUserByAddCookie((Function1 & Serializable & scala.Serializable)c -> {
            GatewaySSOUtils$.$anonfun$removeLoginUser$3(gatewayContext, c);
            return BoxedUnit.UNIT;
        });
    }

    public void updateLastAccessTime(GatewayContext gatewayContext) {
        SSOUtils$.MODULE$.updateLastAccessTime((Function0 & Serializable & scala.Serializable)() -> (Cookie[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(gatewayContext.getRequest().getCookies()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8._2())), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Cookie.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getLoginUser$5(Cookie c) {
        String string = c.getName();
        String string2 = SecurityFilter$.MODULE$.ALLOW_ACCESS_WITHOUT_TIMEOUT();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = c.getValue();
        String string4 = "true";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$4(Cookie[] x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)GatewaySSOUtils$.$anonfun$getLoginUser$5(c)));
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$8(String key$1, Cookie x$4) {
        String string = x$4.getName();
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$10(String x$6) {
        String string = x$6;
        String string2 = SecurityFilter$.MODULE$.OTHER_SYSTEM_IGNORE_UM_USER();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$setLoginUser$1(GatewayContext gatewayContext$2, Cookie c) {
        String[] host;
        if (MODULE$.cookieDomainSetupSwitch() && (host = gatewayContext$2.getRequest().getHeaders().get("Host")) != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).nonEmpty()) {
            c.setDomain(MODULE$.getCookieDomain((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).head(), BoxesRunTime.unboxToInt((Object)GatewayConfiguration$.MODULE$.GATEWAY_DOMAIN_LEVEL().getValue())));
        }
        gatewayContext$2.getResponse().addCookie(c);
    }

    public static final /* synthetic */ void $anonfun$removeLoginUser$3(GatewayContext gatewayContext$3, Cookie c) {
        String[] host;
        if (MODULE$.cookieDomainSetupSwitch() && (host = gatewayContext$3.getRequest().getHeaders().get("Host")) != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).nonEmpty()) {
            c.setDomain(MODULE$.getCookieDomain((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])host)).head(), BoxesRunTime.unboxToInt((Object)GatewayConfiguration$.MODULE$.GATEWAY_DOMAIN_LEVEL().getValue())));
        }
        gatewayContext$3.getResponse().addCookie(c);
    }

    private GatewaySSOUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.DOMAIN_REGEX = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z][a-zA-Z0-9\\.]+")).r();
        this.IP_REGEX = new StringOps(Predef$.MODULE$.augmentString("([^:]+):.+")).r();
        this.cookieDomainSetupSwitch = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.GATEWAY_COOKIE_DOMAIN_SETUP_SWITCH().getValue());
    }
}

