/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service.conf;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.linkis.common.conf.CommonVars;

public class ConfigurationUtils {
    private static final CommonVars<String> CONFIG_VIEWFS_LINK_FALLBACK = CommonVars.apply((String)"wds.linkis.server.mdm.hadoop.conf.link.fallback", (Object)"linkFallback");
    private static final CommonVars<String> CONFIG_VIEWFS_LINK_NFLY = CommonVars.apply((String)"wds.linkis.server.mdm.hadoop.conf.link.nfly", (Object)"linkNfly");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("<[^>]*?>");
    private static final Function<String, Boolean> FILTER_ALL_CONFIG = config -> false;

    public static Map<String, String> filterConfiguration(FileSystem fileSystem, List<String> filterRules, URI uri) {
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Configuration hadoopConf = fileSystem.getConf();
        ArrayList<String> rules = Objects.isNull(filterRules) ? new ArrayList<String>() : new ArrayList<String>(filterRules);
        Function<String, Boolean> acceptableFunction = FILTER_ALL_CONFIG;
        if (fileSystem instanceof ViewFileSystem) {
            acceptableFunction = ConfigurationUtils.addViewFileSystemFilterRules(fileSystem, rules, uri);
        }
        Pattern pattern = ConfigurationUtils.rulesToPattern(rules);
        Function<String, Boolean> finalAcceptableFunction = acceptableFunction;
        hadoopConf.forEach(entry -> {
            String key = (String)entry.getKey();
            if (pattern.matcher(key).matches() || ((Boolean)finalAcceptableFunction.apply(key)).booleanValue()) {
                filteredProps.put(key, (String)entry.getValue());
            }
        });
        return filteredProps;
    }

    private static Pattern rulesToPattern(List<String> filterRules) {
        StringBuffer sb = new StringBuffer("^(");
        for (int i = 0; i < filterRules.size(); ++i) {
            String rule = filterRules.get(i);
            if (!StringUtils.isNotBlank((CharSequence)rule)) continue;
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(rule);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "[\\\\s\\\\S]*?");
            }
            matcher.appendTail(sb);
            if (i >= filterRules.size() - 1) continue;
            sb.append("|");
        }
        sb.append(")$");
        return Pattern.compile(sb.toString().replace(".", "[.]"));
    }

    private static Function<String, Boolean> addViewFileSystemFilterRules(FileSystem fileSystem, List<String> filerRules, URI uri) {
        String mountTableName = Optional.ofNullable(uri).orElse(FileSystem.getDefaultUri((Configuration)fileSystem.getConf())).getAuthority();
        if (StringUtils.isBlank((CharSequence)mountTableName)) {
            mountTableName = "default";
        }
        if (Objects.nonNull(uri) && fileSystem.getScheme().equals(uri.getScheme())) {
            String linkPrefix = "fs.viewfs.mounttable." + mountTableName + ".";
            String linkBasicPrefix = linkPrefix + "link";
            String linkMergePrefix = linkPrefix + "linkMerge";
            filerRules.add(linkPrefix + "linkMergeSlash");
            filerRules.add(linkPrefix + (String)CONFIG_VIEWFS_LINK_FALLBACK.getValue());
            filerRules.add(linkPrefix + (String)CONFIG_VIEWFS_LINK_NFLY.getValue());
            filerRules.add(linkPrefix + "homedir");
            String path = uri.getPath();
            return config -> config.startsWith(linkBasicPrefix) && path.startsWith(config.substring(linkBasicPrefix.length() + 1)) || config.startsWith(linkMergePrefix) && path.startsWith(config.substring(linkMergePrefix.length() + 1));
        }
        filerRules.add("fs.viewfs.mounttable." + mountTableName + ".<suffix>");
        return FILTER_ALL_CONFIG;
    }
}

