/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.restart;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.restart.PauseHandler;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.util.ClassUtils;

@Endpoint(id="restart", enableByDefault=false)
public class RestartEndpoint
implements ApplicationListener<ApplicationPreparedEvent> {
    private static Log logger = LogFactory.getLog(RestartEndpoint.class);
    private ConfigurableApplicationContext context;
    private SpringApplication application;
    private String[] args;
    private ApplicationPreparedEvent event;
    private IntegrationShutdown integrationShutdown;
    private List<PauseHandler> pauseHandlers = Collections.emptyList();
    private long timeout;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setIntegrationMBeanExporter(Object exporter) {
        if (exporter != null) {
            this.integrationShutdown = new IntegrationShutdown(exporter);
        }
    }

    public void onApplicationEvent(ApplicationPreparedEvent input) {
        this.event = input;
        if (this.context == null) {
            this.context = this.event.getApplicationContext();
            this.args = this.event.getArgs();
            this.application = this.event.getSpringApplication();
            this.application.addInitializers(new ApplicationContextInitializer[]{new PostProcessorInitializer()});
            this.pauseHandlers = this.context.getBeanProvider(PauseHandler.class).orderedStream().collect(Collectors.toList());
        }
    }

    @WriteOperation
    public Object restart() {
        Thread thread = new Thread(this::safeRestart);
        thread.setDaemon(false);
        thread.start();
        return Collections.singletonMap("message", "Restarting");
    }

    private Boolean safeRestart() {
        try {
            this.doRestart();
            logger.info((Object)"Restarted");
            return true;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)"Could not doRestart", (Throwable)e);
            } else {
                logger.info((Object)("Could not doRestart: " + e.getMessage()));
            }
            return false;
        }
    }

    public PauseEndpoint getPauseEndpoint() {
        return new PauseEndpoint();
    }

    public ResumeEndpoint getResumeEndpoint() {
        return new ResumeEndpoint();
    }

    public synchronized ConfigurableApplicationContext doRestart() {
        if (this.context != null) {
            if (this.integrationShutdown != null) {
                this.integrationShutdown.stop(this.timeout);
            }
            this.application.setEnvironment(this.context.getEnvironment());
            this.close();
            this.overrideClassLoaderForRestart();
            this.context = this.application.run(this.args);
        }
        return this.context;
    }

    private void close() {
        ConfigurableApplicationContext context = this.context;
        while (context instanceof Closeable) {
            try {
                ((Closeable)context).close();
            }
            catch (IOException e) {
                logger.error((Object)("Cannot close context: " + context.getId()), (Throwable)e);
            }
            context = context.getParent();
        }
    }

    public boolean isRunning() {
        if (this.context != null) {
            return this.context.isRunning();
        }
        return false;
    }

    public synchronized void doPause() {
        for (PauseHandler handler : this.pauseHandlers) {
            handler.pause();
        }
    }

    public synchronized void doResume() {
        int i = this.pauseHandlers.size();
        while (i-- > 0) {
            PauseHandler handler = this.pauseHandlers.get(i);
            handler.resume();
        }
    }

    private void overrideClassLoaderForRestart() {
        ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.application.getClass().getClassLoader());
    }

    private class IntegrationShutdown {
        private IntegrationMBeanExporter exporter;

        IntegrationShutdown(Object exporter) {
            this.exporter = (IntegrationMBeanExporter)exporter;
        }

        public void stop(long timeout) {
            this.exporter.stopActiveComponents(timeout);
        }
    }

    class PostProcessorInitializer
    implements ApplicationContextInitializer<GenericApplicationContext> {
        PostProcessorInitializer() {
        }

        public void initialize(GenericApplicationContext context) {
            context.registerBean(PostProcessor.class, () -> new PostProcessor(), new BeanDefinitionCustomizer[0]);
        }
    }

    @Endpoint(id="pause")
    public class PauseEndpoint {
        @WriteOperation
        public Boolean pause() {
            if (RestartEndpoint.this.isRunning()) {
                RestartEndpoint.this.doPause();
                return true;
            }
            return false;
        }
    }

    @Endpoint(id="resume")
    @ConfigurationProperties(value="management.endpoint.resume")
    public class ResumeEndpoint {
        @WriteOperation
        public Boolean resume() {
            if (!RestartEndpoint.this.isRunning()) {
                RestartEndpoint.this.doResume();
                return true;
            }
            return false;
        }
    }

    class PostProcessor
    implements BeanPostProcessor {
        PostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RestartEndpoint) {
                return RestartEndpoint.this;
            }
            return bean;
        }
    }
}

