/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.info;

import org.springframework.boot.actuate.autoconfigure.OnEndpointElementCondition;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorFallback;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;

class OnEnabledInfoContributorCondition
extends OnEndpointElementCondition {
    OnEnabledInfoContributorCondition() {
        super("management.info.", ConditionalOnEnabledInfoContributor.class);
    }

    @Override
    protected ConditionOutcome getDefaultOutcome(ConditionContext context, AnnotationAttributes annotationAttributes) {
        InfoContributorFallback fallback = (InfoContributorFallback)annotationAttributes.getEnum("fallback");
        if (fallback == InfoContributorFallback.DISABLE) {
            return new ConditionOutcome(false, ConditionMessage.forCondition(ConditionalOnEnabledInfoContributor.class, (Object[])new Object[0]).because("management.info." + annotationAttributes.getString("value") + ".enabled is not true"));
        }
        return super.getDefaultOutcome(context, annotationAttributes);
    }
}

