/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.instance.label.exception.InstanceErrorException;
import org.apache.linkis.instance.label.service.InsLabelAccessService;
import org.apache.linkis.instance.label.service.InsLabelServiceAdapter;
import org.apache.linkis.instance.label.service.impl.DefaultInsLabelService;
import org.apache.linkis.manager.label.entity.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInsLabelServiceAdapter
implements InsLabelServiceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInsLabelServiceAdapter.class);
    private List<AccessServiceContext> serviceContexts = new ArrayList<AccessServiceContext>();

    @PostConstruct
    public void init() {
        this.serviceContexts.sort((left, right) -> {
            int compare = ((AccessServiceContext)left).order - ((AccessServiceContext)right).order;
            if (compare == 0) {
                if (DefaultInsLabelService.class.isAssignableFrom(((AccessServiceContext)left).accessService.getClass())) {
                    return -1;
                }
                if (DefaultInsLabelService.class.isAssignableFrom(((AccessServiceContext)right).accessService.getClass())) {
                    return 1;
                }
            }
            return compare;
        });
    }

    @Override
    public void registerServices(InsLabelAccessService instanceService) {
        this.registerServices(instanceService, -1);
    }

    @Override
    public void registerServices(InsLabelAccessService insLabelAccessService, int order) {
        this.serviceContexts.add(new AccessServiceContext(insLabelAccessService, order));
    }

    @Override
    public void attachLabelToInstance(Label<?> label, ServiceInstance serviceInstance) {
        this.execOnServiceChain("attachLabelToInstance", insLabelAccessService -> {
            try {
                insLabelAccessService.attachLabelToInstance(label, serviceInstance);
            }
            catch (InstanceErrorException e) {
                LOG.error("Failed to attachLabelToInstance", (Throwable)((Object)e));
            }
            return true;
        }, true, true);
    }

    @Override
    public void attachLabelsToInstance(List<? extends Label<?>> labels, ServiceInstance serviceInstance) {
        this.execOnServiceChain("attachLabelsToInstance", insLabelAccessService -> {
            try {
                insLabelAccessService.attachLabelsToInstance(labels, serviceInstance);
            }
            catch (InstanceErrorException e) {
                LOG.error("Failed to attachLabelToInstance", (Throwable)((Object)e));
            }
            return true;
        }, true, true);
    }

    @Override
    public void refreshLabelsToInstance(List<? extends Label<?>> labels, ServiceInstance serviceInstance) {
        this.execOnServiceChain("refreshLabelsToInstance", insLabelAccessService -> {
            try {
                insLabelAccessService.refreshLabelsToInstance(labels, serviceInstance);
            }
            catch (InstanceErrorException e) {
                LOG.error("Failed to attachLabelToInstance", (Throwable)((Object)e));
            }
            return true;
        }, true, true);
    }

    @Override
    public void removeLabelsFromInstance(ServiceInstance serviceInstance) {
        this.execOnServiceChain("removeLabelsFromInstance", insLabelAccessService -> {
            insLabelAccessService.removeLabelsFromInstance(serviceInstance);
            return true;
        }, true, true);
    }

    @Override
    public List<ServiceInstance> searchInstancesByLabels(List<? extends Label<?>> labels) {
        return this.execOnServiceChain("searchInstancesByLabels", insLabelAccessService -> insLabelAccessService.searchInstancesByLabels(labels, Label.ValueRelation.ALL), false, false);
    }

    @Override
    public List<ServiceInstance> searchUnRelateInstances(ServiceInstance serviceInstance) {
        return this.execOnServiceChain("searchUnRelateInstances", insLabelAccessService -> insLabelAccessService.searchUnRelateInstances(serviceInstance), false, false);
    }

    @Override
    public List<ServiceInstance> searchLabelRelatedInstances(ServiceInstance serviceInstance) {
        return this.execOnServiceChain("searchLabelRelatedInstances", insLabelAccessService -> insLabelAccessService.searchLabelRelatedInstances(serviceInstance), false, false);
    }

    @Override
    public void removeInstance(ServiceInstance serviceInstance) {
        this.execOnServiceChain("removeInstance", insLabelAccessService -> {
            insLabelAccessService.removeInstance(serviceInstance);
            return true;
        }, true, true);
    }

    @Override
    public List<ServiceInstance> getInstancesByNames(String appName) {
        return this.execOnServiceChain("getInstancesByNames", insLabelAccessService -> insLabelAccessService.getInstancesByNames(appName), false, false);
    }

    @Override
    public void evictCache() {
    }

    private <R> R execOnServiceChain(String funcName, Function<InsLabelAccessService, R> execFunc, boolean isFilter, boolean allSuccess) {
        R returnStored = null;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (int i = 0; i < this.serviceContexts.size(); ++i) {
            AccessServiceContext context = this.serviceContexts.get(i);
            try {
                R callResult = context.exec(execFunc);
                if (null == returnStored) {
                    returnStored = callResult;
                }
                if (isFilter) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error("Execute [" + funcName + "] on service: [ " + context.accessService.getClass().getSimpleName() + "] failed, message: [" + e.getMessage() + "]", e);
                errors.add(e);
                if (!allSuccess && i <= this.serviceContexts.size() - 1 && errors.size() != this.serviceContexts.size()) continue;
            }
        }
        return returnStored;
    }

    private static class AccessServiceContext {
        private InsLabelAccessService accessService;
        private int order;

        AccessServiceContext(InsLabelAccessService accessService, int order) {
            this.accessService = accessService;
            this.order = order;
        }

        public <R> R exec(Function<InsLabelAccessService, R> execFunc) {
            return execFunc.apply(this.accessService);
        }
    }
}

