/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache.cskey.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.contextcache.cache.cskey.ContextValueMapSet;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndexSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextValueMapSetImpl
implements ContextValueMapSet {
    private static final Logger logger = LoggerFactory.getLogger(ContextInvertedIndexSetImpl.class);
    Map<String, Map<String, ContextKeyValue>> contextValueMapSet = new ConcurrentHashMap<String, Map<String, ContextKeyValue>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ContextKeyValue> getContextValueMap(ContextType contextType) {
        String csType;
        if (contextType == null) {
            contextType = ContextType.METADATA;
        }
        if (!this.contextValueMapSet.containsKey(csType = contextType.name())) {
            String string = csType.intern();
            synchronized (string) {
                if (!this.contextValueMapSet.containsKey(csType)) {
                    logger.info("For ContextType({}) init ContextValueMap", (Object)csType);
                    this.contextValueMapSet.put(csType, new HashMap(16));
                }
            }
        }
        return this.contextValueMapSet.get(csType);
    }

    @Override
    public ContextKeyValue put(ContextKeyValue contextKeyValue) {
        if (contextKeyValue.getContextKey() != null && contextKeyValue.getContextValue() != null && StringUtils.isNotBlank((CharSequence)contextKeyValue.getContextKey().getKey())) {
            return this.getContextValueMap(contextKeyValue.getContextKey().getContextType()).put(contextKeyValue.getContextKey().getKey(), contextKeyValue);
        }
        return null;
    }

    @Override
    public ContextKeyValue getByContextKey(ContextKey contextKey, ContextType contextType) {
        if (contextKey != null && StringUtils.isNotBlank((CharSequence)contextKey.getKey())) {
            return this.getContextValueMap(contextType).get(contextKey.getKey());
        }
        return null;
    }

    @Override
    public ContextKeyValue getByContextKey(String contextKey, ContextType contextType) {
        if (StringUtils.isNotBlank((CharSequence)contextKey)) {
            return this.getContextValueMap(contextType).get(contextKey);
        }
        return null;
    }

    @Override
    public List<ContextKeyValue> getByContextKeys(List<String> contextKeys, ContextType contextType) {
        if (CollectionUtils.isEmpty(contextKeys)) {
            return null;
        }
        ArrayList<ContextKeyValue> contextKeyValueList = new ArrayList<ContextKeyValue>();
        for (String contextKey : contextKeys) {
            ContextKeyValue contextKeyValue = this.getByContextKey(contextKey, contextType);
            if (null == contextKeyValue) continue;
            contextKeyValueList.add(contextKeyValue);
        }
        return contextKeyValueList;
    }

    @Override
    public List<ContextKeyValue> getAllValuesByType(ContextType contextType) {
        Collection<ContextKeyValue> values = this.getContextValueMap(contextType).values();
        if (null != values) {
            return new ArrayList<ContextKeyValue>(values);
        }
        return null;
    }

    @Override
    public List<ContextKeyValue> getAllLikes(String regex, ContextType contextType) {
        if (StringUtils.isBlank((CharSequence)regex)) {
            return null;
        }
        Map<String, ContextKeyValue> contextValueMap = this.getContextValueMap(contextType);
        ArrayList<ContextKeyValue> contextKeyValueList = new ArrayList<ContextKeyValue>();
        for (String key : contextValueMap.keySet()) {
            if (!key.matches(regex)) continue;
            contextKeyValueList.add(contextValueMap.get(key));
        }
        return contextKeyValueList;
    }

    @Override
    public List<ContextKeyValue> getAll() {
        ArrayList<ContextKeyValue> contextKeyValueList = new ArrayList<ContextKeyValue>();
        for (Map<String, ContextKeyValue> contextKeyValueMap : this.contextValueMapSet.values()) {
            contextKeyValueList.addAll(contextKeyValueMap.values());
        }
        return contextKeyValueList;
    }

    @Override
    public ContextKeyValue remove(String contextKey, ContextType contextType) {
        if (StringUtils.isNotBlank((CharSequence)contextKey)) {
            return this.getContextValueMap(contextType).remove(contextKey);
        }
        return null;
    }

    @Override
    public Map<String, ContextKeyValue> removeAll(ContextType contextType) {
        return this.contextValueMapSet.remove(contextType);
    }

    @Override
    public List<ContextKey> findByKeyPrefix(String preFix) {
        if (StringUtils.isBlank((CharSequence)preFix)) {
            return null;
        }
        ArrayList<ContextKey> contextKeyValueList = new ArrayList<ContextKey>();
        for (Map<String, ContextKeyValue> contextKeyValueMap : this.contextValueMapSet.values()) {
            for (String key : contextKeyValueMap.keySet()) {
                if (!key.startsWith(preFix)) continue;
                contextKeyValueList.add(contextKeyValueMap.get(key).getContextKey());
            }
        }
        return contextKeyValueList;
    }

    @Override
    public List<ContextKey> findByKey(String keyStr) {
        if (StringUtils.isBlank((CharSequence)keyStr)) {
            return null;
        }
        ArrayList<ContextKey> contextKeyValueList = new ArrayList<ContextKey>();
        for (Map<String, ContextKeyValue> contextKeyValueMap : this.contextValueMapSet.values()) {
            for (String key : contextKeyValueMap.keySet()) {
                if (!key.equals(keyStr)) continue;
                contextKeyValueList.add(contextKeyValueMap.get(key).getContextKey());
            }
        }
        return contextKeyValueList;
    }

    @Override
    public List<ContextKey> findByKeyPrefix(String preFix, ContextType csType) {
        if (StringUtils.isBlank((CharSequence)preFix)) {
            return null;
        }
        Map<String, ContextKeyValue> contextValueMap = this.getContextValueMap(csType);
        ArrayList<ContextKey> contextKeyValueList = new ArrayList<ContextKey>();
        for (String key : contextValueMap.keySet()) {
            if (!key.startsWith(preFix)) continue;
            contextKeyValueList.add(contextValueMap.get(key).getContextKey());
        }
        return contextKeyValueList;
    }

    @Override
    public List<ContextKey> findByKey(String keyStr, ContextType csType) {
        if (StringUtils.isBlank((CharSequence)keyStr)) {
            return null;
        }
        Map<String, ContextKeyValue> contextValueMap = this.getContextValueMap(csType);
        ArrayList<ContextKey> contextKeyValueList = new ArrayList<ContextKey>();
        for (String key : contextValueMap.keySet()) {
            if (!key.equals(keyStr)) continue;
            contextKeyValueList.add(contextValueMap.get(key).getContextKey());
        }
        return contextKeyValueList;
    }
}

