/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.index;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndex;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndexSet;
import org.apache.linkis.cs.contextcache.index.DefaultContextInvertedIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInvertedIndexSetImpl
implements ContextInvertedIndexSet {
    private static final Logger logger = LoggerFactory.getLogger(ContextInvertedIndexSetImpl.class);
    private Map<String, ContextInvertedIndex> invertedIndexMap = new ConcurrentHashMap<String, ContextInvertedIndex>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextInvertedIndex getContextInvertedIndex(ContextType contextType) {
        String csType = contextType.name();
        if (!this.invertedIndexMap.containsKey(csType)) {
            String string = csType.intern();
            synchronized (string) {
                if (!this.invertedIndexMap.containsKey(csType)) {
                    logger.info("For ContextType({}) init invertedIndex", (Object)csType);
                    this.invertedIndexMap.put(csType, new DefaultContextInvertedIndex());
                }
            }
        }
        return this.invertedIndexMap.get(csType);
    }

    @Override
    public boolean addValue(String keyword, ContextKey contextKey) {
        return this.addValue(keyword, contextKey.getKey(), contextKey.getContextType());
    }

    @Override
    public boolean addValue(String keyword, String contextKey, ContextType contextType) {
        return this.getContextInvertedIndex(contextType).addValue(keyword, contextKey);
    }

    @Override
    public boolean addKeywords(Set<String> keywords, String contextKey, ContextType contextType) {
        Iterator<String> iterator = keywords.iterator();
        while (iterator.hasNext()) {
            this.addValue(iterator.next(), contextKey, contextType);
        }
        return true;
    }

    @Override
    public List<String> getContextKeys(String keyword, ContextType contextType) {
        return this.getContextInvertedIndex(contextType).getContextKeys(keyword);
    }

    @Override
    public boolean remove(String keyword, String contextKey, ContextType contextType) {
        return this.getContextInvertedIndex(contextType).remove(keyword, contextKey);
    }

    @Override
    public ContextInvertedIndex removeAll(ContextType contextType) {
        return this.invertedIndexMap.remove(contextType.name());
    }
}

