/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseThreadFactory;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseWriter;
import com.clickhouse.data.format.ClickHouseRowBinaryProcessor;
import com.clickhouse.data.format.ClickHouseTabSeparatedProcessor;
import com.clickhouse.data.stream.BlockingPipedOutputStream;
import com.clickhouse.data.stream.CapacityPolicy;
import com.clickhouse.data.stream.NonBlockingPipedOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ClickHouseDataStreamFactory {
    private static final ClickHouseDataStreamFactory instance = ClickHouseUtils.getService(ClickHouseDataStreamFactory.class, new ClickHouseDataStreamFactory());
    protected static final String ERROR_NO_DESERIALIZER = "No deserializer available because format %s does not support input";
    protected static final String ERROR_NO_SERIALIZER = "No serializer available because format %s does not support output";
    protected static final String ERROR_UNSUPPORTED_FORMAT = "Unsupported format: ";

    public static void handleCustomAction(Runnable postCloseAction) throws IOException {
        if (postCloseAction == null) {
            return;
        }
        try {
            postCloseAction.run();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static ClickHouseDataStreamFactory getInstance() {
        return instance;
    }

    public ExecutorService getExecutor() {
        return DefaultExecutors.executor;
    }

    public ScheduledExecutorService getScheduler() {
        return DefaultExecutors.scheduler;
    }

    public <T> CompletableFuture<T> runBlockingTask(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, DefaultExecutors.executor);
    }

    public ScheduledFuture<?> scheduleTask(Runnable task, long delay, TimeUnit unit) {
        return DefaultExecutors.scheduler.schedule(task, delay, unit);
    }

    public ClickHouseDataProcessor getProcessor(ClickHouseDataConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, Map<String, Serializable> settings, List<ClickHouseColumn> columns) throws IOException {
        ClickHouseFormat format = ClickHouseChecker.nonNull(config, "DataConfig").getFormat();
        ClickHouseDataProcessor processor = null;
        if (ClickHouseFormat.RowBinary == format || ClickHouseFormat.RowBinaryWithNamesAndTypes == format) {
            processor = new ClickHouseRowBinaryProcessor(config, input, output, columns, settings);
        } else if (format.isText()) {
            processor = new ClickHouseTabSeparatedProcessor(config, input, output, columns, settings);
        }
        return processor;
    }

    public final ClickHousePipedOutputStream createPipedOutputStream(ClickHouseDataConfig config) {
        return this.createPipedOutputStream(config, (Runnable)null);
    }

    public ClickHousePipedOutputStream createPipedOutputStream(ClickHouseDataConfig config, Runnable postCloseAction) {
        int timeout;
        CapacityPolicy policy;
        int queue;
        boolean blocking;
        int bufferSize = ClickHouseChecker.nonNull(config, "DataConfig").getWriteBufferSize();
        if (config.getReadBufferingMode() == ClickHouseBufferingMode.PERFORMANCE) {
            blocking = false;
            queue = 0;
            policy = null;
            timeout = 0;
        } else {
            blocking = config.isUseBlockingQueue();
            queue = config.getMaxQueuedBuffers();
            policy = config.getBufferQueueVariation() < 1 ? CapacityPolicy.fixedCapacity(queue) : CapacityPolicy.linearDynamicCapacity(1, queue, config.getBufferQueueVariation());
            timeout = config.getReadTimeout();
        }
        return blocking ? new BlockingPipedOutputStream(bufferSize, queue, (long)timeout, postCloseAction) : new NonBlockingPipedOutputStream(bufferSize, queue, (long)timeout, policy, postCloseAction);
    }

    public ClickHousePipedOutputStream createPipedOutputStream(ClickHouseDataConfig config, ClickHouseWriter writer) {
        int timeout;
        CapacityPolicy policy;
        int queue;
        boolean blocking;
        if (config == null || writer == null) {
            throw new IllegalArgumentException("Non-null config and writer are required");
        }
        int bufferSize = config.getWriteBufferSize();
        if (config.getReadBufferingMode() == ClickHouseBufferingMode.PERFORMANCE) {
            blocking = false;
            queue = 0;
            policy = null;
            timeout = 0;
        } else {
            blocking = config.isUseBlockingQueue();
            queue = config.getMaxQueuedBuffers();
            policy = config.getBufferQueueVariation() < 1 ? CapacityPolicy.fixedCapacity(queue) : CapacityPolicy.linearDynamicCapacity(1, queue, config.getBufferQueueVariation());
            timeout = config.getReadTimeout();
        }
        return blocking ? new BlockingPipedOutputStream(bufferSize, queue, (long)timeout, writer) : new NonBlockingPipedOutputStream(bufferSize, queue, (long)timeout, policy, writer);
    }

    public final ClickHousePipedOutputStream createPipedOutputStream(int bufferSize, int queueSize, int timeout) {
        return this.createPipedOutputStream(bufferSize, queueSize, timeout, (Runnable)null);
    }

    public ClickHousePipedOutputStream createPipedOutputStream(int bufferSize, int queueSize, int timeout, Runnable postCloseAction) {
        return new BlockingPipedOutputStream(ClickHouseDataConfig.getBufferSize(bufferSize), queueSize, (long)timeout, postCloseAction);
    }

    public ClickHousePipedOutputStream createPipedOutputStream(int bufferSize, int queueSize, int timeout, ClickHouseWriter writer) {
        return new BlockingPipedOutputStream(ClickHouseDataConfig.getBufferSize(bufferSize), queueSize, (long)timeout, writer);
    }

    protected static final class DefaultExecutors {
        protected static final ExecutorService executor;
        protected static final ScheduledExecutorService scheduler;

        private DefaultExecutors() {
        }

        static {
            int coreThreads = 2 * Runtime.getRuntime().availableProcessors() + 1;
            if (coreThreads < 4) {
                coreThreads = 4;
            }
            executor = ClickHouseUtils.newThreadPool("ClickHouseWorker-", coreThreads, coreThreads, 0, 0L, false);
            scheduler = Executors.newSingleThreadScheduledExecutor(new ClickHouseThreadFactory("ClickHouseScheduler-"));
        }
    }
}

