/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.builders.EnumerationElementFacetBuilder;
import springfox.documentation.schema.ElementFacet;

public class EnumerationFacet
implements ElementFacet {
    private final List<String> allowedValues = new ArrayList<String>();

    public EnumerationFacet(Collection<String> allowedValues) {
        this.allowedValues.addAll(allowedValues);
        this.allowedValues.sort(Comparator.naturalOrder());
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public Class<? extends ElementFacetBuilder> facetBuilder() {
        return EnumerationElementFacetBuilder.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumerationFacet that = (EnumerationFacet)o;
        return Objects.equals(this.allowedValues, that.allowedValues);
    }

    public int hashCode() {
        return Objects.hash(this.allowedValues);
    }

    public String toString() {
        return new StringJoiner(", ", EnumerationFacet.class.getSimpleName() + "[", "]").add("allowedValues=" + this.allowedValues).toString();
    }
}

