/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.loadbalancer;

import java.util.HashSet;
import org.apache.linkis.httpclient.discovery.DiscoveryListener;
import org.apache.linkis.httpclient.loadbalancer.LoadBalancer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3Q\u0001D\u0007\u0002\u0002aAQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u0004B\u0001\u0001\u0006IA\f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003.\u0011\u0019\u0019\u0005\u0001)A\u0005]!)A\t\u0001C!\u000b\")1\n\u0001C!\u0019\")a\n\u0001C!\u001f\")\u0011\u000b\u0001C!%\")A\u000b\u0001C!+\")\u0011\f\u0001C\u0001+\n!\u0012IY:ue\u0006\u001cG\u000fT8bI\n\u000bG.\u00198dKJT!AD\b\u0002\u00191|\u0017\r\u001a2bY\u0006t7-\u001a:\u000b\u0005A\t\u0012A\u00035uiB\u001cG.[3oi*\u0011!cE\u0001\u0007Y&t7.[:\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011dH\u0012\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013%D\u0001\u000e\u0013\t\u0011SB\u0001\u0007M_\u0006$')\u00197b]\u000e,'\u000f\u0005\u0002%O5\tQE\u0003\u0002'\u001f\u0005IA-[:d_Z,'/_\u0005\u0003Q\u0015\u0012\u0011\u0003R5tG>4XM]=MSN$XM\\3s\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002!\u0001\u0005Q1/\u001a:wKJ,&\u000f\\:\u0016\u00039\u00022a\f\u001b7\u001b\u0005\u0001$BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\b\u0011\u0006\u001c\bnU3u!\t9dH\u0004\u00029yA\u0011\u0011hG\u0007\u0002u)\u00111hF\u0001\u0007yI|w\u000e\u001e \n\u0005uZ\u0012A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u000e\u0002\u0017M,'O^3s+Jd7\u000fI\u0001\u0014k:DW-\u00197uQf\u001cVM\u001d<feV\u0013Hn]\u0001\u0015k:DW-\u00197uQf\u001cVM\u001d<feV\u0013Hn\u001d\u0011\u0002%=t7+\u001a:wKJ$\u0015n]2pm\u0016\u0014X\r\u001a\u000b\u0003\r&\u0003\"AG$\n\u0005![\"\u0001B+oSRDQA\u0013\u0004A\u0002Y\n\u0011b]3sm\u0016\u0014XK\u001d7\u0002'=t7+\u001a:wKJ,fnY8o]\u0016\u001cG/\u001a3\u0015\u0005\u0019k\u0005\"\u0002&\b\u0001\u00041\u0014!E8o'\u0016\u0014h/\u001a:V]\",\u0017\r\u001c;isR\u0011a\t\u0015\u0005\u0006\u0015\"\u0001\rAN\u0001\u0010_:\u001cVM\u001d<fe\"+\u0017\r\u001c;isR\u0011ai\u0015\u0005\u0006\u0015&\u0001\rAN\u0001\u0011O\u0016$\u0018\t\u001c7TKJ4XM]+sYN,\u0012A\u0016\t\u00045]3\u0014B\u0001-\u001c\u0005\u0015\t%O]1z\u0003e9W\r^!mYVs\u0007.Z1mi\"L8+\u001a:wKJ,&\u000f\\:")
public abstract class AbstractLoadBalancer
implements LoadBalancer,
DiscoveryListener {
    private final HashSet<String> serverUrls = new HashSet();
    private final HashSet<String> unhealthyServerUrls = new HashSet();

    private HashSet<String> serverUrls() {
        return this.serverUrls;
    }

    private HashSet<String> unhealthyServerUrls() {
        return this.unhealthyServerUrls;
    }

    @Override
    public void onServerDiscovered(String serverUrl) {
        HashSet<String> hashSet = this.serverUrls();
        synchronized (hashSet) {
            this.serverUrls().add(serverUrl);
        }
        if (this.unhealthyServerUrls().contains(serverUrl)) {
            HashSet<String> hashSet2 = this.unhealthyServerUrls();
            synchronized (hashSet2) {
                this.unhealthyServerUrls().remove(serverUrl);
            }
            return;
        }
    }

    @Override
    public void onServerUnconnected(String serverUrl) {
        HashSet<String> hashSet = this.serverUrls();
        synchronized (hashSet) {
            this.serverUrls().remove(serverUrl);
        }
        HashSet<String> hashSet2 = this.unhealthyServerUrls();
        synchronized (hashSet2) {
            this.unhealthyServerUrls().remove(serverUrl);
        }
    }

    @Override
    public void onServerUnhealthy(String serverUrl) {
        HashSet<String> hashSet = this.unhealthyServerUrls();
        synchronized (hashSet) {
            this.unhealthyServerUrls().add(serverUrl);
        }
    }

    @Override
    public void onServerHealthy(String serverUrl) {
        HashSet<String> hashSet = this.unhealthyServerUrls();
        synchronized (hashSet) {
            this.unhealthyServerUrls().remove(serverUrl);
        }
        HashSet<String> hashSet2 = this.serverUrls();
        synchronized (hashSet2) {
            this.serverUrls().add(serverUrl);
        }
    }

    @Override
    public String[] getAllServerUrls() {
        return (String[])this.serverUrls().toArray((Object[])new String[this.serverUrls().size()]);
    }

    public String[] getAllUnhealthyServerUrls() {
        return (String[])this.unhealthyServerUrls().toArray((Object[])new String[this.unhealthyServerUrls().size()]);
    }
}

