/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.shell.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.conf.ComputationExecutorConf$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.governance.common.utils.GovernanceUtils$;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.engineplugin.shell.common.ShellEngineConnPluginConst$;
import org.apache.linkis.manager.engineplugin.shell.exception.ShellCodeErrorException;
import org.apache.linkis.manager.engineplugin.shell.executor.ReaderThread;
import org.apache.linkis.manager.engineplugin.shell.executor.YarnAppIdExtractor;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0010!\u0001=B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\nAC\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011B+\t\u0013m\u0003\u0001\u0019!A!B\u0013\t\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007g\u0002\u0001\u000b\u0011\u00020\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013A!\"!\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0011-\ty\u0001\u0001a\u0001\u0002\u0004%I!!\u0005\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111\u0004\u0005\f\u0003?\u0001\u0001\u0019!A!B\u0013\t\u0019\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011q\u0016\u0001\u0005B\u0005E\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\ty\r\u0001C!\u0003#Dq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0002t\u0002!\t%!>\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9\u0011q \u0001\u0005B\u0005\r\"aF*iK2dWI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0015\t\t#%\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\t\u0019C%A\u0003tQ\u0016dGN\u0003\u0002&M\u0005aQM\\4j]\u0016\u0004H.^4j]*\u0011q\u0005K\u0001\b[\u0006t\u0017mZ3s\u0015\tI#&\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u00014\b\u0005\u00022s5\t!G\u0003\u00024i\u00059Q\r_3dkR,'BA\u00116\u0015\t1t'A\u0006d_6\u0004X\u000f^1uS>t'B\u0001\u001d)\u0003))gnZ5oK\u000e|gN\\\u0005\u0003uI\u00121cQ8naV$\u0018\r^5p]\u0016CXmY;u_J\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0001C\u0013AB2p[6|g.\u0003\u0002C{\t9Aj\\4hS:<\u0017AA5e!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051s\u0005CA'\u0001\u001b\u0005\u0001\u0003\"B\"\u0003\u0001\u0004!\u0015AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003E\u0003\"!\r*\n\u0005M\u0013$AF#oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u00025\u0015tw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR|F%Z9\u0015\u0005YK\u0006CA#X\u0013\tAfI\u0001\u0003V]&$\bb\u0002.\u0005\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014aF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u00039)\u00070Z2vi>\u0014H*\u00192fYN,\u0012A\u0018\t\u0004?\u00124W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n!A*[:ua\t9\u0017\u000fE\u0002i[>l\u0011!\u001b\u0006\u0003U.\fa!\u001a8uSRL(B\u00017'\u0003\u0015a\u0017MY3m\u0013\tq\u0017NA\u0003MC\n,G\u000e\u0005\u0002qc2\u0001A!\u0003:\b\u0003\u0003\u0005\tQ!\u0001u\u0005\ryF%M\u0001\u0010Kb,7-\u001e;pe2\u000b'-\u001a7tAE\u0011Q\u000f\u001f\t\u0003\u000bZL!a\u001e$\u0003\u000f9{G\u000f[5oOB\u0011Q)_\u0005\u0003u\u001a\u00131!\u00118z\u0003\u001d\u0001(o\\2fgN,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005!-\u0001\u0003mC:<\u0017bAA\u0003\u007f\n9\u0001K]8dKN\u001c\u0018a\u00039s_\u000e,7o]0%KF$2AVA\u0006\u0011\u001dQ\u0016\"!AA\u0002u\f\u0001\u0002\u001d:pG\u0016\u001c8\u000fI\u0001\nKb$(/Y2u_J,\"!a\u0005\u0011\u00075\u000b)\"C\u0002\u0002\u0018\u0001\u0012!#W1s]\u0006\u0003\b/\u00133FqR\u0014\u0018m\u0019;pe\u0006iQ\r\u001f;sC\u000e$xN]0%KF$2AVA\u000f\u0011!QF\"!AA\u0002\u0005M\u0011AC3yiJ\f7\r^8sA\u0005!\u0011N\\5u)\u00051\u0016!E3yK\u000e,H/Z\"p[BdW\r^3msRA\u0011\u0011FA\u001d\u0003w\t)\u0006\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0011\u0015DXmY;uKJT1!a\r)\u0003%\u00198\r[3ek2,'/\u0003\u0003\u00028\u00055\"aD#yK\u000e,H/\u001a*fgB|gn]3\t\u000b={\u0001\u0019A)\t\u000f\u0005ur\u00021\u0001\u0002@\u0005!1m\u001c3f!\u0011\t\t%a\u0014\u000f\t\u0005\r\u00131\n\t\u0004\u0003\u000b2UBAA$\u0015\r\tIEL\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055c)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b2\u0005bBA,\u001f\u0001\u0007\u0011qH\u0001\u000eG>l\u0007\u000f\\3uK\u0012d\u0015N\\3\u0002\u0017\u0015DXmY;uK2Kg.\u001a\u000b\u0007\u0003S\ti&a\u0018\t\u000b=\u0003\u0002\u0019A)\t\u000f\u0005u\u0002\u00031\u0001\u0002@\u0005\u0011\u0012n]#yK\u000e,H/\u001a)bi\",\u00050[:u)\u0011\t)'a\u001b\u0011\u0007\u0015\u000b9'C\u0002\u0002j\u0019\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002nE\u0001\r!a\u0010\u0002\u0017\u0015DXmY;uKB\u000bG\u000f[\u0001\u0010O\u0016tWM]1uKJ+hnQ8eKR!\u00111OA=!\u0015)\u0015QOA \u0013\r\t9H\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003{\u0011\u0002\u0019AA \u0003]9WM\\3sCR,'+\u001e8D_\u0012,w+\u001b;i\u0003J<7\u000f\u0006\u0004\u0002t\u0005}\u0014\u0011\u0011\u0005\b\u0003{\u0019\u0002\u0019AA \u0011\u001d\t\u0019i\u0005a\u0001\u0003g\nA!\u0019:hg\u0006)q-\u001a;JIR\u0011\u0011qH\u0001\u0010O\u0016$\bK]8he\u0016\u001c8/\u00138g_R!\u0011QRAP!\u0015)\u0015QOAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000ba!\u001a8hS:,'bAAMQ\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u001e\u0006M%a\u0004&pEB\u0013xn\u001a:fgNLeNZ8\t\u000f\u0005\u0005V\u00031\u0001\u0002@\u00051A/Y:l\u0013\u0012\u000b\u0001\u0002\u001d:pOJ,7o\u001d\u000b\u0005\u0003O\u000bi\u000bE\u0002F\u0003SK1!a+G\u0005\u00151En\\1u\u0011\u001d\t\tK\u0006a\u0001\u0003\u007f\t1c];qa>\u0014HoQ1mY\n\u000b7m\u001b'pON$\"!!\u001a\u0002/I,\u0017/^3ti\u0016C\b/Z2uK\u0012\u0014Vm]8ve\u000e,G\u0003BA\\\u0003\u000f\u0004B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0005sKN|WO]2f\u0015\rQ\u0017\u0011\u0019\u0006\u0003\u0001\u001aJA!!2\u0002<\naaj\u001c3f%\u0016\u001cx.\u001e:dK\"9\u0011\u0011\u001a\rA\u0002\u0005]\u0016\u0001E3ya\u0016\u001cG/\u001a3SKN|WO]2f\u0003Y9W\r^\"veJ,g\u000e\u001e(pI\u0016\u0014Vm]8ve\u000e,GCAA\\\u0003E9W\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0003\u0003'\u0004Ba\u00183\u0002VB\"\u0011q[An!\u0011AW.!7\u0011\u0007A\fY\u000e\u0002\u0006\u0002^j\t\t\u0011!A\u0003\u0002Q\u00141a\u0018\u00134\u0003E\u0019X\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0004-\u0006\r\bbBAs7\u0001\u0007\u0011q]\u0001\u0007Y\u0006\u0014W\r\\:\u0011\t}#\u0017\u0011\u001e\u0019\u0005\u0003W\fy\u000f\u0005\u0003i[\u00065\bc\u00019\u0002p\u0012Y\u0011\u0011_Ar\u0003\u0003\u0005\tQ!\u0001u\u0005\ryF\u0005N\u0001\tW&dG\u000eV1tWR\u0019a+a>\t\u000f\u0005\u0005F\u00041\u0001\u0002@\u00051q-\u001a;QS\u0012$2\u0001RA\u007f\u0011\u0015YX\u00041\u0001~\u0003\u0015\u0019Gn\\:f\u0001")
public class ShellEngineConnExecutor
extends ComputationExecutor {
    private final int id;
    private EngineExecutionContext engineExecutionContext;
    private final List<Label<?>> executorLabels;
    private Process process;
    private YarnAppIdExtractor extractor;

    private EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    private void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private YarnAppIdExtractor extractor() {
        return this.extractor;
    }

    private void extractor_$eq(YarnAppIdExtractor x$1) {
        this.extractor = x$1;
    }

    public void init() {
        this.logger().info("Ready to change engine state!");
        super.init();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutionContext, String code, String completedLine) {
        String newcode = new StringBuilder(0).append(completedLine).append(code).toString();
        this.logger().debug(new StringBuilder(11).append("newcode is ").append(newcode).toString());
        return this.executeLine(engineExecutionContext, newcode);
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutionContext, String code) {
        ErrorExecuteResponse errorExecuteResponse;
        block13: {
            if (engineExecutionContext != null) {
                this.engineExecutionContext_$eq(engineExecutionContext);
                this.logger().info("Shell executor reset new engineExecutionContext!");
            }
            BufferedReader bufferedReader = null;
            BufferedReader errorsReader = null;
            AtomicBoolean completed = new AtomicBoolean(false);
            ReaderThread errReaderThread = null;
            ReaderThread inputReaderThread = null;
            try {
                try {
                    Object object;
                    Object object2;
                    engineExecutionContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(code.trim()).toString());
                    String[] argsArr = engineExecutionContext.getTotalParagraph() == 1 && engineExecutionContext.getProperties() != null && engineExecutionContext.getProperties().containsKey(ShellEngineConnPluginConst$.MODULE$.RUNTIME_ARGS_KEY()) ? (String[])Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                        ArrayList argsList = (ArrayList)engineExecutionContext.getProperties().get(ShellEngineConnPluginConst$.MODULE$.RUNTIME_ARGS_KEY());
                        this.logger().info(new StringBuilder(57).append("Will execute shell task with user-specified arguments: '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(argsList.toArray((Object[])new String[argsList.size()]))).mkString("' '")).append("'").toString());
                        return (String[])argsList.toArray((Object[])new String[argsList.size()]);
                    }, (Function1 & Serializable & scala.Serializable)t -> {
                        this.logger().warn("Cannot read user-input shell arguments. Will execute shell task without them.", t);
                        return null;
                    }) : null;
                    String workingDirectory = engineExecutionContext.getTotalParagraph() == 1 && engineExecutionContext.getProperties() != null && engineExecutionContext.getProperties().containsKey(ShellEngineConnPluginConst$.MODULE$.SHELL_RUNTIME_WORKING_DIRECTORY()) ? (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                        String wdStr = (String)engineExecutionContext.getProperties().get(ShellEngineConnPluginConst$.MODULE$.SHELL_RUNTIME_WORKING_DIRECTORY());
                        if (this.isExecutePathExist(wdStr)) {
                            this.logger().info(new StringBuilder(65).append("Will execute shell task under user-specified working-directory: '").append(wdStr).toString());
                            return wdStr;
                        }
                        this.logger().warn(new StringBuilder(183).append("User-specified working-directory: '").append(wdStr).append("' does not exist or user does not have access permission. ").append("Will execute shell task under default working-directory. Please contact the administrator!").toString());
                        return null;
                    }, (Function1 & Serializable & scala.Serializable)t -> {
                        this.logger().warn("Cannot read user-input working-directory. Will execute shell task under default working-directory.", t);
                        return null;
                    }) : null;
                    String[] generatedCode = argsArr == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])argsArr)).isEmpty() ? this.generateRunCode(code) : this.generateRunCodeWithArgs(code, argsArr);
                    ProcessBuilder processBuilder = new ProcessBuilder(generatedCode);
                    Object object3 = StringUtils.isNotBlank((CharSequence)workingDirectory) ? processBuilder.directory(new File(workingDirectory)) : BoxedUnit.UNIT;
                    Map<String, String> env = processBuilder.environment();
                    String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutionContext.getProperties());
                    if (StringUtils.isNotBlank((CharSequence)jobId)) {
                        this.logger().info(new StringBuilder(16).append("set env job id ").append(jobId).append(".").toString());
                        object2 = env.put(ComputationExecutorConf$.MODULE$.JOB_ID_TO_ENV_KEY(), jobId);
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    String jobTags = JobUtils$.MODULE$.getJobSourceTagsFromObjectMap(engineExecutionContext.getProperties());
                    if (StringUtils.isAsciiPrintable((CharSequence)jobTags)) {
                        env.put(ECConstants$.MODULE$.HIVE_OPTS(), new StringBuilder(31).append(" --hiveconf mapreduce.job.tags=").append(jobTags).toString());
                        object = env.put(ECConstants$.MODULE$.SPARK_SUBMIT_OPTS(), new StringBuilder(19).append(" -Dspark.yarn.tags=").append(jobTags).toString());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    processBuilder.redirectErrorStream(false);
                    this.extractor_$eq(new YarnAppIdExtractor());
                    this.process_$eq(processBuilder.start());
                    bufferedReader = new BufferedReader(new InputStreamReader(this.process().getInputStream()));
                    errorsReader = new BufferedReader(new InputStreamReader(this.process().getErrorStream()));
                    CountDownLatch counter = new CountDownLatch(2);
                    inputReaderThread = new ReaderThread(engineExecutionContext, bufferedReader, this.extractor(), true, counter);
                    errReaderThread = new ReaderThread(engineExecutionContext, errorsReader, this.extractor(), false, counter);
                    inputReaderThread.start();
                    errReaderThread.start();
                    int exitCode = this.process().waitFor();
                    counter.await();
                    completed.set(true);
                    if (exitCode != 0) {
                        errorExecuteResponse = new ErrorExecuteResponse(new StringBuilder(30).append("run shell failed with error:\n ").append(errReaderThread.getOutString()).toString(), (Throwable)((Object)new ShellCodeErrorException()));
                        break block13;
                    }
                    errorExecuteResponse = new SuccessExecuteResponse();
                }
                catch (Exception e) {
                    this.logger().error("Execute shell code failed, reason:", (Throwable)e);
                    errorExecuteResponse = new ErrorExecuteResponse("run shell failed", (Throwable)e);
                }
            }
            finally {
                if (errorsReader != null) {
                    inputReaderThread.onDestroy();
                }
                if (inputReaderThread != null) {
                    errReaderThread.onDestroy();
                }
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly(errorsReader);
            }
        }
        return errorExecuteResponse;
    }

    private boolean isExecutePathExist(String executePath) {
        File etlHomeDir = new File(executePath);
        return etlHomeDir.exists() && etlHomeDir.isDirectory();
    }

    private String[] generateRunCode(String code) {
        return (String[])((Object[])new String[]{"sh", "-c", code});
    }

    private String[] generateRunCodeWithArgs(String code, String[] args) {
        return (String[])((Object[])new String[]{"sh", "-c", new StringBuilder(30).append("echo \"dummy ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("\" | xargs sh -c '").append(code).append("'").toString()});
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id).toString();
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ArrayBuffer jobProgressInfo = new ArrayBuffer();
        if (this.engineExecutionContext() == null) {
            return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
        }
        ArrayBuffer arrayBuffer = 0.0f == this.progress(taskID) ? jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 1, 0, 0)) : jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 0, 0, 1));
        return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public float progress(String taskID) {
        if (this.engineExecutionContext() != null) {
            return (float)this.engineExecutionContext().getCurrentParagraph() / (float)this.engineExecutionContext().getTotalParagraph();
        }
        return 0.0f;
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public void killTask(String taskID) {
        int pid = this.getPid(this.process());
        GovernanceUtils$.MODULE$.killProcess(String.valueOf(pid), new StringBuilder(18).append("kill task ").append(taskID).append(" process").toString(), false);
        List<String> yarnAppIds = this.extractor().getExtractedYarnAppIds();
        GovernanceUtils$.MODULE$.killYarnJobApp(yarnAppIds);
        this.logger().info(new StringBuilder(48).append("Finished kill yarn app ids in the engine of (").append(this.getId()).append(").}").toString());
        super.killTask(taskID);
    }

    private int getPid(Process process) {
        return BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Class<?> clazz = Class.forName("java.lang.UNIXProcess");
            Field field = clazz.getDeclaredField("pid");
            field.setAccessible(true);
            return BoxesRunTime.unboxToInt((Object)field.get(process));
        }, (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)ShellEngineConnExecutor.$anonfun$getPid$2(this, t))));
    }

    public void close() {
        try {
            super.close();
            this.process().destroy();
        }
        catch (Exception e) {
            this.logger().error(new StringBuilder(21).append("kill process ").append(this.process().toString()).append(" failed ").toString(), (Throwable)e);
        }
        catch (Throwable t) {
            this.logger().error(new StringBuilder(21).append("kill process ").append(this.process().toString()).append(" failed ").toString(), t);
        }
    }

    public static final /* synthetic */ int $anonfun$getPid$2(ShellEngineConnExecutor $this, Throwable t) {
        $this.logger().warn("Failed to acquire pid for shell process");
        return -1;
    }

    public ShellEngineConnExecutor(int id) {
        this.id = id;
        super(ComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.executorLabels = new ArrayList();
    }
}

