/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.service;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.acessible.executor.entity.AccessibleExecutor;
import org.apache.linkis.engineconn.acessible.executor.listener.ExecutorLockListener;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorLockEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorUnLockEvent;
import org.apache.linkis.engineconn.acessible.executor.lock.EngineConnTimedLock;
import org.apache.linkis.engineconn.acessible.executor.service.LockService;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.listener.event.EngineConnAsyncEvent;
import org.apache.linkis.governance.common.exception.engineconn.EngineConnExecutorErrorException;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.protocol.RequestEngineLock;
import org.apache.linkis.manager.common.protocol.RequestEngineUnlock;
import org.apache.linkis.manager.common.protocol.ResponseEngineLock;
import org.apache.linkis.manager.common.protocol.ResponseEngineUnlock;
import org.apache.linkis.manager.common.protocol.engine.EngineLockType;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u000b\u0017\u0001\u0015BQ\u0001\u000f\u0001\u0005\u0002eB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0013!\u0005\"\u0003&\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011%Y\u0005\u00011AA\u0002\u0013%A\nC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I1\f\u0001a\u0001\u0002\u0003\u0006K!\u0014\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001c\u0001!B\u0013q\u0006\"B7\u0001\t\u0013q\u0007\"\u0002:\u0001\t\u0003\u001a\bbB;\u0001#\u0003%\tA\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002~\u0001!\t%a \t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAf\u0001\u0011\u0005\u0013Q\u001a\u0002\u001b\u000b:<\u0017N\\3D_:tG+[7fI2{7m[*feZL7-\u001a\u0006\u0003/a\tqa]3sm&\u001cWM\u0003\u0002\u001a5\u0005AQ\r_3dkR|'O\u0003\u0002\u001c9\u0005I\u0011mY3tg&\u0014G.\u001a\u0006\u0003;y\t!\"\u001a8hS:,7m\u001c8o\u0015\ty\u0002%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011C\u0006\r\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055rS\"\u0001\f\n\u0005=2\"a\u0003'pG.\u001cVM\u001d<jG\u0016\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u000bU$\u0018\u000e\\:\u000b\u0005Ur\u0012AB2p[6|g.\u0003\u00028e\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001;!\ti\u0003!\u0001\bf]\u001eLg.Z\"p]:dunY6\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\r\u0002\t1|7m[\u0005\u0003\u0005~\u00121#\u00128hS:,7i\u001c8o)&lW\r\u001a'pG.\f!#\u001a8hS:,7i\u001c8o\u0019>\u001c7n\u0018\u0013fcR\u0011Q\t\u0013\t\u0003O\u0019K!a\u0012\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013\u000e\t\t\u00111\u0001>\u0003\rAH%M\u0001\u0010K:<\u0017N\\3D_:tGj\\2lA\u0005QAn\\2l'R\u0014\u0018N\\4\u0016\u00035\u0003\"AT+\u000f\u0005=\u001b\u0006C\u0001))\u001b\u0005\t&B\u0001*%\u0003\u0019a$o\\8u}%\u0011A\u000bK\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002UQ\u0005qAn\\2l'R\u0014\u0018N\\4`I\u0015\fHCA#[\u0011\u001dIe!!AA\u00025\u000b1\u0002\\8dWN#(/\u001b8hA\u0005AAn\\2l)f\u0004X-F\u0001_!\tyv-D\u0001a\u0015\t\t'-\u0001\u0004f]\u001eLg.\u001a\u0006\u0003G\u0012\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003k\u0015T!A\u001a\u0010\u0002\u000f5\fg.Y4fe&\u0011\u0001\u000e\u0019\u0002\u000f\u000b:<\u0017N\\3M_\u000e\\G+\u001f9f\u00031awnY6UsB,w\fJ3r)\t)5\u000eC\u0004J\u0013\u0005\u0005\t\u0019\u00010\u0002\u00131|7m\u001b+za\u0016\u0004\u0013\u0001F5t'V\u0004\bo\u001c:u!\u0006\u0014\u0018\r\u001c7fY&\u001cX.F\u0001p!\t9\u0003/\u0003\u0002rQ\t9!i\\8mK\u0006t\u0017aC5t\u0019>\u001c7.\u0012=jgR$\"a\u001c;\t\u000f\u0001c\u0001\u0013!a\u0001\u001b\u0006)\u0012n\u001d'pG.,\u00050[:uI\u0011,g-Y;mi\u0012\nT#A<+\u00055C8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tq\b&\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\biJLHj\\2l)\u0011\t9!!\u0004\u0011\t\u001d\nI!T\u0005\u0004\u0003\u0017A#AB(qi&|g\u000eC\u0004\u0002\u00109\u0001\r!!\u0005\u0002#I,\u0017/^3ti\u0016sw-\u001b8f\u0019>\u001c7\u000e\u0005\u0003\u0002\u0014\u0005UQ\"\u00012\n\u0007\u0005]!MA\tSKF,Xm\u001d;F]\u001eLg.\u001a'pG.DSADA\u000e\u0003k\u0001RaJA\u000f\u0003CI1!a\b)\u0005\u0019!\bN]8xgB!\u00111EA\u0019\u001b\t\t)CC\u0002\u001e\u0003OQA!!\u000b\u0002,\u0005IQ\r_2faRLwN\u001c\u0006\u0004k\u00055\"bAA\u0018=\u0005Qqm\u001c<fe:\fgnY3\n\t\u0005M\u0012Q\u0005\u0002!\u000b:<\u0017N\\3D_:tW\t_3dkR|'/\u0012:s_J,\u0005pY3qi&|g.\r\u0004\u001f\u001b\u0006]\u0012qM\u0019\nG\u0005e\u0012qHA/\u0003\u0003*2\u0001TA\u001e\t\u001d\ti\u0004\nb\u0001\u0003\u000f\u0012\u0011\u0001V\u0005\u0005\u0003\u0003\n\u0019%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u000bB\u0013A\u0002;ie><8/\u0005\u0003\u0002J\u0005=\u0003cA\u0014\u0002L%\u0019\u0011Q\n\u0015\u0003\u000f9{G\u000f[5oOB!\u0011\u0011KA,\u001d\r9\u00131K\u0005\u0004\u0003+B\u0013a\u00029bG.\fw-Z\u0005\u0005\u00033\nYFA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\u000b\u00152\u0013\r\ny&!\u0019\u0002d\u0005\u0015cbA\u0014\u0002b%\u0019\u0011Q\t\u00152\u000b\t:\u0003&!\u001a\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\t#A\u0005uS6,G\rT8dWR!\u0011qAA7\u0011\u001d\tyg\u0004a\u0001\u0003c\nq\u0001^5nK>,H\u000fE\u0002(\u0003gJ1!!\u001e)\u0005\u0011auN\\4\u0002\rUtGn\\2l)\ry\u00171\u0010\u0005\u0006\u0001B\u0001\r!T\u0001\u000ee\u0016\fX/Z:u+:dunY6\u0015\t\u0005\u0005\u0015q\u0011\t\u0005\u0003'\t\u0019)C\u0002\u0002\u0006\n\u0014ACU3ta>t7/Z#oO&tW-\u00168m_\u000e\\\u0007bBAE#\u0001\u0007\u00111R\u0001\u0014e\u0016\fX/Z:u\u000b:<\u0017N\\3V]2|7m\u001b\t\u0005\u0003'\ti)C\u0002\u0002\u0010\n\u00141CU3rk\u0016\u001cH/\u00128hS:,WK\u001c7pG.D3!EAJ!\u0011\t)*!)\u000e\u0005\u0005]%b\u0001@\u0002\u001a*!\u00111TAO\u0003\u001diWm]:bO\u0016T1!a(\u001f\u0003\r\u0011\boY\u0005\u0005\u0003G\u000b9J\u0001\u0005SK\u000e,\u0017N^3s\u0003%yg.\u00113e\u0019>\u001c7\u000eF\u0002F\u0003SCq!a+\u0013\u0001\u0004\ti+\u0001\u0007bI\u0012dunY6Fm\u0016tG\u000f\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\u000b\u00154XM\u001c;\u000b\u0007\u0005]\u0006$\u0001\u0005mSN$XM\\3s\u0013\u0011\tY,!-\u0003#\u0015CXmY;u_JdunY6Fm\u0016tG/A\u0007p]J+G.Z1tK2{7m\u001b\u000b\u0004\u000b\u0006\u0005\u0007bBAb'\u0001\u0007\u0011QY\u0001\u0011e\u0016dW-Y:f\u0019>\u001c7.\u0012<f]R\u0004B!a,\u0002H&!\u0011\u0011ZAY\u0005M)\u00050Z2vi>\u0014XK\u001c'pG.,e/\u001a8u\u0003-\u0011X-];fgRdunY6\u0015\t\u0005=\u0017Q\u001b\t\u0005\u0003'\t\t.C\u0002\u0002T\n\u0014!CU3ta>t7/Z#oO&tW\rT8dW\"9\u0011q\u0002\u000bA\u0002\u0005E\u0001f\u0001\u000b\u0002\u0014\u0002")
public class EngineConnTimedLockService
implements LockService {
    private EngineConnTimedLock engineConnLock;
    private String lockString;
    private EngineLockType lockType;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public void onEvent(EngineConnAsyncEvent event) {
        ExecutorLockListener.onEvent$(this, event);
    }

    @Override
    public void onEventError(Event event, Throwable t) {
        ExecutorLockListener.onEventError$(this, event, t);
    }

    private Logger logger$lzycompute() {
        EngineConnTimedLockService engineConnTimedLockService = this;
        synchronized (engineConnTimedLockService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private EngineConnTimedLock engineConnLock() {
        return this.engineConnLock;
    }

    private void engineConnLock_$eq(EngineConnTimedLock x$1) {
        this.engineConnLock = x$1;
    }

    private String lockString() {
        return this.lockString;
    }

    private void lockString_$eq(String x$1) {
        this.lockString = x$1;
    }

    private EngineLockType lockType() {
        return this.lockType;
    }

    private void lockType_$eq(EngineLockType x$1) {
        this.lockType = x$1;
    }

    private boolean isSupportParallelism() {
        return BoxesRunTime.unboxToBoolean((Object)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_SUPPORT_PARALLELISM().getHotValue());
    }

    @Override
    public synchronized boolean isLockExist(String lock) {
        if (this.isSupportParallelism()) {
            return true;
        }
        if (this.engineConnLock() != null && this.engineConnLock().isAcquired()) {
            if (StringUtils.isNotBlank((CharSequence)lock)) {
                return lock.equals(this.lockString());
            }
            return false;
        }
        return false;
    }

    public String isLockExist$default$1() {
        return null;
    }

    @Override
    public synchronized Option<String> tryLock(RequestEngineLock requestEngineLock) throws EngineConnExecutorErrorException {
        if (this.engineConnLock() != null && this.engineConnLock().isAcquired()) {
            return None$.MODULE$;
        }
        this.lockType_$eq(requestEngineLock.lockType());
        EngineLockType engineLockType = this.lockType();
        if (EngineLockType.Always.equals(engineLockType)) {
            return this.timedLock(-1L);
        }
        if (EngineLockType.Timed.equals(engineLockType)) {
            return this.timedLock(requestEngineLock.timeout());
        }
        if (engineLockType != null) {
            EngineLockType engineLockType2 = engineLockType;
            this.logger().error(new StringBuilder(19).append("Invalid lockType : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)engineLockType2)).toString());
            return new Some(null);
        }
        throw new MatchError((Object)engineLockType);
    }

    private Option<String> timedLock(long timeout) {
        Executor executor2 = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
        if (executor2 instanceof AccessibleExecutor) {
            AccessibleExecutor accessibleExecutor = (AccessibleExecutor)executor2;
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder(34).append("try to lock for executor state is ").append(accessibleExecutor.getStatus()).toString());
                this.logger().debug(new StringBuilder(31).append("try to lock for executor id is ").append(accessibleExecutor.getId()).toString());
            }
            if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)accessibleExecutor.getStatus()))) {
                this.logger().error(new StringBuilder(40).append("Cannot to lock completed ").append(accessibleExecutor.getStatus()).append(" stats executor").toString());
                return None$.MODULE$;
            }
            if (this.engineConnLock() == null) {
                this.engineConnLock_$eq(new EngineConnTimedLock(timeout));
                ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnAsyncListenerBus().addListener((EventListener)this.engineConnLock());
                this.logger().debug(new StringBuilder(38).append("try to lock for executor get new lock ").append(this.engineConnLock()).toString());
            }
            if (this.engineConnLock().tryAcquire(accessibleExecutor)) {
                this.logger().debug("try to lock for tryAcquire is true ");
                this.lockString_$eq(this.engineConnLock().lock().toString());
                Executor[] executors = (Executor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ExecutorManager$.MODULE$.getInstance().getExecutors())).filter((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)EngineConnTimedLockService.$anonfun$timedLock$1(executor)));
                if (executors != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executors)).isEmpty()) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executors)).foreach((Function1 & Serializable & scala.Serializable)executor -> {
                        EngineConnTimedLockService.$anonfun$timedLock$2(executor);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.logger().error("No valid executors while adding lock.");
                    accessibleExecutor.transition(NodeStatus.Idle);
                }
                ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnAsyncListenerBus().post((Event)new ExecutorLockEvent((Executor)accessibleExecutor, this.lockString()));
                return new Some((Object)this.lockString());
            }
            return None$.MODULE$;
        }
        String msg = "Invalid executor or not instance of SensibleEngine.";
        this.logger().error(msg);
        throw new EngineConnExecutorErrorException(40100, msg);
    }

    @Override
    public synchronized boolean unlock(String lock) {
        this.logger().info(new StringBuilder(58).append("try to unlock for lockEntity is ").append(this.engineConnLock().toString()).append(",and lock is ").append(lock).append(",acquired is ").append(Boolean.toString(this.engineConnLock().isAcquired())).toString());
        if (this.isLockExist(lock)) {
            this.logger().info(new StringBuilder(38).append("try to unlock lockEntity : lockString=").append(this.lockString()).toString());
            this.engineConnLock().release();
            this.lockString_$eq(null);
            return true;
        }
        return false;
    }

    @Override
    @Receiver
    public ResponseEngineUnlock requestUnLock(RequestEngineUnlock requestEngineUnlock) {
        if (StringUtils.isBlank((CharSequence)requestEngineUnlock.lock())) {
            this.logger().error("Invalid requestEngineUnlock: ");
            return new ResponseEngineUnlock(false);
        }
        return new ResponseEngineUnlock(this.unlock(requestEngineUnlock.lock()));
    }

    @Override
    public void onAddLock(ExecutorLockEvent addLockEvent) {
    }

    @Override
    public void onReleaseLock(ExecutorUnLockEvent releaseLockEvent) {
    }

    @Override
    @Receiver
    public ResponseEngineLock requestLock(RequestEngineLock requestEngineLock) {
        return LockService.requestLock$(this, requestEngineLock);
    }

    public static final /* synthetic */ boolean $anonfun$timedLock$1(Executor executor) {
        return executor != null && !executor.isClosed();
    }

    public static final /* synthetic */ void $anonfun$timedLock$2(Executor executor) {
        Executor executor2 = executor;
        if (executor2 instanceof AccessibleExecutor) {
            AccessibleExecutor accessibleExecutor = (AccessibleExecutor)executor2;
            accessibleExecutor.transition(NodeStatus.Idle);
            return;
        }
    }

    public EngineConnTimedLockService() {
        ExecutorLockListener.$init$(this);
        Logging.$init$((Logging)this);
        LockService.$init$(this);
        this.lockType = EngineLockType.Timed;
    }
}

