/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketNode13
extends ComponentBase
implements Runnable,
Pauseable {
    private boolean paused;
    private boolean closed;
    private Socket socket;
    private Receiver receiver;
    private List listenerList = Collections.synchronizedList(new ArrayList());

    public SocketNode13(Socket s, LoggerRepository hierarchy) {
        this.socket = s;
        this.repository = hierarchy;
    }

    public SocketNode13(Socket s, Receiver r) {
        this.socket = s;
        this.receiver = r;
    }

    public void setListener(SocketNodeEventListener l) {
        this.removeSocketNodeEventListener(l);
        this.addSocketNodeEventListener(l);
    }

    public void addSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void run() {
        Exception listenerException = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            ois = null;
            listenerException = e;
            this.getLogger().error((Object)("Exception opening ObjectInputStream to " + this.socket), e);
        }
        if (ois != null) {
            String hostName = this.socket.getInetAddress().getHostName();
            String remoteInfo = hostName + ":" + this.socket.getPort();
            this.fireSocketOpened(remoteInfo);
            try {
                while (!this.isClosed()) {
                    LoggingEvent event = (LoggingEvent)ois.readObject();
                    event.setProperty("hostname", hostName);
                    event.setProperty("log4j.remoteSourceInfo", remoteInfo);
                    if (this.isPaused() || this.isClosed()) continue;
                    if (this.receiver != null) {
                        this.receiver.doPost(event);
                        continue;
                    }
                    Logger remoteLogger = this.repository.getLogger(event.getLoggerName());
                    if (!event.getLevel().isGreaterOrEqual((Priority)remoteLogger.getEffectiveLevel())) continue;
                    remoteLogger.callAppenders(event);
                }
            }
            catch (EOFException e) {
                this.getLogger().info("Caught java.io.EOFException closing connection.");
                listenerException = e;
            }
            catch (SocketException e) {
                this.getLogger().info("Caught java.net.SocketException closing connection.");
                listenerException = e;
            }
            catch (IOException e) {
                this.getLogger().info("Caught java.io.IOException: " + e);
                this.getLogger().info("Closing connection.");
                listenerException = e;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Unexpected exception. Closing connection.", e);
                listenerException = e;
            }
        }
        try {
            if (ois != null) {
                ois.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.listenerList.size() > 0 && !this.isClosed()) {
            this.fireSocketClosedEvent(listenerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSocketClosedEvent(Exception listenerException) {
        List list = this.listenerList;
        synchronized (list) {
            for (SocketNodeEventListener snel : this.listenerList) {
                if (snel == null) continue;
                snel.socketClosedEvent(listenerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSocketOpened(String remoteInfo) {
        List list = this.listenerList;
        synchronized (list) {
            for (SocketNodeEventListener snel : this.listenerList) {
                if (snel == null) continue;
                snel.socketOpened(remoteInfo);
            }
        }
    }

    @Override
    public void setPaused(boolean b) {
        this.paused = b;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void close() throws IOException {
        this.getLogger().debug("closing socket");
        this.closed = true;
        this.socket.close();
        this.fireSocketClosedEvent(null);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

