/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.annotation;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.annotation.JdbcUrl;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class JdbcUrlCondition
implements Condition {
    private static final Logger LOGGER = LogManager.getLogger(JdbcUrlCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment env = context.getEnvironment();
        Map map = metadata.getAnnotationAttributes(JdbcUrl.class.getName());
        if (map != null && map.containsKey("value")) {
            String value = map.get("value").toString();
            String jdbcUrl = env.getProperty("jdbcUrl");
            Boolean isEmbedded = Boolean.parseBoolean(env.getProperty("isEmbedded"));
            boolean result = value.equals("hsqldb") ? jdbcUrl == null || isEmbedded != false : (jdbcUrl == null || isEmbedded != false ? false : (!jdbcUrl.startsWith("jdbc:") ? false : jdbcUrl.substring(5).toLowerCase().startsWith(value.toLowerCase())));
            LOGGER.debug("Returning {} for {}", (Object)result, (Object)value);
            return result;
        }
        LOGGER.debug("No data provided");
        return false;
    }
}

