/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.transform.maven.scan;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.transform.maven.scan.ClassFileInclusionScanner;
import org.apache.logging.log4j.weaver.LocationCacheGenerator;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;

public class SimpleInclusionScanner
implements ClassFileInclusionScanner {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final long lastUpdatedWithinMsecs;
    private final Set<String> sourceIncludes;
    private final Set<String> sourceExcludes;
    private final Log log;

    public SimpleInclusionScanner(long lastUpdateWithinMsecs, Log log) {
        this(lastUpdateWithinMsecs, Collections.singleton("**/*.class"), Collections.singleton("**/*$$Log4j2$$Cache.class"), log);
    }

    public SimpleInclusionScanner(long lastUpdateWithinMsecs, Set<String> sourceIncludes, Set<String> sourceExcludes, Log log) {
        this.lastUpdatedWithinMsecs = lastUpdateWithinMsecs;
        this.sourceIncludes = new HashSet<String>(sourceIncludes);
        this.sourceExcludes = new HashSet<String>(sourceExcludes);
        this.log = log;
    }

    @Override
    public Set<Path> getIncludedClassFiles(Path sourceDir, Path targetDir) {
        Set<Path> potentialSources = SimpleInclusionScanner.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        return potentialSources.stream().filter(source -> this.isLocationCacheStale(sourceDir, targetDir, (Path)source)).collect(Collectors.toSet());
    }

    private static Set<Path> scanForSources(Path sourceDir, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir.toFile());
        scanner.setIncludes(sourceIncludes.toArray(EMPTY_ARRAY));
        scanner.setExcludes(sourceExcludes.toArray(EMPTY_ARRAY));
        scanner.scan();
        return Stream.of(scanner.getIncludedFiles()).map(sourceDir::resolve).collect(Collectors.toSet());
    }

    private boolean isLocationCacheStale(Path sourceDir, Path targetDir, Path source) {
        try {
            Path target = targetDir.resolve(LocationCacheGenerator.getCacheClassFile((Path)source));
            if (!Files.exists(target, new LinkOption[0])) {
                return true;
            }
            FileTime sourceModifiedTime = Files.getLastModifiedTime(sourceDir.resolve(source), new LinkOption[0]);
            FileTime targetModifiedTime = Files.getLastModifiedTime(target, new LinkOption[0]);
            return targetModifiedTime.toMillis() - sourceModifiedTime.toMillis() > this.lastUpdatedWithinMsecs;
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Unable to open file: " + source), (Throwable)e);
            return false;
        }
    }
}

