/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public final class AsyncQueueFullPolicyFactory {
    static final String DEFAULT_POLICY = "Default";
    static final String DISCARDING_POLICY = "Discard";
    private static final Logger LOGGER = StatusLogger.getLogger();

    private AsyncQueueFullPolicyFactory() {
    }

    public static AsyncQueueFullPolicy create(CoreProperties.QueueFullPolicyProperties policy, Logger statusLogger) {
        if (policy.type() != null) {
            if (AsyncQueueFullPolicyFactory.isPolicySelected(policy.type(), DefaultAsyncQueueFullPolicy.class, DEFAULT_POLICY)) {
                return new DefaultAsyncQueueFullPolicy();
            }
            if (AsyncQueueFullPolicyFactory.isPolicySelected(policy.type(), DiscardingAsyncQueueFullPolicy.class, DISCARDING_POLICY)) {
                return AsyncQueueFullPolicyFactory.createDiscardingAsyncQueueFullPolicy(policy, statusLogger);
            }
            return AsyncQueueFullPolicyFactory.createCustomPolicy(policy.type(), statusLogger);
        }
        return new DefaultAsyncQueueFullPolicy();
    }

    private static boolean isPolicySelected(String propertyValue, Class<? extends AsyncQueueFullPolicy> policy, String shortPropertyValue) {
        return shortPropertyValue.equalsIgnoreCase(propertyValue) || policy.getName().equals(propertyValue) || policy.getSimpleName().equals(propertyValue);
    }

    private static AsyncQueueFullPolicy createCustomPolicy(String policyType, Logger statusLogger) {
        try {
            statusLogger.debug("Creating custom AsyncQueueFullPolicy '{}'", (Object)policyType);
            return (AsyncQueueFullPolicy)LoaderUtil.newCheckedInstanceOf((String)policyType, AsyncQueueFullPolicy.class);
        }
        catch (Exception ex) {
            statusLogger.debug("Using DefaultAsyncQueueFullPolicy. Could not create custom AsyncQueueFullPolicy '{}': {}", (Object)policyType, (Object)ex.getMessage(), (Object)ex);
            return new DefaultAsyncQueueFullPolicy();
        }
    }

    private static AsyncQueueFullPolicy createDiscardingAsyncQueueFullPolicy(CoreProperties.QueueFullPolicyProperties policy, Logger statusLogger) {
        statusLogger.debug("Creating custom DiscardingAsyncQueueFullPolicy(discardThreshold:{})", (Object)policy.discardThreshold());
        return new DiscardingAsyncQueueFullPolicy(policy.discardThreshold());
    }
}

