/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmisHttpCookie
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DOT_STR = ".";
    private static final String LOCAL_STR = ".local";
    private static final String QUOTE_STR = "\"";
    private static final String COMMA_STR = ",";
    private static final Pattern HEAD_PATTERN = Pattern.compile("Set-Cookie2?:", 2);
    private static final Pattern NAME_PATTERN = Pattern.compile("([^$=,\u0085\u2028\u2029][^,\n\t\r\r\n\u0085\u2028\u2029]*?)=([^;]*)(;)?", 34);
    private static final Pattern ATTR_PATTERN0 = Pattern.compile("([^;=]*)(?:=([^;]*))?");
    private static final Pattern ATTR_PATTERN1 = Pattern.compile("(,?[^;=]*)(?:=([^;,]*))?((?=.))?");
    private Map<String, Setter> attributeSet = new HashMap<String, Setter>();
    private String comment;
    private String commentURL;
    private boolean discard;
    private String domain;
    private long maxAge = -1L;
    private String name;
    private String path;
    private String portList;
    private boolean secure;
    private String value;
    private int version = 1;

    public static boolean domainMatches(String domain, String host) {
        String newHost;
        if (domain == null || host == null) {
            return false;
        }
        String newDomain = domain.toLowerCase();
        return newDomain.equals(newHost = host.toLowerCase()) || CmisHttpCookie.isValidDomain(newDomain) && CmisHttpCookie.effDomainMatches(newDomain, newHost) && CmisHttpCookie.isValidHost(newDomain, newHost);
    }

    private static boolean effDomainMatches(String domain, String host) {
        String effHost = host.indexOf(DOT_STR) != -1 ? host : host + LOCAL_STR;
        boolean inDomain = domain.equals(effHost);
        inDomain = inDomain || effHost.endsWith(domain) && effHost.length() > domain.length() && domain.startsWith(DOT_STR);
        return inDomain;
    }

    private static boolean isCommaDelim(CmisHttpCookie cookie) {
        String value = cookie.getValue();
        if (value.startsWith(QUOTE_STR) && value.endsWith(QUOTE_STR)) {
            cookie.setValue(value.substring(1, value.length() - 1));
            return false;
        }
        if (cookie.getVersion() == 1 && value.contains(COMMA_STR)) {
            cookie.setValue(value.substring(0, value.indexOf(COMMA_STR)));
            return true;
        }
        return false;
    }

    private static boolean isValidDomain(String domain) {
        if (domain.length() <= 2) {
            return false;
        }
        return domain.substring(1, domain.length() - 1).indexOf(DOT_STR) != -1 || domain.equals(LOCAL_STR);
    }

    private static boolean isValidHost(String domain, String host) {
        boolean matches;
        boolean bl = matches = !host.endsWith(domain);
        if (!matches) {
            String hostSub = host.substring(0, host.length() - domain.length());
            matches = hostSub.indexOf(DOT_STR) == -1;
        }
        return matches;
    }

    public static List<CmisHttpCookie> parse(String header) {
        Matcher matcher = HEAD_PATTERN.matcher(header);
        ArrayList<CmisHttpCookie> list = null;
        CmisHttpCookie cookie = null;
        String headerString = header;
        int version = 0;
        if (matcher.find()) {
            String cookieHead = matcher.group();
            if ("set-cookie2:".equalsIgnoreCase(cookieHead)) {
                version = 1;
            }
            headerString = header.substring(cookieHead.length());
        }
        if ((matcher = NAME_PATTERN.matcher(headerString)).lookingAt()) {
            list = new ArrayList<CmisHttpCookie>();
            cookie = new CmisHttpCookie(matcher.group(1), matcher.group(2));
            cookie.setVersion(version);
            String nameGroup = matcher.group();
            headerString = CmisHttpCookie.isCommaDelim(cookie) ? headerString.substring(nameGroup.indexOf(COMMA_STR)) : headerString.substring(nameGroup.length());
            list.add(cookie);
        } else {
            throw new IllegalArgumentException();
        }
        while (headerString.length() != 0) {
            matcher = cookie.getVersion() == 1 ? ATTR_PATTERN1.matcher(headerString) : ATTR_PATTERN0.matcher(headerString);
            if (!matcher.lookingAt()) continue;
            String attrName = matcher.group(1).trim();
            if (attrName.length() == 0) {
                headerString = headerString.substring(1);
                continue;
            }
            if (attrName.equalsIgnoreCase("port") || attrName.equalsIgnoreCase("expires")) {
                int start = matcher.regionStart();
                matcher = ATTR_PATTERN0.matcher(headerString);
                matcher.region(start, headerString.length());
                matcher.lookingAt();
            } else if (cookie.getVersion() == 1 && attrName.startsWith(COMMA_STR) && (matcher = NAME_PATTERN.matcher(headerString = headerString.substring(1))).lookingAt()) {
                cookie = new CmisHttpCookie(matcher.group(1), matcher.group(2));
                list.add(cookie);
                headerString = headerString.substring(matcher.group().length());
                continue;
            }
            Setter setter = cookie.attributeSet.get(attrName.toLowerCase());
            if (setter != null && !setter.isSet()) {
                String attrValue = matcher.group(2);
                setter.validate(attrValue, cookie);
                setter.setValue(matcher.group(2), cookie);
            }
            headerString = headerString.substring(matcher.end());
        }
        return list;
    }

    public CmisHttpCookie(String name, String value) {
        this.attributeSet.put("comment", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setComment(value);
                if (cookie.getComment() != null) {
                    this.set(true);
                }
            }
        });
        this.attributeSet.put("commenturl", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setCommentURL(value);
                if (cookie.getCommentURL() != null) {
                    this.set(true);
                }
            }
        });
        this.attributeSet.put("discard", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setDiscard(true);
                this.set(true);
            }
        });
        this.attributeSet.put("domain", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setDomain(value);
                if (cookie.getDomain() != null) {
                    this.set(true);
                }
            }
        });
        this.attributeSet.put("max-age", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                try {
                    cookie.setMaxAge(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid max-age!", e);
                }
                this.set(true);
                if (!((Setter)CmisHttpCookie.this.attributeSet.get("version")).isSet()) {
                    cookie.setVersion(1);
                }
            }
        });
        this.attributeSet.put("path", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setPath(value);
                if (cookie.getPath() != null) {
                    this.set(true);
                }
            }
        });
        this.attributeSet.put("port", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setPortlist(value);
                if (cookie.getPortlist() != null) {
                    this.set(true);
                }
            }

            void validate(String v, CmisHttpCookie cookie) {
            }
        });
        this.attributeSet.put("secure", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setSecure(true);
                this.set(true);
            }
        });
        this.attributeSet.put("version", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                try {
                    int v = Integer.parseInt(value);
                    if (v > cookie.getVersion()) {
                        cookie.setVersion(v);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid version!", e);
                }
                if (cookie.getVersion() != 0) {
                    this.set(true);
                }
            }
        });
        this.attributeSet.put("expires", new Setter(){

            void setValue(String value, CmisHttpCookie cookie) {
                cookie.setVersion(0);
                ((Setter)CmisHttpCookie.this.attributeSet.get("version")).set(true);
                if (!((Setter)CmisHttpCookie.this.attributeSet.get("max-age")).isSet()) {
                    ((Setter)CmisHttpCookie.this.attributeSet.get("max-age")).set(true);
                    if (!"en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
                        cookie.setMaxAge(0L);
                        return;
                    }
                    Date date = DateTimeHelper.parseHttpDateTime((String)value);
                    if (date != null) {
                        cookie.setMaxAge((date.getTime() - System.currentTimeMillis()) / 1000L);
                    } else {
                        cookie.setMaxAge(0L);
                    }
                }
            }

            void validate(String v, CmisHttpCookie cookie) {
            }
        });
        String ntrim = name.trim();
        if (!this.isValidName(ntrim)) {
            throw new IllegalArgumentException("Invalid name!");
        }
        this.name = ntrim;
        this.value = value;
    }

    private void attrToString(StringBuilder builder, String attrName, String attrValue) {
        if (attrValue != null && builder != null) {
            builder.append(';');
            builder.append('$');
            builder.append(attrName);
            builder.append("=\"");
            builder.append(attrValue);
            builder.append(QUOTE_STR);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        CmisHttpCookie anotherCookie;
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmisHttpCookie && this.name.equalsIgnoreCase((anotherCookie = (CmisHttpCookie)obj).getName())) {
            boolean equals;
            String anotherDomain = anotherCookie.getDomain();
            boolean bl = this.domain == null ? anotherDomain == null : (equals = this.domain.equalsIgnoreCase(anotherDomain));
            if (equals) {
                String anotherPath = anotherCookie.getPath();
                return this.path == null ? anotherPath == null : this.path.equals(anotherPath);
            }
        }
        return false;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public boolean getDiscard() {
        return this.discard;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPortlist() {
        return this.portList;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasExpired() {
        if (this.maxAge == -1L) {
            return false;
        }
        boolean expired = false;
        if (this.maxAge <= 0L) {
            expired = true;
        }
        return expired;
    }

    public int hashCode() {
        int hashCode = this.name.toLowerCase().hashCode();
        hashCode += this.domain == null ? 0 : this.domain.toLowerCase().hashCode();
        return hashCode += this.path == null ? 0 : this.path.hashCode();
    }

    private boolean isValidName(String n) {
        boolean isValid;
        boolean bl = isValid = n.length() != 0 && n.charAt(0) != '$' && !this.attributeSet.containsKey(n.toLowerCase());
        if (isValid) {
            for (int i = 0; i < n.length(); ++i) {
                char nameChar = n.charAt(i);
                if (nameChar >= '\u0000' && nameChar < '\u007f' && nameChar != ';' && nameChar != ',' && (!Character.isWhitespace(nameChar) || nameChar == ' ')) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public void setCommentURL(String purpose) {
        this.commentURL = purpose;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public void setDomain(String pattern) {
        this.domain = pattern == null ? null : pattern.toLowerCase();
    }

    public void setMaxAge(long expiry) {
        this.maxAge = expiry;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPortlist(String ports) {
        this.portList = ports;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public void setVersion(int v) {
        if (v != 0 && v != 1) {
            throw new IllegalArgumentException("Unknown version!");
        }
        this.version = v;
    }

    public String toString() {
        StringBuilder cookieStr = new StringBuilder();
        cookieStr.append(this.name);
        cookieStr.append('=');
        if (this.version == 0) {
            cookieStr.append(this.value);
        } else if (this.version == 1) {
            cookieStr.append(QUOTE_STR);
            cookieStr.append(this.value);
            cookieStr.append(QUOTE_STR);
            this.attrToString(cookieStr, "Path", this.path);
            this.attrToString(cookieStr, "Domain", this.domain);
            this.attrToString(cookieStr, "Port", this.portList);
        }
        return cookieStr.toString();
    }

    private static abstract class Setter {
        private boolean set = false;

        Setter() {
        }

        boolean isSet() {
            return this.set;
        }

        void set(boolean isSet) {
            this.set = isSet;
        }

        abstract void setValue(String var1, CmisHttpCookie var2);

        void validate(String value, CmisHttpCookie cookie) {
            if (cookie.getVersion() == 1 && value != null && value.contains(CmisHttpCookie.COMMA_STR)) {
                throw new IllegalArgumentException();
            }
        }
    }
}

