/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;

public class RankStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    private TupleStream tupleStream;
    private PriorityQueue<Tuple> top;
    private Comparator<Tuple> comp;
    private boolean finished = false;
    private LinkedList<Tuple> topList;
    private int size;

    public RankStream(TupleStream tupleStream, int size, Comparator<Tuple> comp) {
        this.tupleStream = tupleStream;
        this.top = new PriorityQueue<Tuple>(size, new ReverseComp(comp));
        this.comp = comp;
        this.topList = new LinkedList();
        this.size = size;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        if (!this.finished) {
            while (true) {
                Tuple tuple = this.tupleStream.read();
                if (tuple.EOF) {
                    this.finished = true;
                    int s = this.top.size();
                    for (int i = 0; i < s; ++i) {
                        Tuple t = this.top.poll();
                        this.topList.addFirst(t);
                    }
                    this.topList.addLast(tuple);
                    break;
                }
                Tuple peek = this.top.peek();
                if (this.top.size() >= this.size) {
                    if (this.comp.compare(tuple, peek) >= 0) continue;
                    this.top.poll();
                    this.top.add(tuple);
                    continue;
                }
                this.top.add(tuple);
            }
        }
        return this.topList.pollFirst();
    }

    @Override
    public int getCost() {
        return 0;
    }

    class ReverseComp
    implements Comparator<Tuple>,
    Serializable {
        private Comparator<Tuple> comp;

        public ReverseComp(Comparator<Tuple> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return this.comp.compare(t1, t2) * -1;
        }
    }
}

