/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class GeohashCellFilter {
    public static final String NAME = "geohash_cell";
    public static final String NEIGHBORS = "neighbors";
    public static final String PRECISION = "precision";

    public static Filter create(QueryParseContext context, GeoPointFieldMapper fieldMapper, String geohash, @Nullable List<String> geohashes) {
        if (fieldMapper.geoHashStringMapper() == null) {
            throw new ElasticsearchIllegalArgumentException("geohash filter needs geohash_prefix to be enabled");
        }
        StringFieldMapper geoHashMapper = fieldMapper.geoHashStringMapper();
        if (geohashes == null || geohashes.size() == 0) {
            return geoHashMapper.termFilter(geohash, context);
        }
        geohashes.add(geohash);
        return geoHashMapper.termsFilter(geohashes, context);
    }

    public static class Parser
    implements FilterParser {
        @Inject
        public Parser() {
        }

        @Override
        public String[] names() {
            return new String[]{GeohashCellFilter.NAME, Strings.toCamelCase(GeohashCellFilter.NAME)};
        }

        @Override
        public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            String geohash = null;
            int levels = -1;
            boolean neighbors = false;
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("geohash_cell must be an object");
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String field = parser.text();
                    if (GeohashCellFilter.PRECISION.equals(field)) {
                        token = parser.nextToken();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            levels = parser.intValue();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        double meters = DistanceUnit.parse(parser.text(), DistanceUnit.DEFAULT, DistanceUnit.METERS);
                        levels = GeoUtils.geoHashLevelsForPrecision(meters);
                        continue;
                    }
                    if (GeohashCellFilter.NEIGHBORS.equals(field)) {
                        parser.nextToken();
                        neighbors = parser.booleanValue();
                        continue;
                    }
                    fieldName = field;
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String location = parser.text();
                        if (location.indexOf(",") > 0) {
                            geohash = GeoPoint.parse(parser).geohash();
                            continue;
                        }
                        geohash = location;
                        continue;
                    }
                    geohash = GeoPoint.parse(parser).geohash();
                    continue;
                }
                throw new ElasticsearchParseException("unexpected token [" + (Object)((Object)token) + "]");
            }
            if (geohash == null) {
                throw new QueryParsingException(parseContext.index(), "no geohash value provided to geohash_cell filter");
            }
            MapperService.SmartNameFieldMappers smartMappers = parseContext.smartFieldMappers(fieldName);
            if (smartMappers == null || !smartMappers.hasMapper()) {
                throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
            }
            FieldMapper mapper = smartMappers.mapper();
            if (!(mapper instanceof GeoPointFieldMapper)) {
                throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
            }
            GeoPointFieldMapper geoMapper = (GeoPointFieldMapper)mapper;
            if (!geoMapper.isEnableGeohashPrefix()) {
                throw new QueryParsingException(parseContext.index(), "can't execute geohash_cell on field [" + fieldName + "], geohash_prefix is not enabled");
            }
            if (levels > 0) {
                int len = Math.min(levels, geohash.length());
                geohash = geohash.substring(0, len);
            }
            if (neighbors) {
                return GeohashCellFilter.create(parseContext, geoMapper, geohash, GeoHashUtils.neighbors(geohash));
            }
            return GeohashCellFilter.create(parseContext, geoMapper, geohash, null);
        }
    }

    public static class Builder
    extends BaseFilterBuilder {
        private String field;
        private String geohash;
        private int levels = -1;
        private boolean neighbors;

        public Builder(String field) {
            this(field, null, false);
        }

        public Builder(String field, GeoPoint point) {
            this(field, point.geohash(), false);
        }

        public Builder(String field, String geohash) {
            this(field, geohash, false);
        }

        public Builder(String field, String geohash, boolean neighbors) {
            this.field = field;
            this.geohash = geohash;
            this.neighbors = neighbors;
        }

        public Builder point(GeoPoint point) {
            this.geohash = point.getGeohash();
            return this;
        }

        public Builder point(double lat, double lon) {
            this.geohash = GeoHashUtils.encode(lat, lon);
            return this;
        }

        public Builder geohash(String geohash) {
            this.geohash = geohash;
            return this;
        }

        public Builder precision(int levels) {
            this.levels = levels;
            return this;
        }

        public Builder precision(String precision) {
            double meters = DistanceUnit.parse(precision, DistanceUnit.DEFAULT, DistanceUnit.METERS);
            return this.precision(GeoUtils.geoHashLevelsForPrecision(meters));
        }

        public Builder neighbors(boolean neighbors) {
            this.neighbors = neighbors;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GeohashCellFilter.NAME);
            if (this.neighbors) {
                builder.field(GeohashCellFilter.NEIGHBORS, this.neighbors);
            }
            if (this.levels > 0) {
                builder.field(GeohashCellFilter.PRECISION, this.levels);
            }
            builder.field(this.field, this.geohash);
            builder.endObject();
        }
    }
}

