/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.completion.CompletionSuggester;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;

public class CompletionSuggestParser
implements SuggestContextParser {
    private CompletionSuggester completionSuggester;
    private static final ParseField FUZZINESS = Fuzziness.FIELD.withDeprecation("edit_distance");

    public CompletionSuggestParser(CompletionSuggester completionSuggester) {
        this.completionSuggester = completionSuggester;
    }

    @Override
    public SuggestionSearchContext.SuggestionContext parse(XContentParser parser, MapperService mapperService) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        CompletionSuggestionContext suggestion = new CompletionSuggestionContext(this.completionSuggester);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SuggestUtils.parseSuggestContext(parser, mapperService, fieldName, suggestion) || token != XContentParser.Token.VALUE_BOOLEAN || !"fuzzy".equals(fieldName)) continue;
                suggestion.setFuzzy(parser.booleanValue());
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT && "fuzzy".equals(fieldName)) {
                suggestion.setFuzzy(true);
                String fuzzyConfigName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fuzzyConfigName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (FUZZINESS.match(fuzzyConfigName, ParseField.EMPTY_FLAGS)) {
                        suggestion.setFuzzyEditDistance(Fuzziness.parse(parser).asDistance());
                        continue;
                    }
                    if ("transpositions".equals(fuzzyConfigName)) {
                        suggestion.setFuzzyTranspositions(parser.booleanValue());
                        continue;
                    }
                    if ("min_length".equals(fuzzyConfigName) || "minLength".equals(fuzzyConfigName)) {
                        suggestion.setFuzzyMinLength(parser.intValue());
                        continue;
                    }
                    if ("prefix_length".equals(fuzzyConfigName) || "prefixLength".equals(fuzzyConfigName)) {
                        suggestion.setFuzzyPrefixLength(parser.intValue());
                        continue;
                    }
                    if (!"unicode_aware".equals(fuzzyConfigName) && !"unicodeAware".equals(fuzzyConfigName)) continue;
                    suggestion.setFuzzyUnicodeAware(parser.booleanValue());
                }
                continue;
            }
            throw new ElasticsearchIllegalArgumentException("suggester[completion]  doesn't support field [" + fieldName + "]");
        }
        suggestion.mapper(mapperService.smartNameFieldMapper(suggestion.getField()));
        return suggestion;
    }
}

