/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.inmemory.content.fractal.FractalGenerator;
import org.apache.chemistry.opencmis.inmemory.content.loremipsum.LoremIpsum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGenerator {
    private static final int KILO = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(ObjectGenerator.class);
    private final BindingsObjectFactory fFactory;
    NavigationService fNavSvc;
    ObjectService fObjSvc;
    RepositoryService fRepSvc;
    private final String fRepositoryId;
    private boolean fCleanup;
    List<String> fTopLevelDocsCreated;
    List<String> fTopLevelFoldersCreated;
    private int fNoDocumentsToCreate;
    private String fDocTypeId = BaseTypeId.CMIS_DOCUMENT.value();
    private String fFolderTypeId = BaseTypeId.CMIS_FOLDER.value();
    private List<String> fStringPropertyIdsToSetForDocument;
    private List<String> fStringPropertyIdsToSetForFolder;
    private int fDocumentsInTotalCount = 0;
    private int fFoldersInTotalCount = 0;
    private int fContentSizeInK = 0;
    private ContentKind fContentKind;
    private static final String NAMEPROPVALPREFIXDOC = "My_Document-";
    private static final String NAMEPROPVALPREFIXFOLDER = "My_Folder-";
    private static final String STRINGPROPVALPREFIXDOC = "My Doc StringProperty ";
    private static final String STRINGPROPVALPREFIXFOLDER = "My Folder StringProperty ";
    private int propValCounterDocString = 0;
    private int propValCounterFolderString = 0;
    private boolean fUseUuids;
    private FractalGenerator fractalGenerator = null;

    public ObjectGenerator(BindingsObjectFactory factory, NavigationService navSvc, ObjectService objSvc, RepositoryService repSvc, String repositoryId, ContentKind contentKind) {
        this.fFactory = factory;
        this.fNavSvc = navSvc;
        this.fObjSvc = objSvc;
        this.fRepSvc = repSvc;
        this.fRepositoryId = repositoryId;
        this.fStringPropertyIdsToSetForDocument = new ArrayList<String>();
        this.fStringPropertyIdsToSetForFolder = new ArrayList<String>();
        this.fNoDocumentsToCreate = 0;
        this.fUseUuids = false;
        this.fCleanup = false;
        this.fTopLevelDocsCreated = new ArrayList<String>();
        this.fTopLevelFoldersCreated = new ArrayList<String>();
        this.fContentKind = contentKind;
    }

    public void setNumberOfDocumentsToCreatePerFolder(int noDocumentsToCreate) {
        this.fNoDocumentsToCreate = noDocumentsToCreate;
    }

    public void setFolderTypeId(String folderTypeId) {
        this.fFolderTypeId = folderTypeId;
    }

    public void setDocumentTypeId(String docTypeId) {
        this.fDocTypeId = docTypeId;
    }

    public void setDocumentPropertiesToGenerate(List<String> propertyIds) {
        this.fStringPropertyIdsToSetForDocument = propertyIds;
    }

    public void setFolderPropertiesToGenerate(List<String> propertyIds) {
        this.fStringPropertyIdsToSetForFolder = propertyIds;
    }

    public void setContentSizeInKB(int sizeInK) {
        this.fContentSizeInK = sizeInK;
    }

    public ContentKind getContentKind() {
        return this.fContentKind;
    }

    public void setLoreIpsumGenerator(ContentKind contentKind) {
        this.fContentKind = contentKind;
    }

    public void setCleanUpAfterCreate(boolean doCleanup) {
        this.fCleanup = doCleanup;
    }

    public void createFolderHierachy(int levels, int childrenPerLevel, String rootFolderId) {
        this.resetCounters();
        this.fTopLevelFoldersCreated.clear();
        this.fTopLevelDocsCreated.clear();
        this.createFolderHierachy(rootFolderId, 0, levels, childrenPerLevel);
        if (this.fCleanup) {
            this.deleteTree();
        }
    }

    public void setUseUuidsForNames(boolean useUuids) {
        this.fUseUuids = useUuids;
    }

    public String getFolderId(String rootId, int level, int index) {
        String objectId = rootId;
        String requiredProperties = "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId";
        for (int i = 0; i < level; ++i) {
            ObjectInFolderList result = this.fNavSvc.getChildren(this.fRepositoryId, objectId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", "cmis:objectTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(true), BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), null);
            List children = result.getObjects();
            ObjectData child = ((ObjectInFolderData)children.get(index)).getObject();
            objectId = (String)((PropertyData)child.getProperties().getProperties().get("cmis:objectId")).getFirstValue();
        }
        return objectId;
    }

    public String getDocumentId(String folderId, int index) {
        String docId = null;
        String requiredProperties = "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId";
        ObjectInFolderList result = this.fNavSvc.getChildren(this.fRepositoryId, folderId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", "cmis:objectTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(true), BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), null);
        List children = result.getObjects();
        int numDocsFound = 0;
        for (int i = 0; i < children.size(); ++i) {
            ObjectData child = ((ObjectInFolderData)children.get(i)).getObject();
            docId = (String)((PropertyData)child.getProperties().getProperties().get("cmis:objectId")).getFirstValue();
            if (!child.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT)) continue;
            if (numDocsFound == index) {
                return docId;
            }
            ++numDocsFound;
        }
        return docId;
    }

    public int getDocumentsInTotal() {
        return this.fDocumentsInTotalCount;
    }

    public int getFoldersInTotal() {
        return this.fFoldersInTotalCount;
    }

    public int getObjectsInTotal() {
        return this.fDocumentsInTotalCount + this.fFoldersInTotalCount;
    }

    public String createSingleDocument(String folderId) {
        String objectId = this.createDocument(folderId, 0, 0);
        if (this.fCleanup) {
            this.deleteObject(objectId);
        }
        return objectId;
    }

    public String[] createDocuments(String folderId, int count) {
        String[] result;
        int i;
        for (i = 0; i < count; ++i) {
            String id = this.createDocument(folderId, 0, 0);
            this.fTopLevelDocsCreated.add(id);
        }
        if (this.fCleanup) {
            this.deleteTree();
            result = null;
        } else {
            result = new String[count];
            for (i = 0; i < this.fTopLevelDocsCreated.size(); ++i) {
                result[i] = this.fTopLevelDocsCreated.get(i);
            }
        }
        return result;
    }

    public String[] createFolders(String folderId, int count) {
        String[] result;
        int i;
        for (i = 0; i < count; ++i) {
            this.createFolder(folderId);
        }
        if (this.fCleanup) {
            this.deleteTree();
            result = null;
        } else {
            result = new String[count];
            for (i = 0; i < this.fTopLevelFoldersCreated.size(); ++i) {
                result[i] = this.fTopLevelFoldersCreated.get(i);
            }
        }
        return result;
    }

    public void resetCounters() {
        this.fDocumentsInTotalCount = 0;
        this.fFoldersInTotalCount = 0;
    }

    private void createFolderHierachy(String parentId, int level, int levels, int childrenPerLevel) {
        String id = null;
        if (level >= levels) {
            return;
        }
        LOG.debug(" create folder for parent id: " + parentId + ", in level " + level + ", max levels " + levels);
        for (int i = 0; i < childrenPerLevel; ++i) {
            Properties props = this.createFolderProperties(i, level);
            id = this.fObjSvc.createFolder(this.fRepositoryId, props, parentId, null, null, null, null);
            if (level == 0) {
                this.fTopLevelFoldersCreated.add(id);
            }
            if (id == null) continue;
            ++this.fFoldersInTotalCount;
            this.createFolderHierachy(id, level + 1, levels, childrenPerLevel);
        }
        for (int j = 0; j < this.fNoDocumentsToCreate; ++j) {
            id = this.createDocument(parentId, j, level);
            if (level != 0) continue;
            this.fTopLevelDocsCreated.add(id);
        }
    }

    private String createFolder(String parentId) {
        Properties props = this.createFolderProperties(0, 0);
        String id = null;
        id = this.fObjSvc.createFolder(this.fRepositoryId, props, parentId, null, null, null, null);
        this.fTopLevelFoldersCreated.add(id);
        return id;
    }

    private String createDocument(String folderId, int no, int level) {
        ContentStream contentStream = null;
        VersioningState versioningState = VersioningState.NONE;
        List policies = null;
        Acl addACEs = null;
        Acl removeACEs = null;
        ExtensionsData extension = null;
        LOG.debug("create document in folder " + folderId);
        Properties props = this.createDocumentProperties(no, level);
        String id = null;
        if (this.fContentSizeInK > 0) {
            switch (this.fContentKind) {
                case STATIC_TEXT: {
                    contentStream = this.createContentStaticText();
                    break;
                }
                case LOREM_IPSUM_TEXT: {
                    contentStream = this.createContentLoremIpsumText();
                    break;
                }
                case LOREM_IPSUM_HTML: {
                    contentStream = this.createContentLoremIpsumHtml();
                    break;
                }
                case IMAGE_FRACTAL_JPEG: {
                    contentStream = this.createContentFractalimageJpeg();
                }
            }
        }
        if (null == (id = this.fObjSvc.createDocument(this.fRepositoryId, props, folderId, contentStream, versioningState, policies, addACEs, removeACEs, extension))) {
            LOG.error("createDocument failed.");
        }
        ++this.fDocumentsInTotalCount;
        return id;
    }

    private void deleteTree() {
        for (String id : this.fTopLevelDocsCreated) {
            this.deleteObject(id);
        }
        for (String id : this.fTopLevelFoldersCreated) {
            this.fObjSvc.deleteTree(this.fRepositoryId, id, Boolean.valueOf(true), UnfileObject.DELETE, Boolean.valueOf(true), null);
        }
    }

    private void deleteObject(String objectId) {
        this.fObjSvc.deleteObject(this.fRepositoryId, objectId, Boolean.valueOf(true), null);
    }

    public ContentStream createContentLoremIpsumHtml() {
        ContentStreamImpl content = new ContentStreamImpl();
        content.setFileName("data.html");
        content.setMimeType("text/html");
        int len = this.fContentSizeInK * 1024;
        LoremIpsum ipsum = new LoremIpsum();
        String text = ipsum.generateParagraphsFullHtml(len, true);
        content.setStream((InputStream)new ByteArrayInputStream(IOUtils.toUTF8Bytes((String)text)));
        return content;
    }

    public ContentStream createContentLoremIpsumText() {
        ContentStreamImpl content = new ContentStreamImpl();
        content.setFileName("data.txt");
        content.setMimeType("text/plain");
        int len = this.fContentSizeInK * 1024;
        LoremIpsum ipsum = new LoremIpsum();
        String text = ipsum.generateParagraphsPlainText(len, 80, true);
        content.setStream((InputStream)new ByteArrayInputStream(IOUtils.toUTF8Bytes((String)text)));
        return content;
    }

    public ContentStream createContentStaticText() {
        ContentStreamImpl content = new ContentStreamImpl();
        content.setFileName("data.txt");
        content.setMimeType("text/plain");
        int len = this.fContentSizeInK * 1024;
        byte[] b = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 12, 10, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 12, 10};
        ByteArrayOutputStream ba = new ByteArrayOutputStream(len);
        try {
            for (int j = 0; j < this.fContentSizeInK; ++j) {
                for (int i = 0; i < 32; ++i) {
                    ba.write(b);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fill content stream with data", e);
        }
        content.setStream((InputStream)new ByteArrayInputStream(ba.toByteArray()));
        return content;
    }

    public ContentStream createContentFractalimageJpeg() {
        if (null == this.fractalGenerator) {
            this.fractalGenerator = new FractalGenerator();
        }
        ContentStreamImpl content = null;
        try {
            ByteArrayOutputStream bos = this.fractalGenerator.generateFractal();
            content = new ContentStreamImpl();
            content.setFileName("image.jpg");
            content.setMimeType("image/jpeg");
            content.setStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
            bos.close();
        }
        catch (IOException e) {
            System.err.println("Error when generating fractal image: " + e);
            e.printStackTrace();
        }
        return content;
    }

    private Properties createFolderProperties(int no, int level) {
        ArrayList<Object> properties = new ArrayList<Object>();
        properties.add(this.fFactory.createPropertyStringData("cmis:name", this.generateFolderNameValue(no, level)));
        properties.add(this.fFactory.createPropertyIdData("cmis:objectTypeId", this.fFolderTypeId));
        for (String stringPropId : this.fStringPropertyIdsToSetForFolder) {
            properties.add(this.fFactory.createPropertyStringData(stringPropId, this.generateStringPropValueFolder()));
        }
        Properties props = this.fFactory.createPropertiesData(properties);
        return props;
    }

    private Properties createDocumentProperties(int no, int level) {
        ArrayList<Object> properties = new ArrayList<Object>();
        properties.add(this.fFactory.createPropertyStringData("cmis:name", this.generateDocNameValue(no, level)));
        properties.add(this.fFactory.createPropertyIdData("cmis:objectTypeId", this.fDocTypeId));
        for (String stringPropId : this.fStringPropertyIdsToSetForDocument) {
            properties.add(this.fFactory.createPropertyStringData(stringPropId, this.generateStringPropValueDoc()));
        }
        Properties props = this.fFactory.createPropertiesData(properties);
        return props;
    }

    private synchronized int incrementPropCounterDocStringProp() {
        return this.propValCounterDocString++;
    }

    private synchronized int incrementPropCounterFolderStringProp() {
        return this.propValCounterFolderString++;
    }

    private String generateDocNameValue(int no, int level) {
        if (this.fUseUuids) {
            return UUID.randomUUID().toString();
        }
        return NAMEPROPVALPREFIXDOC + level + "-" + no;
    }

    private String generateFolderNameValue(int no, int level) {
        if (this.fUseUuids) {
            return UUID.randomUUID().toString();
        }
        return NAMEPROPVALPREFIXFOLDER + level + "-" + no;
    }

    private String generateStringPropValueDoc() {
        return STRINGPROPVALPREFIXDOC + this.incrementPropCounterDocStringProp();
    }

    private String generateStringPropValueFolder() {
        return STRINGPROPVALPREFIXFOLDER + this.incrementPropCounterFolderStringProp();
    }

    public void dumpFolder(String folderId, String propertyFilter) {
        LOG.debug("starting dumpFolder() id " + folderId + " ...");
        boolean allRequiredPropertiesArePresent = propertyFilter != null && propertyFilter.equals("*");
        String requiredProperties = allRequiredPropertiesArePresent ? propertyFilter : "cmis:objectId,cmis:name,cmis:objectTypeId,cmis:baseTypeId";
        String propertyFilterIntern = allRequiredPropertiesArePresent ? propertyFilter : requiredProperties;
        this.dumpFolder(folderId, propertyFilterIntern, 0);
    }

    private void dumpFolder(String folderId, String propertyFilter, int depth) {
        boolean allRequiredPropertiesArePresent = propertyFilter.equals("*");
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            prefix.append("   ");
        }
        ObjectInFolderList result = this.fNavSvc.getChildren(this.fRepositoryId, folderId, propertyFilter, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(true), BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), null);
        List folders = result.getObjects();
        if (null != folders) {
            LOG.debug(prefix + "found " + folders.size() + " children in folder " + folderId);
            int no = 0;
            for (ObjectInFolderData folder : folders) {
                LOG.debug(prefix.toString() + ++no + ": found object with id: " + folder.getObject().getId() + " and path segment: " + folder.getPathSegment());
                this.dumpObjectProperties(folder.getObject(), depth, propertyFilter, !allRequiredPropertiesArePresent);
                String objectTypeBaseId = folder.getObject().getBaseTypeId().value();
                if (objectTypeBaseId.equals(BaseTypeId.CMIS_FOLDER.value())) {
                    this.dumpFolder(folder.getObject().getId(), propertyFilter, depth + 1);
                    continue;
                }
                if (!objectTypeBaseId.equals(BaseTypeId.CMIS_DOCUMENT.value())) continue;
                this.dumpObjectProperties(folder.getObject(), depth + 1, propertyFilter, !allRequiredPropertiesArePresent);
            }
        }
        LOG.debug("");
    }

    private void dumpObjectProperties(ObjectData object, int depth, String propertyFilter, boolean mustFetchProperties) {
        Map propMap;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            prefix.append("   ");
        }
        LOG.debug(prefix + "found object id " + object.getId());
        if (mustFetchProperties) {
            String objId = (String)((PropertyData)object.getProperties().getProperties().get("cmis:objectId")).getFirstValue();
            Properties props = this.fObjSvc.getProperties(this.fRepositoryId, objId, propertyFilter, null);
            propMap = props.getProperties();
        } else {
            propMap = object.getProperties().getProperties();
        }
        StringBuilder valueStr = new StringBuilder("[");
        for (Map.Entry entry : propMap.entrySet()) {
            if (((PropertyData)entry.getValue()).getValues().size() > 1) {
                if (((PropertyData)entry.getValue()).getFirstValue() instanceof GregorianCalendar) {
                    for (Object obj : ((PropertyData)entry.getValue()).getValues()) {
                        GregorianCalendar cal = (GregorianCalendar)obj;
                        valueStr.append(df.format(cal.getTime())).append(", ");
                    }
                    valueStr.append("]");
                } else {
                    valueStr = new StringBuilder(((PropertyData)entry.getValue()).getValues().toString());
                }
            } else {
                Object value = ((PropertyData)entry.getValue()).getFirstValue();
                if (null != value) {
                    valueStr = new StringBuilder(value.toString());
                    if (value instanceof GregorianCalendar) {
                        valueStr = new StringBuilder(df.format(((GregorianCalendar)((PropertyData)entry.getValue()).getFirstValue()).getTime()));
                    }
                }
            }
            LOG.debug(prefix + (String)entry.getKey() + ": " + valueStr);
        }
        LOG.debug("");
    }

    public void createTypes(TypeDefinitionList typeDefList) {
    }

    public static enum ContentKind {
        STATIC_TEXT,
        LOREM_IPSUM_TEXT,
        LOREM_IPSUM_HTML,
        IMAGE_FRACTAL_JPEG;

    }
}

