/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class InterpolatedMediaExpression
extends MediaExpression {
    private Expression expression;

    public InterpolatedMediaExpression(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public InterpolatedMediaExpression(HiddenTokenAwareTree underlyingStructure, Expression expression) {
        this(underlyingStructure);
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.INTERPOLATED_MEDIA_EXPRESSION;
    }

    @Override
    public InterpolatedMediaExpression clone() {
        InterpolatedMediaExpression result = (InterpolatedMediaExpression)super.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

